<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\SitesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Sites');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="sites-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Manage Sites'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
            //['class' => 'yii\grid\SerialColumn'],

            'siteID',
            'siteName',
            'siteAddress',
            'siteLatitude',
            'siteLongitude',
            //'siteImage',
            //'fixedCharges',
            //'ebKWH',
            //'dgKwh',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, app\Models\Sites $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'siteID' => $model->siteID]);
                 }
            ],
        ],
    ]); ?>


</div>
