<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\ShiftsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Shifts');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="shifts-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Add New Shifts'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php  echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
           // ['class' => 'yii\grid\SerialColumn'],

            //'shiftID',
            //'siteID',
            'shiftName',
            'shiftStartHour',
            'shiftStartMin',
            'shiftEndHour',
            'shiftEndMin',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\Models\Shifts $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'shiftID' => $model->shiftID]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
