<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\MapMaster */

$this->title = $model->mapMasterID;
$this->params['breadcrumbs'][] = ['label' => 'Map Masters', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="map-master-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'mapMasterID' => $model->mapMasterID], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'mapMasterID' => $model->mapMasterID], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'mapMasterID',
            'mapMasterCode',
            'mapMasterName',
            'sortID',
            'dataTypeName',
        ],
    ]) ?>

</div>
