<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model app\models\Gateway */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="gateway-form">

    <?php
   
    $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'siteID')->dropDownList(        
            ArrayHelper::map($datasite,'siteID','siteName'),
            
            ['options' => [$dataProvider[0]['siteID'] => ['Selected'=>'selected']]],
            [
            'prompt' => 'Select Site'
    ]) ?>

    <?= $form->field($model, 'gatewaySerialNumber')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'gatewayName')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'gatewayTypeID')->dropDownList(        
            ArrayHelper::map($datagatewayType,'gatewayTypeID','gatewayTypeName'),
            
            ['options' => [$dataProvider[0]['gatewayTypeID'] => ['Selected'=>'selected']]],
            [
            'prompt' => 'Select Gateway Type'
    ]) ?>


    <?= $form->field($model, 'gatewayMobileNumber')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'gatewayDataURL')->textInput(['maxlength' => true]) ?>

    
    <?php echo $form->field($model, 'isLive')->dropDownList(
			['1' => 'Yes', '0' => 'No']); ?>

    <?php // $form->field($model, 'isDebug')->textInput() ?>

    <?= $form->field($model, 'comMethod')->textInput() ?>

    <?= $form->field($model, 'userID')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'password')->passwordInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'dataInterval')->textInput() ?>

    <?= $form->field($model, 'statusInterval')->textInput() ?>
    
    <?php echo $form->field($model, 'baudRate')->dropDownList(
			['9600' => '9600', '19200' => '19200', '38400' => '38400', '57600' => '57600', '115200' => '115200']
			); ?>

    <?php echo $form->field($model, 'lineControl')->dropDownList(
			['8N1'=>'8N1', '8E1'=>'8E1', '8O1'=>'8O1', '8N2'=>'8N2', '8E2'=>'8E2', '8O2'=>'8O2']
			); ?>


    <?= $form->field($model, 'retryCount')->textInput() ?>

    <?php echo $form->field($model, 'deviceType')->dropDownList(
			['RS485'=>'RS485', 'TCPIP'=>'TCPIP']
			); ?>

    <?php //$form->field($model, 'updateConfigure')->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
