<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\DeviceTypeSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Device Types';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="device-type-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Add New', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
           // ['class' => 'yii\grid\SerialColumn'],

           // 'deviceTypeID',
            'deviceTypeName',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\DeviceType $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'deviceTypeID' => $model->deviceTypeID]);
                 }
            ],
        ],
    ]); ?>


</div>
