<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $searchModel app\models\DeviceMasterSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Device Masters';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="device-master-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Add New', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php  //echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
            //['class' => 'yii\grid\SerialColumn'],

            'deviceMasterID',
            'deviceCompany',
            'deviceModel',
            'deviceTypeName',
            'isAvailable',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\DeviceMaster $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'deviceMasterID' => $model->deviceMasterID]);
                 }
            ],
        ],
    ]); ?>


</div>
