<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\AdminSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Admins');
$this->params['breadcrumbs'][] = $this->title;
if(isset($_REQUEST['pid']))
$pid=$_REQUEST['pid'];
else
$pid=2;
?>
<div class="admin-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Add New Admin'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
            //['class' => 'yii\grid\SerialColumn'],

            'AdminID',
            'AdminName',
            'AdminEmail:email',
            //'AdminPassword',
            'AdminType',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, app\Models\Admin $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'AdminID' => $model->AdminID,'pid' => 2]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
