/*
 Highcharts JS v10.3.3 (2023-01-20)

 Wind barb series module

 (c) 2010-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(a){"object"===typeof module&&module.exports?(a["default"]=a,module.exports=a):"function"===typeof define&&define.amd?define("highcharts/modules/windbarb",["highcharts"],function(b){a(b);a.Highcharts=b;return a}):a("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(a){function b(a,e,r,b){a.hasOwnProperty(e)||(a[e]=b.apply(null,r),"function"===typeof CustomEvent&&window.dispatchEvent(new CustomEvent("HighchartsModuleLoaded",{detail:{path:e,module:a[e]}})))}a=a?a._modules:{};b(a,
"Extensions/DataGrouping/ApproximationRegistry.js",[],function(){return{}});b(a,"Series/OnSeriesComposition.js",[a["Series/Column/ColumnSeries.js"],a["Core/Series/Series.js"],a["Core/Utilities.js"]],function(a,e,b){var r=a.prototype,h=e.prototype,m=b.defined,v=b.stableSort,q;(function(a){function b(a){return h.getPlotBox.call(this.options.onSeries&&this.chart.get(this.options.onSeries)||this,a)}function q(){r.translate.apply(this);var a=this,k=a.options,f=a.chart,d=a.points,c=k.onSeries,x=(c=c&&f.get(c))&&
c.options.step,t=c&&c.points,g=f.inverted,b=a.xAxis,q=a.yAxis;f=d.length-1;var e;k=k.onKey||"y";var h=t&&t.length,y=0,n;if(c&&c.visible&&h){y=(c.pointXOffset||0)+(c.barW||0)/2;var l=c.currentDataGrouping;var w=t[h-1].x+(l?l.totalRange:0);v(d,function(d,c){return d.x-c.x});for(k="plot"+k[0].toUpperCase()+k.substr(1);h--&&d[f];){var p=t[h];l=d[f];l.y=p.y;if(p.x<=l.x&&"undefined"!==typeof p[k]){if(l.x<=w&&(l.plotY=p[k],p.x<l.x&&!x&&(n=t[h+1])&&"undefined"!==typeof n[k])){var u=(l.x-p.x)/(n.x-p.x);l.plotY+=
u*(n[k]-p[k]);l.y+=u*(n.y-p.y)}f--;h++;if(0>f)break}}}d.forEach(function(c,x){c.plotX+=y;if("undefined"===typeof c.plotY||g)0<=c.plotX&&c.plotX<=b.len?g?(c.plotY=b.translate(c.x,0,1,0,1),c.plotX=m(c.y)?q.translate(c.y,0,0,0,1):0):c.plotY=(b.opposite?0:a.yAxis.len)+b.offset:c.shapeArgs={};if((e=d[x-1])&&e.plotX===c.plotX){"undefined"===typeof e.stackIndex&&(e.stackIndex=0);var t=e.stackIndex+1}c.stackIndex=t});this.onSeries=c}var e=[];a.compose=function(a){if(-1===e.indexOf(a)){e.push(a);var k=a.prototype;
k.getPlotBox=b;k.translate=q}return a};a.getPlotBox=b;a.translate=q})(q||(q={}));return q});b(a,"Series/Windbarb/WindbarbPoint.js",[a["Core/Utilities.js"],a["Series/Column/ColumnSeries.js"]],function(a,b){var e=this&&this.__extends||function(){var a=function(b,e){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var e in b)b.hasOwnProperty(e)&&(a[e]=b[e])};return a(b,e)};return function(b,e){function h(){this.constructor=b}a(b,e);b.prototype=
null===e?Object.create(e):(h.prototype=e.prototype,new h)}}(),n=a.isNumber;return function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.beaufort=void 0;b.beaufortLevel=void 0;b.direction=void 0;b.options=void 0;b.series=void 0;return b}e(b,a);b.prototype.isValid=function(){return n(this.value)&&0<=this.value};return b}(b.prototype.pointClass)});b(a,"Series/Windbarb/WindbarbSeries.js",[a["Core/Animation/AnimationUtilities.js"],a["Extensions/DataGrouping/ApproximationRegistry.js"],
a["Core/Globals.js"],a["Series/OnSeriesComposition.js"],a["Core/Series/SeriesRegistry.js"],a["Core/Utilities.js"],a["Series/Windbarb/WindbarbPoint.js"]],function(a,b,r,u,h,m,v){var e=this&&this.__extends||function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,d){a.__proto__=d}||function(a,d){for(var c in d)d.hasOwnProperty(c)&&(a[c]=d[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=
d.prototype,new c)}}(),n=a.animObject,w=h.series,z=h.seriesTypes.column;a=m.extend;var B=m.merge,A=m.pick;m=function(a){function f(){var d=null!==a&&a.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}e(f,a);f.registerApproximation=function(){b.windbarb||(b.windbarb=function(a,c){var d=0,b=0,g,e=a.length;for(g=0;g<e;g++)d+=a[g]*Math.cos(c[g]*r.deg2rad),b+=a[g]*Math.sin(c[g]*r.deg2rad);return[a.reduce(function(a,c){return a+c},0)/a.length,Math.atan2(b,d)/r.deg2rad]})};
f.prototype.init=function(a,c){f.registerApproximation();w.prototype.init.call(this,a,c)};f.prototype.pointAttribs=function(a,c){var b=this.options;a=a.color||this.color;var d=this.options.lineWidth;c&&(a=b.states[c].color||a,d=(b.states[c].lineWidth||d)+(b.states[c].lineWidthPlus||0));return{stroke:a,"stroke-width":d}};f.prototype.windArrow=function(a){var c=1.943844*a.value,b=this.options.vectorLength/20,d=-10;if(a.isNull)return[];if(0===a.beaufortLevel)return this.chart.renderer.symbols.circle(-10*
b,-10*b,20*b,20*b);a=[["M",0,7*b],["L",-1.5*b,7*b],["L",0,10*b],["L",1.5*b,7*b],["L",0,7*b],["L",0,-10*b]];var g=(c-c%50)/50;if(0<g)for(;g--;)a.push(-10===d?["L",0,d*b]:["M",0,d*b],["L",5*b,d*b+2],["L",0,d*b+4]),c-=50,d+=7;g=(c-c%10)/10;if(0<g)for(;g--;)a.push(-10===d?["L",0,d*b]:["M",0,d*b],["L",7*b,d*b]),c-=10,d+=3;g=(c-c%5)/5;if(0<g)for(;g--;)a.push(-10===d?["L",0,d*b]:["M",0,d*b],["L",4*b,d*b]),c-=5,d+=3;return a};f.prototype.drawPoints=function(){var a=this.chart,b=this.yAxis,e=a.inverted,f=
this.options.vectorLength/2;this.points.forEach(function(c){var d=c.plotX,g=c.plotY;!1===this.options.clip||a.isInsidePlot(d,0)?(c.graphic||(c.graphic=this.chart.renderer.path().add(this.markerGroup).addClass("highcharts-point highcharts-color-"+A(c.colorIndex,c.series.colorIndex))),c.graphic.attr({d:this.windArrow(c),translateX:d+this.options.xOffset,translateY:g+this.options.yOffset,rotation:c.direction}),this.chart.styledMode||c.graphic.attr(this.pointAttribs(c))):c.graphic&&(c.graphic=c.graphic.destroy());
c.tooltipPos=[d+this.options.xOffset+(e&&!this.onSeries?f:0),g+this.options.yOffset-(e?0:f+b.pos-a.plotTop)]},this)};f.prototype.animate=function(a){a?this.markerGroup.attr({opacity:.01}):this.markerGroup.animate({opacity:1},n(this.options.animation))};f.prototype.markerAttribs=function(a,b){return{}};f.prototype.getExtremes=function(){return{}};f.prototype.shouldShowTooltip=function(b,c,e){void 0===e&&(e={});e.ignoreX=this.chart.inverted;e.ignoreY=!e.ignoreX;return a.prototype.shouldShowTooltip.call(this,
b,c,e)};f.defaultOptions=B(z.defaultOptions,{dataGrouping:{enabled:!0,approximation:"windbarb",groupPixelWidth:30},lineWidth:2,onSeries:null,states:{hover:{lineWidthPlus:0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> {series.name}: <b>{point.value}</b> ({point.beaufort})<br/>'},vectorLength:20,colorKey:"value",yOffset:-20,xOffset:0});return f}(z);u.compose(m);a(m.prototype,{beaufortFloor:[0,.3,1.6,3.4,5.5,8,10.8,13.9,17.2,20.8,24.5,28.5,32.7],beaufortName:"Calm;Light air;Light breeze;Gentle breeze;Moderate breeze;Fresh breeze;Strong breeze;Near gale;Gale;Strong gale;Storm;Violent storm;Hurricane".split(";"),
invertible:!1,parallelArrays:["x","value","direction"],pointArrayMap:["value","direction"],pointClass:v,trackerGroups:["markerGroup"],translate:function(){var a=this.beaufortFloor,b=this.beaufortName;u.translate.call(this);this.points.forEach(function(d){for(var c=0;c<a.length&&!(a[c]>d.value);c++);d.beaufortLevel=c-1;d.beaufort=b[c-1]})}});m.registerApproximation();h.registerSeriesType("windbarb",m);"";return m});b(a,"masters/modules/windbarb.src.js",[],function(){})});
//# sourceMappingURL=windbarb.js.map