<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Sites;

/**
 * SitesSearch represents the model behind the search form of `app\models\Sites`.
 */
class SitesSearch extends Sites
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['siteID'], 'integer'],
            [['siteName', 'siteAddress', 'siteLatitude', 'siteLongitude', 'siteImage'], 'safe'],
            [['fixedCharges', 'ebKWH', 'dgKwh'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Sites::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'siteID' => $this->siteID,
            'fixedCharges' => $this->fixedCharges,
            'ebKWH' => $this->ebKWH,
            'dgKwh' => $this->dgKwh,
        ]);

        $query->andFilterWhere(['like', 'siteName', $this->siteName])
            ->andFilterWhere(['like', 'siteAddress', $this->siteAddress])
            ->andFilterWhere(['like', 'siteLatitude', $this->siteLatitude])
            ->andFilterWhere(['like', 'siteLongitude', $this->siteLongitude])
            ->andFilterWhere(['like', 'siteImage', $this->siteImage]);

        return $dataProvider;
    }
}
