<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "sites".
 *
 * @property int $siteID
 * @property string|null $siteName
 * @property string|null $siteAddress
 * @property string|null $siteLatitude
 * @property string|null $siteLongitude
 * @property string|null $siteImage
 * @property float|null $fixedCharges
 * @property float|null $ebKWH
 * @property float|null $dgKwh
 */
class Sites extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'sites';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['siteID'], 'required'],
            [['siteID'], 'integer'],
            [['fixedCharges', 'ebKWH', 'dgKwh'], 'number'],
            [['siteName'], 'string', 'max' => 150],
            [['siteAddress'], 'string', 'max' => 255],
            [['siteLatitude', 'siteLongitude'], 'string', 'max' => 50],
            [['siteImage'], 'string', 'max' => 250],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'siteID' => 'Site ID',
            'siteName' => 'Site Name',
            'siteAddress' => 'Site Address',
            'siteLatitude' => 'Site Latitude',
            'siteLongitude' => 'Site Longitude',
            'siteImage' => 'Site Image',
            'fixedCharges' => 'Fixed Charges',
            'ebKWH' => 'Eb Kwh',
            'dgKwh' => 'Dg Kwh',
        ];
    }

    /**
     * {@inheritdoc}
     * @return SitesQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new SitesQuery(get_called_class());
    }
}
