<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Shifts;

/**
 * ShiftsSearch represents the model behind the search form of `app\models\Shifts`.
 */
class ShiftsSearch extends Shifts
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['shiftID', 'siteID', 'shiftStartHour', 'shiftStartMin', 'shiftEndHour', 'shiftEndMin'], 'integer'],
            [['shiftName'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Shifts::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'shiftID' => $this->shiftID,
            'siteID' => $this->siteID,
            'shiftStartHour' => $this->shiftStartHour,
            'shiftStartMin' => $this->shiftStartMin,
            'shiftEndHour' => $this->shiftEndHour,
            'shiftEndMin' => $this->shiftEndMin,
        ]);

        $query->andFilterWhere(['like', 'shiftName', $this->shiftName]);

        return $dataProvider;
    }
}
