<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\QtaConfig;

/**
 * QtaConfigSearch represents the model behind the search form of `app\models\QtaConfig`.
 */
class QtaConfigSearch extends QtaConfig
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'configID', 'slaveID', 'deviceMasterID', 'timeOut', 'delayQueryAfterResponse', 'addressMinusValue', 'ipIndex0', 'ipIndex1', 'ipIndex2', 'ipIndex3'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = QtaConfig::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'configID' => $this->configID,
            'slaveID' => $this->slaveID,
            'deviceMasterID' => $this->deviceMasterID,
            'timeOut' => $this->timeOut,
            'delayQueryAfterResponse' => $this->delayQueryAfterResponse,
            'addressMinusValue' => $this->addressMinusValue,
            'ipIndex0' => $this->ipIndex0,
            'ipIndex1' => $this->ipIndex1,
            'ipIndex2' => $this->ipIndex2,
            'ipIndex3' => $this->ipIndex3,
        ]);

        return $dataProvider;
    }
}
