<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Gateway;

/**
 * GatewaySearch represents the model behind the search form of `app\models\Gateway`.
 */
class GatewaySearch extends Gateway
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['gatewayID', 'siteID', 'gatewayTypeID', 'isLive', 'isDebug'], 'integer'],
            [['gatewaySerialNumber', 'gatewayName', 'gatewayMobileNumber', 'gatewayDataURL'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Gateway::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'gatewayID' => $this->gatewayID,
            'siteID' => $this->siteID,
            'gatewayTypeID' => $this->gatewayTypeID,
            'isLive' => $this->isLive,
            'isDebug' => $this->isDebug,
        ]);

        $query->andFilterWhere(['like', 'gatewaySerialNumber', $this->gatewaySerialNumber])
            ->andFilterWhere(['like', 'gatewayName', $this->gatewayName])
            ->andFilterWhere(['like', 'gatewayMobileNumber', $this->gatewayMobileNumber])
            ->andFilterWhere(['like', 'gatewayDataURL', $this->gatewayDataURL]);

        return $dataProvider;
    }
}
