<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "gateway".
 *
 * @property int $gatewayID
 * @property int|null $siteID
 * @property string|null $gatewaySerialNumber
 * @property string|null $gatewayName
 * @property int|null $gatewayTypeID
 * @property string|null $gatewayMobileNumber
 * @property string|null $gatewayDataURL
 * @property int|null $isLive
 * @property int|null $isDebug
 */
class Gateway extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'gateway';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['siteID', 'gatewayTypeID', 'isLive', 'isDebug'], 'integer'],
            [['gatewaySerialNumber'], 'string', 'max' => 50],
            [['gatewayName'], 'string', 'max' => 150],
            [['gatewayMobileNumber'], 'string', 'max' => 20],
            [['gatewayDataURL'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'gatewayID' => 'Gateway ID',
            'siteID' => 'Site ID',
            'gatewaySerialNumber' => 'Gateway Serial Number',
            'gatewayName' => 'Gateway Name',
            'gatewayTypeID' => 'Gateway Type ID',
            'gatewayMobileNumber' => 'Gateway Mobile Number',
            'gatewayDataURL' => 'Gateway Data Url',
            'isLive' => 'Is Live',
            'isDebug' => 'Is Debug',
        ];
    }
}
