<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "deviceMaster".
 *
 * @property int $deviceMasterID
 * @property string|null $deviceCompany
 * @property string|null $deviceModel
 * @property int|null $deviceTypeID
 * @property int|null $isAvailable
 */
class DeviceMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'deviceMaster';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['deviceMasterID', 'isAvailable'], 'integer'],
            [['deviceCompany', 'deviceModel'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'deviceMasterID' => 'Device Master ID',
            'deviceCompany' => 'Device Company',
            'deviceModel' => 'Device Model',
            'deviceTypeName' => 'Device Type Name',
            'isAvailable' => 'Is Available',
        ];
    }
}
