<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Config;

/**
 * ConfigSearch represents the model behind the search form of `app\models\Config`.
 */
class ConfigSearch extends Config
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['configID', 'comMethod', 'dataInterval', 'statusInterval', 'baudRate', 'numOfMeters', 'retryCount'], 'integer'],
            [['comURL', 'siteURL', 'boxID', 'userID', 'password', 'lineControl', 'deviceType'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Config::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'configID' => $this->configID,
            'comMethod' => $this->comMethod,
            'dataInterval' => $this->dataInterval,
            'statusInterval' => $this->statusInterval,
            'baudRate' => $this->baudRate,
            'numOfMeters' => $this->numOfMeters,
            'retryCount' => $this->retryCount,
        ]);

        $query->andFilterWhere(['like', 'comURL', $this->comURL])
            ->andFilterWhere(['like', 'siteURL', $this->siteURL])
            ->andFilterWhere(['like', 'boxID', $this->boxID])
            ->andFilterWhere(['like', 'userID', $this->userID])
            ->andFilterWhere(['like', 'password', $this->password])
            ->andFilterWhere(['like', 'lineControl', $this->lineControl])
            ->andFilterWhere(['like', 'deviceType', $this->deviceType]);

        return $dataProvider;
    }
}
