<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "config".
 *
 * @property int $configID
 * @property int $comMethod
 * @property string $comURL
 * @property string|null $siteURL
 * @property string|null $boxID
 * @property string $userID
 * @property string $password
 * @property int $dataInterval
 * @property int $statusInterval
 * @property int $baudRate
 * @property string $lineControl
 * @property int $numOfMeters
 * @property string $slaveID
 * @property int $retryCount
 * @property string $deviceType
 */
class Config extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'config';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['comMethod', 'comURL', 'userID', 'password', 'dataInterval', 'statusInterval', 'baudRate', 'lineControl', 'numOfMeters','slaveID', 'retryCount', 'deviceType'], 'required'],
            [['comMethod', 'dataInterval', 'statusInterval', 'baudRate', 'numOfMeters', 'retryCount','updateConfigure'], 'integer'],
            [['comURL','slaveID'], 'string', 'max' => 200],
            [['siteURL'], 'string', 'max' => 255],
            [['boxID', 'userID', 'password'], 'string', 'max' => 50],
            [['lineControl', 'deviceType'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'configID' => 'Config ID',
            'comMethod' => 'Com Method',
            'comURL' => 'Com Url',
            'siteURL' => 'Site Url',
            'boxID' => 'Box ID',
            'userID' => 'User ID',
            'password' => 'Password',
            'dataInterval' => 'Data Interval',
            'statusInterval' => 'Status Interval',
            'baudRate' => 'Baud Rate',
            'lineControl' => 'Line Control',
            'numOfMeters' => 'Num Of Meters',
            'slaveID'=>'slaveID',
            'retryCount' => 'Retry Count',
            'deviceType' => 'Device Type',
            'updateConfigure'=>'Update Configure'
        ];
    }
}
