<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\AutoReports;

/**
 * AutoReportsSearch represents the model behind the search form of `app\models\AutoReports`.
 */
class AutoReportsSearch extends AutoReports
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['autoReportID', 'autoReportType'], 'integer'],
            [['autoReportName', 'autoReportTime', 'autoReportEmails', 'autoReportSubject', 'autoReportMessage'], 'safe'],
            [['isLive'], 'boolean'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = AutoReports::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'autoReportID' => $this->autoReportID,
            'autoReportType' => $this->autoReportType,
            'autoReportTime' => $this->autoReportTime,
            'isLive' => $this->isLive,
        ]);

        $query->andFilterWhere(['like', 'autoReportName', $this->autoReportName])
            ->andFilterWhere(['like', 'autoReportEmails', $this->autoReportEmails])
            ->andFilterWhere(['like', 'autoReportSubject', $this->autoReportSubject])
            ->andFilterWhere(['like', 'autoReportMessage', $this->autoReportMessage]);

        return $dataProvider;
    }
}
