<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Alert;

/**
 * AlertSearch represents the model behind the search form of `app\models\Alert`.
 */
class AlertSearch extends Alert
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['AlertID', 'AlertTypeID', 'AlertStatusTypeID', 'UserID', 'AlertFkID'], 'integer'],
            [['AlertDateTime', 'AlertMessage', 'AlertMessageTech', 'LastUpdateDateTime'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Alert::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'AlertID' => $this->AlertID,
            'AlertTypeID' => $this->AlertTypeID,
            'AlertStatusTypeID' => $this->AlertStatusTypeID,
            'AlertDateTime' => $this->AlertDateTime,
            'UserID' => $this->UserID,
            'LastUpdateDateTime' => $this->LastUpdateDateTime,
            'AlertFkID' => $this->AlertFkID,
        ]);

        $query->andFilterWhere(['like', 'AlertMessage', $this->AlertMessage])
            ->andFilterWhere(['like', 'AlertMessageTech', $this->AlertMessageTech]);

        return $dataProvider;
    }
}
