<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Admin;

/**
 * AdminSearch represents the model behind the search form of `app\models\Admin`.
 */
class AdminSearch extends Admin
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['AdminID', 'AdminType'], 'integer'],
            [['AdminName', 'AdminEmail', 'AdminPassword'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Admin::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'AdminID' => $this->AdminID,
            'AdminType' => $this->AdminType,
        ]);

        $query->andFilterWhere(['like', 'AdminName', $this->AdminName])
            ->andFilterWhere(['like', 'AdminEmail', $this->AdminEmail])
            ->andFilterWhere(['like', 'AdminPassword', $this->AdminPassword]);

        return $dataProvider;
    }
}
