<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "Admin".
 *
 * @property int $AdminID
 * @property string|null $AdminName
 * @property string|null $AdminEmail
 * @property string|null $AdminPassword
 * @property int|null $AdminType
 */
class Admin extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'Admin';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['AdminName','AdminEmail', 'AdminPassword'], 'required'],
            [['AdminType'], 'integer'],
            [['AdminName', 'AdminEmail'], 'string', 'max' => 250],
            [['AdminPassword'], 'string', 'max' => 20],
            ['AdminPassword', 'validatePassword'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'AdminID' => 'Admin ID',
            'AdminName' => 'Admin Name',
            'AdminEmail' => 'Admin Email',
            'AdminPassword' => 'Admin Password',
            'AdminType' => 'Admin Type',
        ];
    }

    /**
     * {@inheritdoc}
     * @return AdminQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AdminQuery(get_called_class());
    }

    public function validatePassword($AdminPassword)
    {
        
        return $this->AdminPassword === sha1($AdminPassword);
    }

}
