<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\SignupForm;
use app\models\ContactForm;
use app\models\DeviceMasterData;
use yii\filters\auth\QueryParamAuth;

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }

    /**
     * Displays homepage.
     *
     * @return string
     */
    public function actionIndex()
    {


        $qparam= Yii::$app->request->queryParams;
        $connection = Yii::$app->getDb();     
        $deviceID=0;
        $gatewayID=0;
              $modBusID=0;
              $siteID=1;
           if(Yii::$app->request->post()){
            $postdata=Yii::$app->request->post();
            $deviceID=$postdata['deviceID'];
           $mapMasterID=$postdata['mapMasterID'];
           $daterange=$postdata['daterange'];
            $daterange = explode('-', $daterange);
             $from=$daterange[0];
             $patern = array("/", ":", " ");
            $from1 = str_replace($patern, "", $from);            
            $to=$daterange[1];
            $to1 = str_replace($patern, "", $to);
           //die();
           }
           //$Now = new DateTime('now', new DateTimeZone('Asia/Calcutta'));
           ///////////////////////// pic chart data calculation
           //$todaydate = $Now->format('Ymd');  
               // $monthfirstdate=$Now->format('Ym').'01'; 
           date_default_timezone_set("Asia/Calcutta");    
           $todaydate= date('Ymd');      
           $monthdate= date('Ym');
           $monthfirstdate= date('Ym').'01';
           

        $querypicharttoday= "SELECT max(dd.data) as maxdata,max(dd.data) - min(dd.data)  as data,dd.deviceID,dd.gatewayID,dd.timeStamp,dd.mapMasterID,d.deviceName ,g.gatewayName FROM deviceDataDaily dd join device d join gateway g on dd.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.gatewayID=g.gatewayID where d.isLive=1 and dd.mapMasterID in(6,308)  and dd.timeStamp like '$todaydate%' group by dd.deviceID,dd.gatewayID";
        //die();
        
        $command = $connection->createCommand($querypicharttoday);  
        $pichartdatatoday = $command->queryAll(); 

        $querypichartmonth= "SELECT max(dd.data) - min(dd.data) as data,dd.deviceID,dd.gatewayID,dd.timeStamp,dd.mapMasterID,d.deviceName ,g.gatewayName FROM deviceData dd join device d join gateway g on d.deviceID=dd.dID and d.gatewayID=g.gatewayID where d.isLive=1 and dd.mapMasterID in(6,308) and dd.timeStamp like '$monthdate%' group by dd.deviceID,dd.gatewayID";
        
       //die();
        $command = $connection->createCommand($querypichartmonth);  
        $pichartdatamonth = $command->queryAll(); 

        /*$querypichartfd= "SELECT max(dd.data) as data,dd.deviceID,dd.gatewayID,dd.timeStamp,dd.mapMasterID,d.deviceName ,g.gatewayName FROM deviceData dd join device d join gateway g on dd.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.gatewayID=g.gatewayID where d.isLive=1 and  dd.mapMasterID=6 and dd.timeStamp like '$monthfirstdate%' group by dd.deviceID,dd.gatewayID";
        
       //die();
        $command = $connection->createCommand($querypichartfd);  
        $pichartdatafd = $command->queryAll(); */
        //print_r($pichartdatafd);
        //die(count($pichartdatafd));
        //echo'<pre>';
        //print_r($pichartdatatoday);
        //die('hhhh');
        if(isset($_REQUEST['siteID'])){
            $siteID=$_REQUEST['siteID'];
        }

        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,d.deviceMasterID,g.gatewayName FROM device d join gateway g join deviceDataDaily dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and g.siteID=$siteID";
        
        $command = $connection->createCommand($querydevice);  
        $devicedata = $command->queryAll(); 
        
        if(count($devicedata) >0){            
            $deviceID=$devicedata[0]['deviceID'];
              $gatewayID=$devicedata[0]['gatewayID'];
              $modBusID=$devicedata[0]['modBusID'];
            }

            if(isset($qparam['deviceID'])){
                //$deviceID=$qparam['deviceID'];
                $res=explode("_",$qparam['deviceID']);
                if(count($res)>0){
              $deviceID=$res[0];
              $gatewayID=$res[1];
              $modBusID=$res[0];
                }
               }

        $resultarr=array();
        $sliderkwhdata=array("todayKWH"=>0,"thisMonthKWH"=>0,"totalKWH"=>0);
        for($c=0; $c<count($pichartdatatoday); $c++){
            $datat= $pichartdatatoday[$c]['data'];
            $dName= $pichartdatatoday[$c]['deviceName'];
            $gName= $pichartdatatoday[$c]['gatewayName'];
            /*if(count($pichartdatafd)==count($pichartdatatoday))
            $datafd= $pichartdatafd[$c]['data'];
            else
            $datafd=0;
            $finaldata=$datat;*/
            if($pichartdatatoday[$c]['deviceID']==$modBusID && $pichartdatatoday[$c]['gatewayID']==$gatewayID){
                $sliderkwhdata=array("todayKWH"=>$datat,"thisMonthKWH"=>$pichartdatamonth[$c]['data'],"totalKWH"=>$pichartdatatoday[$c]['maxdata']);
            }
            $resultarr[$c]['deviceData']=$dName.'('.$gName.')'.'@'.$datat;
        }

        ///////////////////////////////////////////////////////
        //print_r($sliderkwhdata);
        //die();
        

        $querydevicename= "SELECT deviceName,sanctionedLoadKW FROM device where isLive=1 and deviceID=$deviceID and gatewayID=$gatewayID";
        
        $command = $connection->createCommand($querydevicename);  
        $devicename = $command->queryAll();  

        if(count($devicename) >0){
        $dname=$devicename[0]['deviceName'];
        $sanctionedLoadKW=$devicename[0]['sanctionedLoadKW'];
        }else{
        $dname='';
        $sanctionedLoadKW=0;
        }

        $querynonworkingdevice= "SELECT d.deviceID,d.deviceName,d.modBusID,d.gatewayID,d.isLive,d.lastCommunication FROM device d join gateway  g where d.gatewayID=g.gatewayID and  d.isLive=0";        
        $command = $connection->createCommand($querynonworkingdevice); 
        $nonWorkingDeviceData = $command->queryAll();        
        

         if($deviceID > 0)  {
            $queryworkingdevicedata= "SELECT d.modBusID as deviceID,d.gatewayID,d.deviceName,g.gatewayName FROM device d join gateway g on d.gatewayID=g.gatewayID where d.isLive=1 group by d.deviceID";

        
        $command = $connection->createCommand($queryworkingdevicedata); 
        $dataProvider = $command->queryAll();  
        }else{
           $dataProvider=[];
        }

        
    
                //$todayTime = $Now->format('Ymd');  
                //$thismonthTime=$Now->format('Ym'); 
        
                    $todayTime = date("Ymd");
                    $thismonthTime=date("Ym");        

                    //$querysliderdatatoday= "SELECT  mapMasterID,max(data) as data,timeStamp FROM deviceData where mapMasterID in (6,7,305) and deviceID=$modBusID and gatewayID=$gatewayID and timeStamp like '$todayTime%' group by mapMasterID order by mapMasterID asc"; 
                    $querysliderdatatoday= "select max(data) as maxdata,max(data) - min(data) as data from deviceDataDaily where deviceID=$modBusID and gatewayID=$gatewayID and  mapMasterID in (7,309) and timeStamp like '$todayTime%'"; 
                    $command = $connection->createCommand($querysliderdatatoday); 
                    $sliderDataToday = $command->queryAll();
                    
                    /*$querysliderdatatoday1= "select max(data) as maxdata,max(data) - min(data) as data from deviceDataDaily where deviceID=$modBusID and gatewayID=$gatewayID and  mapMasterID in (41,305)  and timeStamp like '$todayTime%'"; 
                    $command = $connection->createCommand($querysliderdatatoday1); 
                    $sliderDataToday1 = $command->queryAll();*/

                    $querysliderdatatoday2= "select max(data) as maxdata,max(data) - min(data) as data from deviceDataDaily where deviceID=$modBusID and gatewayID=$gatewayID and  mapMasterID=310 and timeStamp like '$todayTime%'"; 
                    $command = $connection->createCommand($querysliderdatatoday2); 
                    $sliderDataToday2 = $command->queryAll();

                    $querysliderdatatoday3= "select max(data) as maxdata,max(data) - min(data) as data from deviceDataDaily where deviceID=$modBusID and gatewayID=$gatewayID and  mapMasterID=4  and timeStamp like '$todayTime%'"; 
                    $command = $connection->createCommand($querysliderdatatoday3); 
                    $sliderDataToday3 = $command->queryAll();        

                    
                    $querysliderdatamonth= "select max(data) as maxdata,max(data) - min(data) as data from deviceData where deviceID=$modBusID and gatewayID=$gatewayID and  mapMasterID in (7,309) and timeStamp like '$thismonthTime%'";   
                    $command = $connection->createCommand($querysliderdatamonth); 
                    $sliderDataMonth = $command->queryAll(); 

                    /*$querysliderdatamonth1= "select max(data) as maxdata,max(data) - min(data) as data from deviceData where deviceID=$modBusID and gatewayID=$gatewayID and  mapMasterID in (41,305) and timeStamp like '$thismonthTime%'";   
                    $command = $connection->createCommand($querysliderdatamonth1); 
                    $sliderDataMonth1 = $command->queryAll(); */
                    

                    $querysliderdatamonth3= "select max(data) as maxdata,max(data) - min(data) as data from deviceData where deviceID=$modBusID and gatewayID=$gatewayID and mapMasterID=4 and timeStamp like '$thismonthTime%'";   
                    $command = $connection->createCommand($querysliderdatamonth3); 
                    $sliderDataMonth3 = $command->queryAll(); 
                
     //die();
        return $this->render('index', [
            'nonWorkingDeviceData' => $nonWorkingDeviceData,
           'dataProvider' => $dataProvider,
            'devicedata' => $devicedata,
            'devicename'=>$dname,
            'sliderDataToday'=>$sliderDataToday,
            'sliderDataMonth'=>$sliderDataMonth,
            //'sliderDataToday1'=>$sliderDataToday1,
            //'sliderDataMonth1'=>$sliderDataMonth1,
            'sliderDataToday2'=>$sliderDataToday2,
            //'sliderDataMonth2'=>$sliderDataMonth2,
            'sliderDataToday3'=>$sliderDataToday3,
            'sliderDataMonth3'=>$sliderDataMonth3,
            'pichartdata'=>$resultarr,
            'pichartdatatoday'=>$pichartdatatoday,
            'pichartdatamonth'=>$pichartdatamonth,
            'sliderkwhdata'=>$sliderkwhdata,
            'sanctionedLoadKW'=>$sanctionedLoadKW
        ]);        
    }

    /**
     * Login action.
     *
     * @return Response|string
     */
    public function actionLogin()
    {
                if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new LoginForm();
        
        if ($model->load(Yii::$app->request->post()) && $model->login(false)) {
            return $this->goBack();
        }
        //die(Yii::$app->user->returnUrl);

        //if ($model->load($this->request->post()) && $model->login(true)) {
            //return $this->redirect(['index.php?r=site/index']);
        //}
        $session = Yii::$app->session;
        Yii::$app->session->set('Username','admin');
        $model->password = '';
        //$model->username = '';
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    public function actionSignup()
    {
        $model = new SignupForm();
        //print_r($this->request->post());
        //die();
        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->signupUser()) {
                return $this->redirect(['site/login?status=success']);
            }
        }else{

        return $this->render('signup', [
            'model' => $model,
        ]);
    }
    }

   

    /**
     * Logout action.
     *
     * @return Response
     */
    public function actionLogout()
    {
        $model = new LoginForm();
        Yii::$app->user->logout();
        $model->username = '';
        $model->password = '';
        $session = Yii::$app->session;
        //Yii::$app->session->unset('Username','');
        $session->close();
        return $this->redirect(['site/login']);
        /* return $this->render('login', [
            'model' => $model,
        ]); */
    }

    /**
     * Displays contact page.
     *
     * @return Response|string
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');

            return $this->refresh();
        }
        return $this->render('contact', [
            'model' => $model,
        ]);
    }

    /**
     * Displays about page.
     *
     * @return string
     */
    public function actionAbout()
    {
        return $this->render('about');
       /* $model = new DeviceMasterData();
        $dataProvider= new ActiveDataProvider([
            'allModels' => DeviceMasterData::getDeviceMasterData(),
            'pagination' => false,
        ]);
        return $this->render('about', [
            'dataProvider'=>$dataProvider]);
         */

    /* $modeluser = new DeviceMasterData();
        $data = DeviceMasterData::find()->all();
        return $this->render('about', [
            'data' => $data,
        ]);
        */
    }
}
