<?php

namespace app\controllers;
use Yii;
use app\models\SingleData;
use app\models\SingleDataSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\filters\auth\QueryParamAuth;
use kartik\mpdf\Pdf;

/**
 * MapMasterController implements the CRUD actions for MapMaster model.
 */
class SingleDataController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all MapMaster models.
     *
     * @return string
     */

    public function actionIndex()
    {
        
        $qparam= Yii::$app->request->queryParams;
        $mapMasterID =0;
        $deviceID =0;
        $deviceName='';
        $gatewayID=0;
        
        date_default_timezone_set("Asia/Calcutta");  
   
           if(Yii::$app->request->post()){
            $postdata=Yii::$app->request->post();
            $deviceID=$postdata['deviceID'];
            $mapMasterID=$postdata['mapMasterID'];
            $daterange1=$postdata['daterange'];
            $daterange = explode('-', $daterange1);
            $from=$daterange[0];
            $patern = array("/", ":", " ");
            $from1 = str_replace($patern, "", $from);            
            $to=$daterange[1];
            $to1 = str_replace($patern, "", $to);
            
            //$table='deviceData';
           }else{
            //$table='deviceDataDaily';
            $time = time();
            $mapMasterID=4;
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('0 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'005900';
            
            //die();
           }
           if(isset($_REQUEST['date'])){
            $daterange = explode('-', $_REQUEST['date']);
            $from1=$daterange[0];
            $to1=$daterange[1];
           }
           
           $currentdata = date("YmdHis");
           $backdate= date('Ymd', strtotime('-24 hours', strtotime($currentdata))).'000000';
           if($from1 >= $backdate){
               $table='deviceDataDaily';
           }else{
            $table='deviceData';
           }

   if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;

        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM device d join gateway g join $table dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID  and g.siteID=$siteID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querydevice);  
        $devicedata = $command->queryAll(); 
    //print_r($devicedata);
    //die();
        if(isset($qparam['deviceID'])){
            $res=explode("_",$qparam['deviceID']);
            $deviceID=$res[0];
            $gatewayID=$res[1];
           }else if (count($devicedata) >0){
            $deviceID=$devicedata[0]['modBusID'];
            $gatewayID=$devicedata[0]['gatewayID'];
            $mapMasterID=4;
           }
        
           if(Yii::$app->request->post()){
            $postdata=Yii::$app->request->post();            
            $mapMasterID=$postdata['mapMasterID'];
            $res=explode("_",$postdata['deviceID']);
            $deviceID=$res[0];
            $gatewayID=$res[1];
           }


           if(isset($qparam['date'])){            
            $mapMasterID=$qparam['mapMasterID'];
            $res=explode("_",$qparam['deviceID']);
            $deviceID=$res[0];
            $gatewayID=$res[1];

            $date = $qparam['date'];
            $daterange = explode('-', $date);
            $from1=$daterange[0];                      
            $to1=$daterange[1];           
           }else if(isset($qparam['olddata']) && $qparam['olddata1'] ==''){
            $res=explode("_",$qparam['olddata']);            
            $gatewayID=$res[0];
            $deviceID=$res[1];
            $mapMasterID=$res[2];
            $daterange=$res[3];
            $daterange = explode('-', $daterange);
            $from1=$daterange[0];                      
            $to1=$daterange[1];
        }else if(isset($qparam['olddata']) && isset($qparam['olddata1']) && $qparam['olddata1'] !=''){            
            $res=explode("_",$qparam['olddata1']);  
            //print_r($res[1]);
            //die();          
            $gatewayID=$res[0];
            $deviceID=$res[1];
            $mapMasterID=$res[2];
            $daterange=$res[3];
            $daterange = explode('-', $daterange);
            $from1=$daterange[0];                      
            $to1=$daterange[1];
           }
           //echo'from1='.$from1;  
           //echo'<BR>';                  
          //echo'to1='. $to1;

           $hourdiff = round((strtotime($to1) - strtotime($from1))/3600, 0);   
              
          // echo'<BR>';  
           $daysdiff = round(((strtotime($to1) - strtotime($from1))/3600)/24, 0);
  
            if($hourdiff < 24 || $hourdiff == 1){
               //echo'if';
               //if(isset($_REQUEST['date']))
            $from2= date('YmdHis', strtotime('0 hours', strtotime($from1)));
            //else
            //$from2= date('YmdHis', strtotime('-1 hours', strtotime($from1)));
            $to2= $to1;
            } else if($hourdiff < 1){
              //echo'else if';
             $from2= date('YmdHis', strtotime('0 hours', strtotime($from1)));
             $to2= $to1;
             }          
            else if($daysdiff >= 1 && $to1 < $currentdata){
             // echo'elseif';
            $to2= $to1;
            $from2= date('YmdHis', strtotime('-24 hours', strtotime($from1)));
            
            //if($to1 < $currentdata)
            $daysdiff=$daysdiff+1;
            }else{
              //echo'else';
                $from2= $from1;
                $to2= $to1; 
            }

            
   if($from1 >= $backdate){
       $table='deviceDataDaily';
   }else{
    $table='deviceData';
   }


        $querymm= "SELECT mapMasterName FROM mapMaster where mapMasterID=$mapMasterID order by mapMasterID asc";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymm);  
        $mapmaster = $command->queryAll(); 
        //print_r($mapmaster);
        //die();
        

        //$querymapmaster= "SELECT distinct(mm.mapMasterID),mm.mapMasterCode,mm.mapMasterName FROM `mapMaster` mm join $table dd join device d on dd.mapMasterID=mm.mapMasterID and d.modBusID=dd.deviceID where dd.deviceID=$deviceID and dd.gatewayID=$gatewayID";
        $querymapmaster= "SELECT DISTINCT(mm.mapMasterID),mm.mapMasterName from mapMaster mm join deviceMapMasterAdmin dmma join device d on mm.mapMasterID=dmma.mapMasterID where dmma.deviceMapMasterPullData=1 and dmma.deviceMasterID=(select deviceMasterID from device where modBusID=$deviceID and gateWayID=$gatewayID)";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymapmaster); 
        $mapmasterData = $command->queryAll(); 
        
        if(Yii::$app->request->post()){                        
            $mapMasterID=$postdata['mapMasterID'];  
            $mapMasterName=$mapmaster[0]['mapMasterName'];
        }else{
            if(count($mapmasterData)>0 && !isset($_REQUEST['mapMasterID'])){
            $mapMasterID=$mapmasterData[0]['mapMasterID']; 
            $mapMasterName=$mapmasterData[0]['mapMasterName']; 
            }else{
                if(isset($_REQUEST['mapMasterID']))
                $mapMasterID= $_REQUEST['mapMasterID'];
                $mapMasterName=$mapmaster[0]['mapMasterName'];
            } 
        }

         if($mapMasterID > 0 && $deviceID > 0)  {

            $querydevice="select deviceName from device where modBusID=$deviceID and gatewayID=$gatewayID";
            //die();
            $command = $connection->createCommand($querydevice);
            $deviceres = $command->queryAll(); 
             $deviceName=$deviceres[0]['deviceName'];

             
            $querydevicedata= "select * from $table where timeStamp between '".$from2."' and '".$to2."' and deviceID=$deviceID and mapMasterID=$mapMasterID and gatewayID=$gatewayID order by timeStamp asc";
        //die();
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querydevicedata); 
        $dataProvider = $command->queryAll();  
        }else{
           $dataProvider=[];
         }

    
     $fromdate = date('d M h:i A', strtotime($from1));
      $todate = date('d M h:i A', strtotime($to1));

      //$hourdiff = round((strtotime($to1) - strtotime($from1))/3600, 1);
      //$daysdiff = round((strtotime($to1) - strtotime($from1)), 1);
      //echo$mapmaster[0]['mapMasterName'];
          // die();

        return $this->render('index', [
            'mapmasterData' => $mapmasterData,
            'dataProvider' => $dataProvider,
            'devicedata' => $devicedata,
            'mapMasterName'=>$mapMasterName,
            'dataFrom'=> $fromdate.' to '.$todate,
            'deviceName'=>$deviceName,
            'mapMasterID'=>$mapMasterID,
            'deviceID'=>$deviceID,
            'gatewayID'=>$gatewayID,
            'daterange'=>$from1.'-'.$to1,
            'hourdiff'=>$hourdiff,
            'start_date'=>$from1,
            'end_date'=>$to1,
            'daysdiff'=>$daysdiff,
            'table'=>$table
        ]);
    }  



    public function actionView()
    {
        
        $qparam= Yii::$app->request->queryParams;
        $mapMasterID =0;
        $deviceID =0;
        $gatewayID=0;
        //$POST_VARIABLE=Yii::$app->request->post();
        $from1='';
        $to1='';
        $mmid='';       
        $mapMasterID=array();
        //$mmid='';
        if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;

        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and g.siteID=$siteID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querydevice);  
        $devicedata = $command->queryAll();  
        
        if(isset($_REQUEST['deviceID'])){
            $mapMasterID=4;
            $deviceID=$_REQUEST['deviceID'];
            $res=explode("_",$deviceID);
            $deviceID=$res[1];
            $gatewayID=$res[0];
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('+330 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'000000';
            //$mmid=implode(",",$mapMasterID);
            $table='deviceDataDaily';
        
    }else if(isset($_REQUEST['olddata']) && isset($_REQUEST['olddata1']) && $_REQUEST['olddata1'] !=''){            
        $res=explode("_",$_REQUEST['olddata1']);  
        //print_r($res[1]);
        //die();          
        $deviceID=$_REQUEST['deviceID'];
            $res1=explode("_",$deviceID);
            $deviceID=$res1[1];
            $gatewayID=$res1[0];
        $daterange=$res[2];
        $daterange = explode('-', $daterange);
        $from1=$daterange[0];                      
        $to1=$daterange[1];
       }else{
            $time = time();
            $mapMasterID=4;
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('+330 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'000000';
            if(count($devicedata)>0){
            $deviceID=$devicedata[0]['modBusID'];
            $gatewayID=$devicedata[0]['gatewayID'];
        }
            //$mmid=implode(",",$mapMasterID);
            $table='deviceDataDaily';
        }

        $currentdata = date("YmdHis");
   
        
            $backdate= date('Ymd', strtotime('-24 hours', strtotime($currentdata))).'000000';
            if($from1 <= $backdate){
                $table='deviceDataDaily';
            }else{
             $table='deviceData';
            }

        if(Yii::$app->request->post()){
            $table='deviceData';
            $postdata=Yii::$app->request->post();
           $mapMasterID=$postdata['mapMaster'];
           $deviceID=$postdata['deviceID'];
           $res=explode("_",$deviceID);
            $deviceID=$res[1];
            $gatewayID=$res[0];
//print_r($mapMasterID);
           $daterange=$_REQUEST['datetimes'];
            $daterange = explode('-', $daterange);
             $from=$daterange[0];
             $patern = array("/", ":", " ");
            $from1 = str_replace($patern, "", $from);            
            $to=$daterange[1];
            $to1 = str_replace($patern, "", $to);
           //die();
           $mmid=implode(",",$mapMasterID);
//die();
           }

           $currentdata = date("YmdHis");
            $backdate= date('Ymd', strtotime('-24 hours', strtotime($currentdata))).'000000';
            if($from1 >= $backdate){
                $table='deviceDataDaily';
            }else{
             $table='deviceData';
            }
            
            if(isset($_REQUEST['date'])){
                $daterange = explode('-', $_REQUEST['date']);
                $from1=$daterange[0];
                $to1=$daterange[1];
               }


           $hourdiff = round((strtotime($to1) - strtotime($from1))/3600, 0);   
              
           // echo'<BR>';  
            $daysdiff = round(((strtotime($to1) - strtotime($from1))/3600)/24, 0);
              
            if($daysdiff ==0 && $hourdiff == 1){
               // echo'if';
             $from2= $from1;
             $to2= $to1;
             }else if($hourdiff < 24 || $hourdiff == 1){
               // echo'else if1';
             $from2= date('YmdHis', strtotime('0 hours', strtotime($from1)));
             //echo'<BR>';
             $to2= $to1;
             } else if($hourdiff < 1){
               //echo'else if2';
              $from2= date('YmdHis', strtotime('0 hours', strtotime($from1)));
              $to2= $to1;
              }          
             else if($daysdiff >= 1 && $to1 < $currentdata){
              // echo'elseif3';
             $to2= $to1;
             $from2= date('YmdHis', strtotime('-24 hours', strtotime($from1)));
             
             //if($to1 < $currentdata)
             $daysdiff=$daysdiff+1;
             }else{
               //echo'else';
                 $from2= $from1;
                 $to2= $to1; 
             }
 
 

        //echo'mmid='.$mmid;
        //die();
        
        //echo$querymapmaster= "SELECT distinct(mm.mapMasterID),mm.mapMasterName FROM `mapMaster` mm join $table dd on dd.mapMasterID=mm.mapMasterID where dd.deviceID=$deviceID and dd.gatewayID=$gatewayID";
        //die();
        $querymapmaster= "SELECT DISTINCT(mm.mapMasterID),mm.mapMasterName from mapMaster mm join deviceMapMasterAdmin dmma join device d on mm.mapMasterID=dmma.mapMasterID where dmma.deviceMapMasterPullData=1 and d.isLive=1 and dmma.deviceMasterID=(select deviceMasterID from device where modBusID=$deviceID and gateWayID=$gatewayID)";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymapmaster); 
        $mapmasterData = $command->queryAll(); 
        if(count($mapmasterData) >3 && $mmid==''){   
        $mapMasterID=array($mapmasterData[0]['mapMasterID'],$mapmasterData[1]['mapMasterID'],$mapmasterData[2]['mapMasterID'],$mapmasterData[3]['mapMasterID']);  
        $mmid=implode(",",$mapMasterID);    
    } 
        //print_r($mmid);
        //die();
        $fromdate = date('d M h:i A', strtotime($from1));
        $todate = date('d M h:i A', strtotime($to1));
        
        
        if($mmid !=''){
            $queryheader= "select mm.mapMasterID,mm.mapMasterName 
            from mapMaster mm join deviceMapMasterAdmin dmma where dmma.mapMasterID=mm.mapMasterID and mm.mapMasterID in ($mmid) group by mapMasterID";
            $connection = Yii::$app->getDb();
            $command = $connection->createCommand($queryheader); 
            $headerDataProvider = $command->queryAll(); 

                 $query="";
                 $query= "select max(dd.dataID),dd.deviceID,dd.gatewayID ,mm.mapMasterID, ";
                 foreach($headerDataProvider as $hdata){
                     $mapmname=$hdata['mapMasterName'];
                     //$deviceID=$hdata['deviceID'];
                     $query.="coalesce(sum(case when mm.mapMasterName = '$mapmname' then dd.data end), 0) as '$mapmname',";
                 }
                 $query.="dd.timeStamp
                 from $table dd join mapMaster mm where dd.mapMasterID=mm.mapMasterID and dd.timeStamp between '".$from2."' and '".$to2."' and dd.deviceID=$deviceID and dd.gatewayID= $gatewayID group by dd.timeStamp,dd.deviceID order by dd.timeStamp desc";
                 //echo $query;
                 //die();
                 $connection = Yii::$app->getDb();
                 $command = $connection->createCommand($query);        
                
                 $dataProvider = $command->queryAll(); 
                }else{
                    $dataProvider=[]; 
                    $headerDataProvider=[];
                }
                 $querydevice="select deviceName from device where modBusID=$deviceID and gatewayID=$gatewayID";
                 //die();
                 $command = $connection->createCommand($querydevice);
                 $deviceres = $command->queryAll(); 
                 if(count($deviceres)>0)
                  $deviceName=$deviceres[0]['deviceName'];
                  else
                  $deviceName='';

                 return $this->render('view', [
                   'mapmasterData' => $mapmasterData,            
                    'devicedata' => $devicedata,
                    'headerDataProvider' => $headerDataProvider,
                    'dataProvider' => $dataProvider,
                    'mmid'=>$mapMasterID,
                    'mapMasterIDs'=>$mmid,
                    'mapMasterName'=>'',
                    'dataFrom'=> $fromdate.' to '.$todate,
                    'deviceName'=>$deviceName,            
                    'deviceID'=>$deviceID,
                    'gatewayID'=>$gatewayID,
                    'daterange'=>$from1.'-'.$to1,
                    'hourdiff'=>$hourdiff,
                    'daysdiff'=>$daysdiff,
                    'start_date'=>$from1,
                    'end_date'=>$to1,
                    'table'=>$table
                ]);
            
    }

    /**
     * Creates a new MapMaster model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
       
        $qparam= Yii::$app->request->queryParams;
        $mapMasterID =0;
        $deviceID =0;
        $gatewayID=0;
        //$POST_VARIABLE=Yii::$app->request->post();
        $from1='';
        $to1='';
        $mmid='';       
        $ddg=array();

        if(isset($_REQUEST['siteID']))
        $siteID=$_REQUEST['siteID'];
    else
    $siteID=1;

        $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('+330 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'000000';

        if ($this->request->isPost) {
            $table='deviceData';
            $mapMasterID= $_REQUEST['mapMasterID'];
            $daterange=$_REQUEST['datetimes'];
            $daterange = explode('-', $daterange);
             $from=$daterange[0];
             $patern = array("/", ":", " ");
            $from1 = str_replace($patern, "", $from);            
            $to=$daterange[1];
            $to1 = str_replace($patern, "", $to);
        }else{
            $table='deviceData';
            $mapMasterID=5;
        }


        if(isset($qparam['date'])){            
            $mapMasterID=$qparam['mapMasterID'];
            $res=explode("_",$qparam['deviceid']);
            $deviceID=$res[0];
            $gatewayID=$res[1];

            $date = $qparam['date'];
            $daterange = explode('-', $date);
            $from1=$daterange[0];                      
            $to1=$daterange[1];           
           }else if(isset($qparam['olddata']) && $qparam['olddata1'] ==''){
            $res=explode("_",$qparam['olddata']);            
            $gatewayID=$res[0];
            $deviceID=$res[1];
            $mapMasterID=$res[2];
            $daterange=$res[3];
            $daterange = explode('-', $daterange);
            $from1=$daterange[0];                      
            $to1=$daterange[1];
        }else if(isset($qparam['olddata']) && isset($qparam['olddata1']) && $qparam['olddata1'] !=''){            
            $res=explode("_",$qparam['olddata1']);  
            //print_r($res[1]);
            //die();          
            $gatewayID=$res[0];
            $deviceID=$res[1];
            $mapMasterID=$res[2];
            $daterange=$res[3];
            $daterange = explode('-', $daterange);
            $from1=$daterange[0];                      
            $to1=$daterange[1];
           }
        
        $connection = Yii::$app->getDb();

        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and g.siteID=$siteID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querydevice);  
        $devicedata = $command->queryAll();  

        $command = $connection->createCommand("SELECT mapMasterName from mapMaster where mapMasterID=$mapMasterID");
        $datamapmaster = $command->queryAll();

        $command = $connection->createCommand("SELECT * from groups");
        $datagroup = $command->queryAll();

        if(count($datagroup)>0){
            $groupID=$datagroup[0]['groupID'];
            $groupName=$datagroup[0]['groupName'];
        }
        
        if(isset($_REQUEST['groupID'])){            
            $groupID=$_REQUEST['groupID'];
        }
        //echo"SELECT deviceID from deviceGroup where groupID=$groupID";
            $command = $connection->createCommand("SELECT deviceID from deviceGroup where groupID=$groupID");
           $datadevicegroupid = $command->queryAll();
           foreach($datadevicegroupid as $dgdata){
            $ddg[]=$dgdata['deviceID'];
            }
            $devid=implode(",",$ddg);
           //print_r($datamapmaster[0]['mapMasterName']);
           //die();
            //$res=explode("_",$deviceID);
            //$deviceID=$res[1];
            //$gatewayID=$res[0];
            $from11=$from1;
            $currentdata=date('Ymd');
            $startdt=substr($from11, 0, -6);
            if($startdt==$currentdata)
$table='deviceDataDaily';
else
$table='deviceData';
            
            $modBusIDarr=array();
            $modBusIDs='';
            $fromdate = date('d M h:i A', strtotime($from1));
            $todate = date('d M h:i A', strtotime($to1));

            $queryheader= "select deviceID,deviceName,modBusID,gatewayID,deviceMasterID from device where deviceID in ($devid) and isLive=1";
            $connection = Yii::$app->getDb();
            $command = $connection->createCommand($queryheader); 
            $headerDataProvider = $command->queryAll(); 
//echo'<BR>';
            foreach($headerDataProvider as $dgdata1){
                $modBusIDarr[]=$dgdata1['deviceMasterID'];
                }
                $modBusIDs=implode(",",$modBusIDarr);
if($modBusIDs !=''){
                 $query="";
                 $query= "select max(dd.dataID),dd.deviceID,dd.gatewayID,dd.dID,dd.mapMasterID,d.deviceName, ";
                 foreach($headerDataProvider as $hdata){
                     $deviceName=$hdata['deviceName'];
                     $gatewayID=$hdata['gatewayID'];
                     //$query.="coalesce(sum(case when d.deviceName = '$deviceName' then dd.data end), 0) as '$deviceName',";
                 }
                 $query.="dd.timeStamp
                 from $table dd join device d where dd.deviceID=d.modBusID and dd.timeStamp between '".$from1."' and '".$to1."' and dd.dID in($devid) and dd.mapMasterID=$mapMasterID group by dd.timeStamp,dd.dID order by dd.timeStamp desc";
                 //echo $query;
                 //die();
                 $connection = Yii::$app->getDb();
                 $command = $connection->createCommand($query);        
                
                 $dataProvider = $command->queryAll(); 
                }else{
                    $dataProvider=[];  
                    $headerDataProvider=[];
                }
                //$querymapmaster= "SELECT distinct(mm.mapMasterID),mm.mapMasterName FROM `mapMaster` mm join $table dd on dd.mapMasterID=mm.mapMasterID where dd.dID in($devid)";  
                $querymapmaster= "SELECT DISTINCT(mm.mapMasterID),mm.mapMasterName from mapMaster mm join deviceMapMasterAdmin dmma join device d on mm.mapMasterID=dmma.mapMasterID where dmma.deviceMapMasterPullData=1 and d.isLive=1 and dmma.deviceMasterID in((select deviceMasterID from device where deviceID in($devid)))";
                
                $connection = Yii::$app->getDb();
                $command = $connection->createCommand($querymapmaster); 
                $mapmasterData = $command->queryAll(); 
                foreach($mapmasterData as $mmdata){
                    $mmarray[]=$mmdata['mapMasterID'];
                }        

                  
                $hourdiff = round((strtotime($to1) - strtotime($from1))/3600, 1);
                $daysdiff = round(((strtotime($to1) - strtotime($from1))/3600)/24, 0);
                return $this->render('create', [
                'mapmasterData' => $mapmasterData,            
                'devicedata' => $devicedata,
                'headerDataProvider' => $headerDataProvider,
                'dataProvider' => $dataProvider,
                'mmid'=>$mmarray,
                'devid'=>$devid,
                'mapMasterName'=>$datamapmaster[0]['mapMasterName'],
                'dataFrom'=> $fromdate.' to '.$todate,
                'groupName'=>$groupName,            
                'mapMasterID'=>$mapMasterID,
                'modBusIDs'=>$modBusIDs,
                'gatewayID'=>'',
                'daterange'=>$from1.'-'.$to1,
                'hourdiff'=>$hourdiff,
                'daysdiff'=>$daysdiff,
                'start_date'=>$from1,
                'end_date'=>$to1,
                'datagroup'=>$datagroup,
                'groupID'=>$groupID
                    ]);
                
    }

    /**
     * Updates an existing MapMaster model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $mapMasterID Map Master ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($mapMasterID)
    {
        $model = $this->findModel($mapMasterID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'mapMasterID' => $model->mapMasterID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing MapMaster model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $mapMasterID Map Master ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($mapMasterID)
    {
        $this->findModel($mapMasterID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the MapMaster model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $mapMasterID Map Master ID
     * @return MapMaster the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($mapMasterID)
    {
        if (($model = MapMaster::findOne(['mapMasterID' => $mapMasterID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
    
    
    public function actionPdf() {

        ob_start();
        $qparam= Yii::$app->request->queryParams;
        $mapMasterID =0;
        $deviceID =0;
        $deviceName='';
        $gatewayID=0;
        $htmldata ='';
        
        date_default_timezone_set("Asia/Calcutta");  
   
           if(Yii::$app->request->post()){
            $postdata=Yii::$app->request->post();
            $deviceID=$postdata['deviceID'];
            $mapMasterID=$postdata['mapMasterID'];
            $daterange1=$postdata['daterange'];
            $daterange = explode('-', $daterange1);
            $from=$daterange[0];
            $patern = array("/", ":", " ");
            $from1 = str_replace($patern, "", $from);            
            $to=$daterange[1];
            $to1 = str_replace($patern, "", $to);
            
            //$table='deviceData';
           }else{
            //$table='deviceDataDaily';
            $time = time();
            $mapMasterID=4;
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('0 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'005900';
            
            //die();
           }
           if(isset($_REQUEST['date'])){
            $daterange = explode('-', $_REQUEST['date']);
            $from1=$daterange[0];
            $to1=$daterange[1];
           }
           
           $currentdata = date("YmdHis");
           $backdate= date('Ymd', strtotime('-24 hours', strtotime($currentdata))).'000000';
           if($from1 >= $backdate){
               $table='deviceDataDaily';
           }else{
            $table='deviceData';
           }

        if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;

        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM device d join gateway g join $table dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.isLive=1 and g.siteID=$siteID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querydevice);  
        $devicedata = $command->queryAll(); 

        if(isset($qparam['deviceID'])){
            $res=explode("_",$qparam['deviceID']);
            $deviceID=$res[0];
            $gatewayID=$res[1];
           }else if (count($devicedata) >0){
            $deviceID=$devicedata[0]['modBusID'];
            $gatewayID=$devicedata[0]['gatewayID'];
            $mapMasterID=4;
           }
        
           if(Yii::$app->request->post()){
            $postdata=Yii::$app->request->post();            
            $mapMasterID=$postdata['mapMasterID'];
            $res=explode("_",$postdata['deviceID']);
            $deviceID=$res[0];
            $gatewayID=$res[1];
           }


           if(isset($qparam['date'])){            
            $mapMasterID=$qparam['mapMasterID'];
            $res=explode("_",$qparam['deviceid']);
            $deviceID=$res[0];
            $gatewayID=$res[1];

            $date = $qparam['date'];
            $daterange = explode('-', $date);
            $from1=$daterange[0];                      
            $to1=$daterange[1];           
           }else if(isset($qparam['olddata']) && $qparam['olddata1'] ==''){
            $res=explode("_",$qparam['olddata']);            
            $gatewayID=$res[0];
            $deviceID=$res[1];
            $mapMasterID=$res[2];
            $daterange=$res[3];
            $daterange = explode('-', $daterange);
            $from1=$daterange[0];                      
            $to1=$daterange[1];
        }else if(isset($qparam['olddata']) && isset($qparam['olddata1']) && $qparam['olddata1'] !=''){            
            $res=explode("_",$qparam['olddata1']);  
            //print_r($res[1]);
            //die();          
            $gatewayID=$res[0];
            $deviceID=$res[1];
            $mapMasterID=$res[2];
            $daterange=$res[3];
            $daterange = explode('-', $daterange);
            $from1=$daterange[0];                      
            $to1=$daterange[1];
           }
           //echo'from1='.$from1;  
           //echo'<BR>';                  
          //echo'to1='. $to1;

           $hourdiff = round((strtotime($to1) - strtotime($from1))/3600, 0);   
              
          // echo'<BR>';  
           $daysdiff = round(((strtotime($to1) - strtotime($from1))/3600)/24, 0);
  
            if($hourdiff < 24 || $hourdiff == 1){
              // echo'if';
               //if(isset($_REQUEST['date']))
            $from2= date('YmdHis', strtotime('0 hours', strtotime($from1)));
            //else
            //$from2= date('YmdHis', strtotime('-1 hours', strtotime($from1)));
            $to2= $to1;
            } else if($hourdiff < 1){
             // echo'else if';
             $from2= date('YmdHis', strtotime('0 hours', strtotime($from1)));
             $to2= $to1;
             }          
            else if($daysdiff >= 1 && $to1 < $currentdata){
             // echo'elseif';
            $to2= $to1;
            $from2= date('YmdHis', strtotime('-24 hours', strtotime($from1)));
            
            //if($to1 < $currentdata)
            $daysdiff=$daysdiff+1;
            }else{
              //echo'else';
                $from2= $from1;
                $to2= $to1; 
            }

            
        if($from1 >= $backdate){
            $table='deviceDataDaily';
        }else{
            $table='deviceData';
        }


        $querymm= "SELECT mapMasterName FROM mapMaster where mapMasterID=$mapMasterID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymm);  
        $mapmaster = $command->queryAll(); 
        //print_r($mapmaster);
        //die();
        

        $querymapmaster= "SELECT distinct(mm.mapMasterID),mm.mapMasterCode,mm.mapMasterName FROM `mapMaster` mm join $table dd join device d on dd.mapMasterID=mm.mapMasterID and d.modBusID=dd.deviceID where dd.deviceID=$deviceID and dd.gatewayID=$gatewayID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymapmaster); 
        $mapmasterData = $command->queryAll(); 
        
              

         if($mapMasterID > 0 && $deviceID > 0)  {

            $querydevice="select deviceName from device where modBusID=$deviceID and gatewayID=$gatewayID";
            //die();
            $command = $connection->createCommand($querydevice);
            $deviceres = $command->queryAll(); 
             $deviceName=$deviceres[0]['deviceName'];

             
            $querydevicedata= "select * from $table where timeStamp between '".$from2."' and '".$to2."' and deviceID=$deviceID and mapMasterID=$mapMasterID and gatewayID=$gatewayID order by timeStamp asc";
    //die();
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querydevicedata); 
        $dataProvider = $command->queryAll();  
        }else{
           $dataProvider=[];
         }

    
     $fromdate = date('d M h:i A', strtotime($from1));
      $todate = date('d M h:i A', strtotime($to1));


      $dataFrom=$fromdate.' to '.$todate;
      $start_date=$from1;
      $end_date=$to1;
      $mapMasterName=$mapmaster[0]['mapMasterName'];

      $dataarr=array();
        $currentdata = date("YmdHis");

        $startcheck=substr($start_date, 0, -6);
        //echo'<BR>';
        $endcheck=substr($end_date, 0, -6);
        $condition=0;
        $unique_arr=array();

        if($hourdiff >1 && $daysdiff <=1 && $startcheck ==$endcheck){
        $startTime=substr($start_date, 0, -6);
        //echo 'if111'; 
        for($j=0;$j<$hourdiff+1;$j++){
        if($j<10)
        $hour='0'.$j;
        else
        $hour=$j;
        
        $checkdate1 = $startTime.$hour.'59';
        //echo'<br>';
        $checkdate2 = $startTime.$hour.'58';
        $checkdate3 = $startTime.$hour.'57';
        $checkdate4 = $startTime.$hour.'56';
        $checkdate5 = $startTime.$hour.'55';
    
        for($i=0;$i<count($dataProvider);$i++){    
        //echo'if';
        if(str_contains($dataProvider[$i]['timeStamp'],$checkdate1))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate2))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate3))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate4))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate5))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        }
        }
        $temp = array_unique(array_column($dataarr, 'timeStamp'));
        $unique_arr = array_intersect_key($dataarr, $temp);

        }else if($hourdiff ==24 && $hourdiff > 1 && $daysdiff <= 2){
        $startTime=substr($start_date, 0, -6);
        //echo 'else if1'; 
        for($j=0;$j<$hourdiff+1;$j++){
            if($j<10)
        $hour='0'.$j;
        else
        $hour=$j;
        
        $checkdate1 = $startTime.$hour.'59';
        //echo'<br>';
        $checkdate2 = $startTime.$hour.'58';
        $checkdate3 = $startTime.$hour.'57';
        $checkdate4 = $startTime.$hour.'56';
        $checkdate5 = $startTime.$hour.'55';
    
        for($i=0;$i<count($dataProvider);$i++){    
        //echo'if';
        if(str_contains($dataProvider[$i]['timeStamp'],$checkdate1))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate2))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate3))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate4))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate5))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        }
        }
        $temp = array_unique(array_column($dataarr, 'timeStamp'));
        $unique_arr = array_intersect_key($dataarr, $temp);
        }else if($hourdiff >= 24 && $daysdiff >= 2){  
        //$startDay=substr($start_date, 0, -8); 
        $startTime=substr($start_date, 0, -8);
        $day= substr($start_date,6, 2);
        $month= substr($start_date,4, 2);
        
        //echo'else if2'; 
        for($j=0;$j<=$daysdiff;$j++){
            if($j==0)
            $day=$day;
            else
            $day=$day+1;

            $maxDays=date('t', strtotime($start_date));
        

            if($maxDays == $day-1){
                $day=1;
                $month=$month+1;
            }
        if(strlen($day)==1)
        $day='0'.$day;
        
        if(strlen($month)==1)
        $month='0'.$month;
        
        $checkdate1 = date('Y', strtotime('0 hours', strtotime($start_date))).$month.$day.'0059';
        //echo'<BR>';
        $checkdate2 = date('Y', strtotime('0 hours', strtotime($start_date))).$month.$day.'0058';
        $checkdate3 = date('Y', strtotime('0 hours', strtotime($start_date))).$month.$day.'0057';
        $checkdate4 = date('Y', strtotime('0 hours', strtotime($start_date))).$month.$day.'0056';
        $checkdate5 = date('Y', strtotime('0 hours', strtotime($start_date))).$month.$day.'0055';
        $checkdate6 = date('Y', strtotime('0 hours', strtotime($start_date))).$month.$day;
    
        for($i=0;$i<count($dataProvider);$i++){    
        
        
        if(str_contains($dataProvider[$i]['timeStamp'],$checkdate1))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate2))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate3))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate4))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate5))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        else if(str_contains($dataProvider[$i]['timeStamp'],$checkdate6))
        $dataarr[]=array("timeStamp"=>$checkdate1,"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        
        //}
        }
        }
    
        $temp = array_unique(array_column($dataarr, 'timeStamp'));
        $unique_arr = array_intersect_key($dataarr, $temp);
        }else if(($hourdiff ==0  || $hourdiff ==1 ) && $daysdiff==0 && $startcheck ==$endcheck){   
        //echo 'elseif3'; 
        $condition=4;
        for($i=0;$i<count($dataProvider);$i++){ 
            $unique_arr[]=array("timeStamp"=>$dataProvider[$i]['timeStamp'],"data"=>$dataProvider[$i]['data'],"deviceID"=>$dataProvider[$i]['deviceID'],"mapMasterID"=>$dataProvider[$i]['mapMasterID'],"gatewayID"=>$dataProvider[$i]['gatewayID']);
        }
        }  
        
        if(isset($_REQUEST['date']) && isset($_REQUEST['olddata']) && isset($_REQUEST['olddata1']) && $_REQUEST['olddata1']=='' &&  $hourdiff >1){
            // echo'iffff';
         $olddata=$_REQUEST['olddata'];
         $olddata1='';
         }else if(isset($_REQUEST['date']) && isset($_REQUEST['olddata']) && isset($_REQUEST['olddata']) && $_REQUEST['olddata'] !='' && $hourdiff ==1){
             //echo'elseiffff';
         $olddata1=$_REQUEST['olddata'];
         $olddata=$_REQUEST['date'];
         }else{
            // echo'elseeeee';
         $olddata=$gatewayID.'_'.$deviceID.'_'.$mapMasterID;
         $olddata1='';
         }

         if (isset($_REQUEST['deviceID'])){
            $res=explode("_",$_REQUEST['deviceID']);
                    $deviceID=$res[0];
                    $gatewayID=$res[1];
        }
        
        $resdate=explode(" to ",$dataFrom);
                    $fromrange=$resdate[0];
                    $torange=$resdate[1];
        $dateinterval=$fromrange.'-'.$torange;

        $htmldata .='<html><head><link href="style.css" type="text/css" rel="stylesheet"/></head><body><div class="content-part mt-3">
            <div class="top-heading-part">
                <h4 class="heading-text">Data Reports for '.$deviceName.'</h4>                
            </div>
            <div class="bottom-content">
                <div class="row w-100">
                    <div class="col-md-9">
                        <div class="chart-part">
                            <div class="top-lineChart">
                                <h5>'.$mapMasterName.' <span>Data From</span> '.$dataFrom.'</h5>
                                <div id="line-chart"></div>
                            </div>
                            <div class="bottom-barChart">
                                <div class="barChart-heading">
                                    <h6>Daily Comparison Report</h6>
                                </div>
                                <div id="bar-chart" class="mt-5 mb-3">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="content">
                            <div class="table-part light-blue-border">
                                <div class="top-line light-blue">
                                    <p>Raw Data</p>
                                    <p>
                                </div>
                                <table>
                                <tr>
                                <th style="font-size:12px">Timestamp</th>
                                <th style="font-size:12px">'.$mapMasterName.' Data</th>                                
                                </tr>
                                </thead>
                                <tbody>';
                                
                                $k=0;
                                //$k1=$k;
                                $unique_arr = array_values($unique_arr);
                                //echo'<PRE>';
                                //print_r($unique_arr);
                                //die();
                                $timelength=0;
                                if(count($unique_arr) >0){
                                foreach($unique_arr as $data){
                                    if($k < count($unique_arr)){
                                    
                                    //echo'<BR>';
                                    
                                    $datavalue=0;        
                                    $converteddata = date('d M Y h:i A', strtotime($unique_arr[$k]['timeStamp']));
                                    
                                    if ($unique_arr[$k]['mapMasterID']==6 || $unique_arr[$k]['mapMasterID']==7 || $unique_arr[$k]['mapMasterID']==305){    
                                        if($k+1==count($unique_arr))
                                        $datavalue1=round(($unique_arr[$k]['data']-$unique_arr[$k]['data']),3);
                                        else
                                        $datavalue1=round(($unique_arr[$k+1]['data']-$unique_arr[$k]['data']),3);
                                
                                        $datavalue=$datavalue1.'<BR>('.round($unique_arr[$k]['data'],3).')';
                                    }else{
                                        $datavalue=$unique_arr[$k]['data'];
                                    }
                                    $deviceid=$unique_arr[$k]['deviceID'];
                                    $mapMasterID=$unique_arr[$k]['mapMasterID'];
                                    $gatewayID=$unique_arr[$k]['gatewayID'];
                                
                                    //if($timelength == 12){
                                
                                    $htmldata .='<tr data-key="1">
                                    <td>';
                                    
                                    //if($timelength == 12){
                                    if($condition ==4){
                                         $converteddata;
                                        }else if ($hourdiff  == 24 ){
                                            //$from=$unique_arr[$k]['timeStamp'].'00';
                                            $from=substr($unique_arr[$k]['timeStamp'], 0, -4);
                                            $to = date('YmdHi', strtotime('0 hours', strtotime($from)));
                                            $to=substr($to, 0, -4);
                                            
                                            $htmldata .='<a href="index.php?r=single-data/index&mapMasterID='.$mapMasterID.'&deviceid='.$deviceid.'_'.$gatewayID.'&date='.$from.'005900-'.$to.'235900&olddata='.$olddata.'&olddata1='.$olddata1.'?>&pid='.$_REQUEST['pid'].'" style="background-color: white;font-size:13px;">'.$converteddata.'</a>';
                                        }else if ($hourdiff  > 24 ){
                                            //$from=$unique_arr[$k]['timeStamp'].'00';
                                            $from=substr($unique_arr[$k]['timeStamp'], 0, -4);
                                            $to = date('YmdHi', strtotime('0 hours', strtotime($from)));
                                            $to=substr($to, 0, -4);
                                            
                                            $htmldata .='<a href="index.php?r=single-data/index&mapMasterID='.$mapMasterID.'&deviceid='.$deviceid.'_'.$gatewayID.'&date='.$from.'005900-'.$to.'235900&olddata='.$olddata.'&olddata1='.$olddata1.'?>&pid='.$_REQUEST['pid'].'" style="background-color: white;font-size:13px;">'.$converteddata.'</a>';
                                        }else{
                                            if($k+1==count($unique_arr)){
                                                $htmldata .='<a href="index.php?r=single-data/index&mapMasterID='.$mapMasterID.'&deviceid='.$deviceid.'_'.$gatewayID.'&date='.$unique_arr[$k]['timeStamp'].'00-'.$end_date.'&olddata='.$olddata.'&olddata1='.$olddata1.'&pid='.$_REQUEST['pid'].'" style="background-color: white;font-size:13px;">'.$converteddata.'</a>';
                                    }else{
                                        
                                        $htmldata .='<a href="index.php?r=single-data/index&mapMasterID='.$mapMasterID.'&deviceid='.$deviceid.'_'.$gatewayID.'&date='.$unique_arr[$k]['timeStamp'].'00-'.$unique_arr[$k+1]['timeStamp'].'00&olddata='.$olddata.'&olddata1='.$olddata1.'&pid='.$_REQUEST['pid'].'" style="background-color: white;font-size:13px;">'.$converteddata.'</a>';
                                
                                        }
                                    }
                                
                                $htmldata .= '</td>
                                <td>'.$datavalue.'</td>
                                </tr>';
                                
                                $k=$k+1;
                                //$k1=$k1+1;
                                //}
                                    }
                                    } 
                                }else{ 
                                
                                $htmldata .= ' <tr data-key="1">                                
                                <td colspan=2>Data Not Available.</td>
                                </tr>';
                                }
                                
                                $htmldata .= '</table>
                            </div>
                        </div>
                    </div>
                </div></div></div></body></html>';

                $htmldata .= '<script src="./assest/js/jquery.min.js"></script>
<script src="./assest/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>';

$htmldata .= '<script type="text/javascript">
    google.charts.load("current", { "packages": ["corechart"] });
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {
        var data = google.visualization.arrayToDataTable([
            ["dateTime", "<?php echo $mapMasterName?>"],
            
            <?php
              $p=0;
     
            if(count($unique_arr) >0){
                foreach($unique_arr as $data){
                    if($p < count($unique_arr)){                 
                
                        $converteddata = date("d M h.i A", strtotime($unique_arr[$p]["timeStamp"]));
                        $datavalue=$unique_arr[$p]["data"];
?>
                        
                        ["<?php echo $converteddata ?>", <?php echo $datavalue?>],
                        <?php
                        $p=$p+1; 
                    } 
                }
            }            
           ?> 
            
        ]);

        var options = {
            legend: {position: "top", textStyle: {color: "blue", fontSize: 16}}, hAxis: { direction:1, slantedTextAngle:true, maxAlternation: 2 },chartArea:{left:"5%",top:5,width:"90%",height:"55%"},
        }
        var chart = new google.visualization.AreaChart(document.getElementById("line-chart"));
        chart.draw(data, options);
    }
    $(window).resize(function () {
        drawChart();
    });
</script>';



               // echo $htmldata;
                

                  $pdf = new Pdf([
                      // set to use core fonts only
                      'mode' => Pdf::MODE_UTF8, 
                      // A4 paper format
                      'format' => Pdf::FORMAT_A4, 
                      // portrait orientation
                      'orientation' => Pdf::ORIENT_PORTRAIT, 
                      // stream to browser inline
                      'destination' => Pdf::DEST_BROWSER, 
                      // your html content input
                      'content' => $htmldata,  
                      // format content from your own css file if needed or use the
                      // enhanced bootstrap css built by Krajee for mPDF formatting 
                      //'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
                      'cssFile' => '',
                      // any css to be embedded if required
                      'cssInline' => '.kv-heading-1{font-size:18px}', 
                       // set mPDF properties on the fly
                      'options' => ['title' => 'Single Data Chart Report'],
                       // call mPDF methods on the fly
                      'methods' => [ 
                          'SetHeader'=>['Single Data Chart Report'], 
                          'SetFooter'=>['{PAGENO}'],
                      ]
                  ]); 
                  Yii::$app->response->format = \yii\web\Response::FORMAT_RAW;
Yii::$app->response->headers->add('Content-Type', 'application/pdf');
ob_end_flush();
                  echo $pdf->render();
                }
}


