<?php

namespace app\controllers;

use Yii;
use yii\base\ErrorException;
use yii\rest\Controller;
use app\models\DeviceMaster;
use app\models\Config;
use app\models\QtaConfig;
use app\models\ReadTagConfig;
use app\models\QueryRead;
use app\models\DeviceData;
use app\models\ConfigApiResponse;
use app\models\ConfigApiStatus;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Html;
use yii\filters\auth\QueryParamAuth;
use common\components;

use Exception;
/**
* Modem controller
*/
class ModemController extends Controller {

  /**
  * @inheritdoc
  */
  protected function verbs() {
    return [
    'login' => ['POST'],
    ];
  }

 
  public function actionGetconfig() 
  {
    $request=Yii::$app->request;
    $value = $request->post();
    
    $boxID = !empty($value['boxID']) ? $value['boxID'] : '';
    $DC = !empty($value['dc']) ? $value['dc'] : '';
    $request_data='{"boxID":'.$boxID.', "DC":'.$DC.'}';
    //$model_DeviceMaster= new DeviceMaster(); 

    $model_Config =Config::findOne(['configID' => 1]);
    
    $model_QtaConfig = QtaConfig::find()->where(['configID' => 1])->all();
    //print_r($DC);
    if($boxID=='2011DCM0001' && $DC==0){    
      $sql_selectqta = "SELECT * FROM qtaConfig WHERE configID=$model_Config->configID";
      $resqtaLists= Yii::$app->db->createCommand($sql_selectqta)->queryall();
      if(count($resqtaLists)> 0){
        foreach($resqtaLists AS $qtavalue){
          $slaveID=$qtavalue['slaveID'];
          $timeOut=$qtavalue['timeOut'];
          $delayQueryAfterResponse=$qtavalue['delayQueryAfterResponse'];
          $addressMinusValue=$qtavalue['addressMinusValue'];
          $ipIndex0=$qtavalue['ipIndex0'];
          $ipIndex1=$qtavalue['ipIndex1'];
          $ipIndex2=$qtavalue['ipIndex2'];
          $ipIndex3=$qtavalue['ipIndex3'];						
          $measurementLists1[]=array("D"=>(array((int)$slaveID,(int)$timeOut,(int)$delayQueryAfterResponse,(int)$addressMinusValue,(int)$ipIndex0,(int)$ipIndex1,(int)$ipIndex2,(int)$ipIndex3)));
        }
      }
      $userdata=array("comMethod"=>$model_Config->comMethod,
      "comURL"=>$model_Config->comURL,
      "userID"=>$model_Config->userID,
      "password"=>$model_Config->password,
      "dataInterval"=>$model_Config->dataInterval,
      "statusInterval"=>$model_Config->statusInterval,
      "baudRate"=>$model_Config->baudRate,
      "lineControl"=>$model_Config->lineControl,
      "numOfMeters"=>$model_Config->numOfMeters,
      "retryCount"=>$model_Config->retryCount,
      "deviceType"=>$model_Config->deviceType,
      "qtaConfig"=>$measurementLists1,
      "qta"=>"end"
      );
    }
    
      if($boxID=='2011DCM0001' && $DC==1){  
    $model_Config =Config::findOne(['configID' => 1]);
    
    $model_QtaConfig = QtaConfig::find()->where(['configID' => 1])->all();


      $sql_selectqrd = "SELECT * FROM queryRead WHERE slaveID=1";
      $resqrdLists= Yii::$app->db->createCommand($sql_selectqrd)->queryall();
      if(count($resqrdLists)> 0){
        foreach($resqrdLists AS $qrdvalue){
          $slaveID=$qrdvalue['slaveID'];
          $functionCode=$qrdvalue['functionCode'];
          $readAddress=$qrdvalue['readAddress'];
          $numberOfRegisterAddress=$qrdvalue['numberOfRegisterAddress'];
          $queryRead[]=array("QRD"=>(array((int)$slaveID,(int)$functionCode,(int)$readAddress,(int)$numberOfRegisterAddress)));
        }
      }

      $sql_selectrtd = "SELECT * FROM readTagConfig WHERE slaveID=1";
      $resrtdLists= Yii::$app->db->createCommand($sql_selectrtd)->queryall();
      
      if(count($resrtdLists)> 0){
        foreach($resrtdLists AS $rtdvalue){
          $slaveID=$rtdvalue['slaveID'];
          $dataType=$rtdvalue['dataType'];
          $MF=$rtdvalue['MF'];

          $readTagConfig[]=["C"=>array((int)$slaveID,$dataType,(int)$MF)];
         /* if($rtdvalue['queryNumber']==0){
            $readTagConfig0[]=["C"=>array((int)$slaveID,$dataType,(int)$MF)];
            }else if($rtdvalue['queryNumber']==1){
              $readTagConfig1[]=["C"=>array((int)$slaveID,$dataType,(int)$MF)];          
            }else if($rtdvalue['queryNumber']==2){
              $readTagConfig2[]=["C"=>array((int)$slaveID,$dataType,(int)$MF)];
            }*/
           
          }
        }
        //sleep(10);
        $userdata=array(
        "queryRead"=>$queryRead,
        "qra"=>"end",
        "readTagConfig"=>array(array("RTD"=>array($readTagConfig[0])),array("RTD"=>array($readTagConfig[1])),array("RTD"=>array($readTagConfig[2]))),
        "rtc"=>"end"
      );
    }
        
    if($boxID=='2011DCM0001' && $DC==2){ 
      $sql_selectqrd = "SELECT * FROM queryRead WHERE slaveID=2";
      $resqrdLists= Yii::$app->db->createCommand($sql_selectqrd)->queryall();
      if(count($resqrdLists)> 0){
        foreach($resqrdLists AS $qrdvalue){
          $slaveID=$qrdvalue['slaveID'];
          $functionCode=$qrdvalue['functionCode'];
          $readAddress=$qrdvalue['readAddress'];
          $numberOfRegisterAddress=$qrdvalue['numberOfRegisterAddress'];
          $queryRead[]=array("QRD"=>(array((int)$slaveID,(int)$functionCode,(int)$readAddress,(int)$numberOfRegisterAddress)));
        }
      }

      $sql_selectrtd = "SELECT * FROM readTagConfig WHERE slaveID=2";
      $resrtdLists= Yii::$app->db->createCommand($sql_selectrtd)->queryall();
      
      if(count($resrtdLists)> 0){
        foreach($resrtdLists AS $rtdvalue){
          $slaveID=$rtdvalue['slaveID'];
          $dataType=$rtdvalue['dataType'];
          $MF=$rtdvalue['MF'];

          $readTagConfig[]=["C"=>array((int)$slaveID,$dataType,(int)$MF)];
         /* if($rtdvalue['queryNumber']==3){
            $readTagConfig3[]=["C"=>array((int)$slaveID,$dataType,(int)$MF)];
            }else if($rtdvalue['queryNumber']==4){
              $readTagConfig4[]=["C"=>array((int)$slaveID,$dataType,(int)$MF)];          
            }*/
           
          }
        }
        //sleep(10);
        $userdata=array(
        "queryRead"=>$queryRead,
        "qra"=>"end",
        "readTagConfig"=>array(array("RTD"=>array($readTagConfig[0])),array("RTD"=>array($readTagConfig[1]))),
        "rtc"=>"end"
      );
    }
     
     $response["error"] = 0;
      $response["successful"] = 1; 
      $response["message"] = "Device Data";                       
      $response["deviceData"] = $userdata;
     return $userdata;
        
  } 


  public function actionGetconfig1() 
  {
    $request=Yii::$app->request;
    $value = $request->post();
    
    $boxID = !empty($value['boxID']) ? $value['boxID'] : '';
    $DC = !empty($value['dc']) ? $value['dc'] : '';

    $model_Config =Config::findOne(['configID' => 1]);
    
    if($boxID=='2011DCM0001' && $DC==0){    
      $sql_selectqta = "SELECT * FROM qtaConfig WHERE configID=$model_Config->configID";
      $resqtaLists= Yii::$app->db->createCommand($sql_selectqta)->queryall();
      if(count($resqtaLists)> 0){
        foreach($resqtaLists AS $qtavalue){
          $slaveID=$qtavalue['slaveID'];
          $timeOut=$qtavalue['timeOut'];
          $delayQueryAfterResponse=$qtavalue['delayQueryAfterResponse'];
          $addressMinusValue=$qtavalue['addressMinusValue'];
          $ipIndex0=$qtavalue['ipIndex0'];
          $ipIndex1=$qtavalue['ipIndex1'];
          $ipIndex2=$qtavalue['ipIndex2'];
          $ipIndex3=$qtavalue['ipIndex3'];						
          $measurementLists1[]=array("D"=>(array((int)$slaveID,(int)$timeOut,(int)$delayQueryAfterResponse,(int)$addressMinusValue,(int)$ipIndex0,(int)$ipIndex1,(int)$ipIndex2,(int)$ipIndex3)));
        }
      }
      $userdata=array("comMethod"=>$model_Config->comMethod,
      "comURL"=>$model_Config->comURL,
      "userID"=>$model_Config->userID,
      "password"=>$model_Config->password,
      "dataInterval"=>$model_Config->dataInterval,
      "statusInterval"=>$model_Config->statusInterval,
      "baudRate"=>$model_Config->baudRate,
      "lineControl"=>$model_Config->lineControl,
      "numOfMeters"=>$model_Config->numOfMeters,
      "retryCount"=>$model_Config->retryCount,
      "deviceType"=>$model_Config->deviceType,
      "qtaConfig"=>$measurementLists1,
      "qta"=>"end"
      );
    }
    
      // for meters  
    if($boxID=='2011DCM0001' && $DC==1 || $DC==2){ 
      $sql_selectqrd = "SELECT * FROM deviceMapMasterAdmin WHERE deviceMasterID=$DC and deviceMapMasterPullData=1";
      $resqrdLists= Yii::$app->db->createCommand($sql_selectqrd)->queryall();
      if(count($resqrdLists)> 0){
        foreach($resqrdLists AS $qrdvalue){
          $slaveID=$qrdvalue['deviceMasterID'];
          $functionCode=3;
          $readAddress=$qrdvalue['deviceMapMasterPort'];
          $numberOfRegisterAddress=count($resqrdLists);
          $queryRead[]=array("QRD"=>(array((int)$slaveID,(int)$functionCode,(int)$readAddress,(int)$numberOfRegisterAddress)));
        }
      }

      $sql_selectrtd = "SELECT dmma.deviceMasterID,dmma.deviceMapMasterMF,md.mapDataTypeSymbol
       FROM deviceMapMasterAdmin as dmma left join mapDataType as md on dmma.mapDataTypeID=md.mapDataTypeID 
       where dmma.deviceMasterID=$DC";
      $resrtdLists= Yii::$app->db->createCommand($sql_selectrtd)->queryall();
      
      if(count($resrtdLists)> 0){
        foreach($resrtdLists AS $rtdvalue){
          $slaveID=$rtdvalue['deviceMasterID'];
          $dataType=$rtdvalue['mapDataTypeSymbol'];
          $MF=$rtdvalue['deviceMapMasterMF'];

          $readTagConfig[]=array("RTD"=>array(array("C"=>array((int)$slaveID,$dataType,(int)$MF))));
           
          }
        }
        //sleep(10);
        $userdata=array(
        "queryRead"=>$queryRead,
        "qra"=>"end",
        "readTagConfig"=>$readTagConfig,
        "rtc"=>"end"
      );
    }

     $response["error"] = 0;
      $response["successful"] = 1; 
      $response["message"] = "Device Data";                       
      $response["deviceData"] = $userdata;
     return $userdata;
        
  }


  public function actionDatareceiver() 
  {
    $model_ConfigResponse= new ConfigApiResponse();
    $model_ConfigStatus= new ConfigApiStatus();
    
    //$request=Yii::$app->request;
    $value = Yii::$app->request->post();
    
    // meter data coming from modem and we are storing in table
    if (strpos(json_encode($value), 'RTS') == true) {
    $model_ConfigResponse->responseData=json_encode($value);
    $model_ConfigResponse->save(false);
    
    $value2=json_encode($value);
    $value1=json_decode($value2);
   $resvalue= $value1->DD;
    for($i=0;$i<count($value1->DD);$i++){
    $deviceID=$resvalue[$i]->D;
    //$mapMasterID=$resvalue[$i]->D;
    $timeStamp=$resvalue[$i]->DT;
    $p=$resvalue[$i]->P;

    $sql_selectmapMasterID = "SELECT mapMasterID FROM deviceMapMasterAdmin WHERE
     deviceMasterID=$deviceID and deviceMapMasterPort in(select readAddress from queryRead where slaveID=$deviceID)";
      $resmapMasterID= Yii::$app->db->createCommand($sql_selectmapMasterID)->queryall();
      //echo'mapMasterID='.$resmapMasterID[0]['mapMasterID'];
      //die();
      if(count($p)==count($resmapMasterID)){
      for($j=0;$j<count($p);$j++){
        $model_DeviceData= new DeviceData();        
        $model_DeviceData->timeStamp=$timeStamp;
        $model_DeviceData->deviceID=$deviceID;
        $model_DeviceData->mapMasterID=$resmapMasterID[$j]['mapMasterID'];
        $model_DeviceData->data=$p[$j];
        $model_DeviceData->save(false);
      }
    }
    }
   
  }else{
   
    $model_ConfigStatus->statusData=json_encode($value);
    $model_ConfigStatus->save(false);    
  }
 // die();
  // Responce send to modem
  
        $result=array(
          "RT"=>1,
          "RM"=>"Success",
          "CM"=>NULL,
          "QW"=>NULL,
          "qwc"=>"end",
          "DC"=>NULL
        );
  
   //$response["error"] = 0;
     // $response["successful"] = 1;  
     // $response["message"] = 'configuration setup';
      return $result;     
  }

  
  public function actionUploadmilestone() 
	{
		define('UPLOAD_DIR', '/Web/JennyCraig/api/milestones/');
		$modelMilestoneImage= new MilestoneImage();
		$value = Yii::$app->request->post();

		$milestoneType = !empty($value['milestoneType']) ? $value['milestoneType'] : '';
		$milestoneImageName = !empty($value['milestoneImageName']) ? $value['milestoneImageName'] : '';
		$s3key=Yii::$app->params['s3key'];
		$s3secret=Yii::$app->params['s3secret'];

		$bucket = 'statics-jc-mobileapp-9530';
		$keyname = 'images/congrats/'.$milestoneType.'.png';
		/* $filepath should be absolute path to a file on disk */                     
		$s3 = S3Client::factory(array(
			'version' => 'latest',
			'region'  => 'us-west-2',    
		'credentials' => array(
					'key'     => $s3key,
					'secret'  => $s3secret,
					)
		));

		if ($milestoneImageName!='') {
			$image_parts = explode(";base64,", $milestoneImageName);
			$image_base64 = base64_decode($image_parts[0]);
			$file = UPLOAD_DIR .$milestoneType.'.png'; 
			file_put_contents($file, $image_base64);

			$filepath=$file;
			$result = $s3->putObject(array(
				'Bucket' => $bucket,
				'Key'    => $keyname,
				'SourceFile'   => $filepath,
				'ACL'    => 'public-read' 
			));


		}

		$sql_select = "select * from milestone_image where milestoneType='$milestoneType'";
		$res= Yii::$app->db->createCommand($sql_select)->queryone();

		if(!$res){
			if ($milestoneImageName!='') {
				if($milestoneType!=''){
					$modelMilestoneImage->milestoneImageName=$milestoneType.'.png';
					$modelMilestoneImage->milestoneType=$milestoneType;
					$modelMilestoneImage->created_at=date('Y-m-d');
					$modelMilestoneImage->save(false);
				}
				$response["error"] = 0;
				$response["successful"] = 1;
				$response["message"] = 'Saved'; 
				$response["imageUrl"] = "https://statics-mobileapp.jennycraig.com/images/congrats/".$milestoneType.'.png'; 
			}else{
				$response["error"] = 1;
				$response["successful"] = 0;
				$response["message"] = 'Milestone not uploaded';                         
						
			}                      
					
		}else{
			$milestoneImageName=$res['milestoneImageName'];
			$response["error"] = 1;
			$response["successful"] = 0;
			$response["message"] = 'Already available';
			if($milestoneImageName!='.png')
			$response["imageUrl"] = "https://statics-mobileapp.jennycraig.com/images/congrats/".$milestoneImageName;                         
					
		}                        
		return $response;

	}


   
}