<?php

namespace app\controllers;
use yii;
use app\models\ManageDevice;
use app\models\ManageDeviceSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use kartik\mpdf\Pdf;
/**
 * DeviceController implements the CRUD actions for Device model.
 */
class ManageDeviceController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Device models.
     *
     * @return string
     */

    public function actionIndex()
    {

        if(isset($_REQUEST['siteID']))
        $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;

        $querymeters= "SELECT d.deviceID,d.deviceName,d.modBusID,d.gatewayID,d.isLive,d.lastCommunication FROM device d join gateway  g where d.gatewayID=g.gatewayID and g.siteID=$siteID order by d.gatewayID asc";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querymeters);  
        $total_meters = $command->queryAll();  

        /*$queryheader= "select d.deviceID ,d.gatewayID,mm.mapMasterID,mm.mapMasterName 
        from mapMaster mm join device d join deviceMapMasterAdmin dmma join gateway g where dmma.mapMasterID=mm.mapMasterID and d.deviceMasterID=dmma.deviceMasterID and d.gatewayID=g.gatewayID and dmma.deviceMapMasterPullData=1 and mm.mapMasterName in ('KVAH','KWH') group by deviceID,mapMasterID order by mapMasterID asc";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($queryheader);  
        $headerDataProvider = $command->queryAll(); 

        $query="";
        $query= "select d.deviceName,dd.dataID,d.deviceID,d.isLive,dd.gatewayID,mm.mapMasterName,";
        foreach($headerDataProvider as $hdata){
            $mapmname=$hdata['mapMasterName'];
            $query.="coalesce(sum(case when mm.mapMasterName = '$mapmname' then dd.data end), 0) as '$mapmname',";
        }
        
        $query.="dd.timeStamp as 'Last Meter Communication'
        from deviceData dd join mapMaster mm join device d where dd.mapMasterID=mm.mapMasterID and d.modBusID=dd.deviceID and d.gatewayID=dd.gatewayID group by dd.timeStamp , dd.deviceID order by dd.timeStamp desc limit 0,50";
        
        
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);  
        $dataProvider = $command->queryAll();  
        */
        //echo'<pre>';
        //print_r($dataProvider);
        //die();
       
      // setup kartik\mpdf\Pdf component
      
        return $this->render('index', [
            'headerDataProvider' => [],
            'dataProvider' => [],
            'total_meters' => $total_meters
        ]);
    }
    

    /*public function actionIndex()
    {
        $qparam= Yii::$app->request->queryParams;
        if(isset($qparam['display'])){
            $display=$qparam['display'];
            if($display==1)
              $display=0;
            else if($display==0)
              $display=1;
            $id=$qparam['id'];
            //die();
            Yii::$app->db->createCommand()
            ->update('device', ['isLive' => $display], "modBusID=$id")
            ->execute();
           }

        
   $queryheader= "select d.deviceID ,d.modBusID,mm.mapMasterID,mm.mapMasterName 
   from mapMaster mm join device d join deviceMapMasterAdmin dmma where dmma.mapMasterID=mm.mapMasterID and d.deviceMasterID=dmma.deviceMasterID and dmma.deviceMapMasterPullData=1 and mm.mapMasterName in ('KVAH','KWH') group by mapMasterID order by deviceID asc";
   $connection = Yii::$app->getDb();
   $command = $connection->createCommand($queryheader);        
  
   $headerDataProvider = $command->queryAll(); 

   $querycount="SELECT distinct(dd.deviceID) FROM deviceData dd join gateway g join device d where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID";
   $command = $connection->createCommand($querycount);
   $countquery = $command->queryAll(); 
    $countrow=count($countquery);

    $query="";
    $query= "select max(dd.dataID) as dataID,dd.deviceID, d.deviceName ,d.isLive,d.gatewayID,";
    foreach($headerDataProvider as $hdata){
        $mapmname=$hdata['mapMasterName'];
        //$deviceID=$hdata['deviceID'];
        
        $query.="coalesce(sum(case when mm.mapMasterName = '$mapmname' then dd.data end), 0) as '$mapmname',";
        
    }
    $query.="dd.timeStamp as 'Last Meter Communication'
        from deviceData dd join mapMaster mm join device d where dd.mapMasterID=mm.mapMasterID and d.modBusID=dd.deviceID and d.gatewayID=dd.gatewayID group by dd.timeStamp , dd.deviceID order by dd.timeStamp desc limit 0,500";

    

//echo $query;
//die();
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);        
       
        $dataProvider = $command->queryAll();       

        return $this->render('index', [
            //'searchModel' => $searchModel,
            'headerDataProvider' => $headerDataProvider,
            'dataProvider' => $dataProvider,
            'countrow'=>$countrow
            //'pages' => $pages
        ]);
    }*/

    /**
     * Displays a single Device model.
     * @param int $deviceID Device ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView()
    {
        $qparam= Yii::$app->request->queryParams;
        $mapMasterID =0;
        $deviceID =0;
            $gatewayID=0;
        //$POST_VARIABLE=Yii::$app->request->post();
        $from1='';
        $to1='';
        $mmid='';       
        date_default_timezone_set("Asia/Calcutta"); 
        if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;
        $todaydate= date('Ymd'); 
        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM deviceDataDaily dd join device d join gateway g on dd.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.gatewayID=g.gatewayID where d.isLive=1 and g.siteID=$siteID and dd.mapMasterID in(6,308)  and dd.timeStamp like '$todaydate%' group by dd.deviceID,dd.gatewayID";

        //$querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.isLive=1 and g.siteID=$siteID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($querydevice);  
        $devicedata = $command->queryAll();  
        
        if(isset($_REQUEST['deviceID']) && $_REQUEST['deviceID'] !='All'){
            $mapMasterID=4;
            $deviceID=$_REQUEST['deviceID'];
            $res=explode("_",$deviceID);
            $deviceID=$res[1];
            $gatewayID=$res[0];
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('0 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'000000';
            //$mmid=implode(",",$mapMasterID);
        }else{
            $time = time();
            $mapMasterID=4;
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('0 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'000000';
            if(count($devicedata)>0){
            $deviceID=$devicedata[0]['modBusID'];
            $gatewayID=$devicedata[0]['gatewayID'];
            }
            //$mmid=implode(",",$mapMasterID);
        }

        if(Yii::$app->request->post()){
            $postdata=Yii::$app->request->post();
           //$mapMasterID=$postdata['mapMaster'];
           $deviceID=$postdata['deviceID'];
           if($deviceID !='All'){
           $res=explode("_",$deviceID);
            $deviceID=$res[1];
            $gatewayID=$res[0];
           }
           $daterange=$_REQUEST['datetimes'];
            $daterange = explode('-', $daterange);
             $from=$daterange[0];
             $patern = array("/", ":", " ");
            $from1 = str_replace($patern, "", $from);            
            $to=$daterange[1];
            $to1 = str_replace($patern, "", $to);
           //die();
           //$mmid=implode(",",$mapMasterID);
//die();
           }

        //echo'mmid='.$mmid;
        //die();

       
        //print_r($mmid);
        //die();
        $fromdate = date('d M h:i A', strtotime($from1));
        $todate = date('d M h:i A', strtotime($to1));
        $hourdiff = round((strtotime($to1) - strtotime($from1))/3600, 1);
        

                /*$querydevice="select deviceName from device where modBusID=$deviceID and gatewayID=$gatewayID";
                 //die();
                $command = $connection->createCommand($querydevice);
                $deviceres = $command->queryAll(); 
                $deviceName=$deviceres[0]['deviceName'];                  

                $startcheck=substr($from1, 0, -8);

                $querykwh= "select max(data) as maxdata,min(data) as mindata,max(data) - min(data) as datadiff from deviceData where deviceID=$deviceID and gatewayID=$gatewayID and  (mapMasterID=6 or mapMasterID=308 ) and timeStamp like '$startcheck%'"; 
                $command = $connection->createCommand($querykwh); 
                $reskwh = $command->queryAll();
                //echo'<BR>';
                $querykvah= "select max(data) as maxdata,min(data) as mindata,max(data) - min(data) as datadiff from deviceData where deviceID=$deviceID and gatewayID=$gatewayID and  (mapMasterID=7 or mapMasterID=309 ) and timeStamp like '$startcheck%'"; 
                $command = $connection->createCommand($querykvah); 
                $reskvah = $command->queryAll();*/
                //die();
                //print_r($pdf);
                //die();
                 return $this->render('view', [
                   'mapmasterData' => [],            
                    'devicedata' => $devicedata,
                    'headerDataProvider' => [],
                    'dataProvider' => [],
                    //'mmid'=>$mapMasterID,
                    'mapMasterName'=>'',
                    'dataFrom'=> $fromdate.' to '.$todate,
                    'deviceName'=>'',            
                    'deviceID'=>$deviceID,
                    'gatewayID'=>$gatewayID,
                    'daterange'=>$from1.'-'.$to1,
                    'hourdiff'=>$hourdiff,
                    'start_date'=>$from1,
                    'end_date'=>$to1,
                    'reskwh'=>[],
                    'reskvah'=>[]
                ]);
            
    }


    /**
     * Creates a new Device model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Device();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'deviceID' => $model->deviceID]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Device model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $deviceID Device ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($deviceID)
    {
        $model = $this->findModel($deviceID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'deviceID' => $model->deviceID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Device model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $deviceID Device ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($deviceID)
    {
        $this->findModel($deviceID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Device model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $deviceID Device ID
     * @return Device the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($deviceID)
    {
        if (($model = Device::findOne(['deviceID' => $deviceID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionPdf() {
        $connection = Yii::$app->getDb();
        $htmldata='';
        if(isset($_REQUEST['siteID']))
            $siteID=$_REQUEST['siteID'];
        else
        $siteID=1;
        if(isset($_REQUEST['deviceID']) && $_REQUEST['deviceID'] !='All'){
            $mapMasterID=4;
            $deviceID=$_REQUEST['deviceID'];
            $res=explode("_",$deviceID);
            $deviceID=$res[1];
            $gatewayID=$res[0];
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('0 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'000000';
            //$mmid=implode(",",$mapMasterID);
        }else{
            $time = time();
            $mapMasterID=4;
            $startTime = date("YmdHis");
            $to1= date('YmdHis', strtotime('0 minutes', strtotime($startTime)));
            //echo'<BR>';
            //$to1=$startTime;
            $from1 = date('Ymd', strtotime('0 hours', strtotime($to1))).'000000';
            $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.isLive=1 and g.siteID=$siteID";
        
            $command = $connection->createCommand($querydevice);  
            $devicedata = $command->queryAll(); 
            $deviceID=$devicedata[0]['modBusID'];
            $gatewayID=$devicedata[0]['gatewayID'];
            //$mmid=implode(",",$mapMasterID);
        }
        $start_date1 = date('d M h:i A', strtotime($from1));
        $end_date1 = date('d M h:i A', strtotime($to1));
        $dataFrom =$start_date1.' to '.$end_date1;
         
        $startcheck=substr($from1, 0, -8);
    if(isset($_REQUEST['deviceID']) && $_REQUEST['deviceID']=='All'){
        $querydevice= "SELECT distinct(d.deviceID),d.deviceName,d.modBusID,d.gatewayID,g.gatewayName FROM device d join gateway g join deviceData dd where d.gatewayID=g.gatewayID and d.modBusID=dd.deviceID and d.isLive=1 and g.siteID=$siteID";
        
        $command = $connection->createCommand($querydevice);  
        $devicedata = $command->queryAll();  
    }else{
    $querydevice="select deviceName,modBusID,gatewayID from device where modBusID=$deviceID and gatewayID=$gatewayID";
    $command = $connection->createCommand($querydevice);
    $devicedata = $command->queryAll(); 
    }
//print_r($devicedata);
//die();
$htmldata .='<html>
<head>
<link href="style.css" type="text/css" rel="stylesheet"/>
</head>
<body>
<div id="wrapper">
<div class="top-lineChart">
                                <h4><span>Bill Generated from </span>'.$dataFrom.'</h4>
                            </div>
<div id="html_div">';
for($i=0;$i<count($devicedata);$i++){
    
    $deviceName=$devicedata[$i]['deviceName']; 
    $deviceID=$devicedata[$i]['modBusID'];
            $gatewayID=$devicedata[$i]['gatewayID'];

                $querykwh= "select max(data) as maxdata,min(data) as mindata,max(data) - min(data) as datadiff from deviceData where deviceID=$deviceID and gatewayID=$gatewayID and  (mapMasterID=6 or mapMasterID=308 ) and timeStamp like '$startcheck%'"; 
                $command = $connection->createCommand($querykwh); 
                $reskwh = $command->queryAll();
                //echo'<BR>';
                $querykvah= "select max(data) as maxdata,min(data) as mindata,max(data) - min(data) as datadiff from deviceData where deviceID=$deviceID and gatewayID=$gatewayID and  (mapMasterID=7 or mapMasterID=309 ) and timeStamp like '$startcheck%'"; 
                $command = $connection->createCommand($querykvah); 
                $reskvah = $command->queryAll();

                            $htmldata .='<table>                            
                            <thead>
                            <tr><td><h4>'.$deviceName.'</h4></td></tr>
                                <tr role="row" style="background-color:powderblue;"><th class="sorting_disabled" rowspan="1" colspan="1" style="width: 200px;">Electricity Type</th><th class="sorting_disabled" rowspan="1" colspan="1" style="width: 400px;">Reading on '.$start_date1.'</th><th class="sorting_disabled" rowspan="1" colspan="1" style="width: 400px;">Reading on '.$end_date1.'</th><th class="sorting_disabled" rowspan="1" colspan="1" style="width: 120px;">Total Units</th><th class="sorting_disabled" rowspan="1" colspan="1" style="width: 273px;">Unit Price (₹)</th><th class="sorting_disabled" rowspan="1" colspan="1" style="width: 273px;">Total Cost (₹)</th></tr>
                            </thead>
                            <tbody> ';                              
                           if(count($reskwh) > 0 && count($reskvah)>0){ 
                            
                            $htmldata .='<tr role="row" class="odd">
                                    <td tabindex="0">KWH</td>
                                    <td>'.round($reskwh[0]['mindata'],2).'</td>
                                    <td>'.round($reskwh[0]['maxdata'],2).'</td>
                                    <td>'.round($reskwh[0]['maxdata']-$reskwh[0]['mindata'],2).'</td>
                                    <td>8.50</td>
                                    <td>'.round(($reskwh[0]['maxdata']-$reskwh[0]['mindata'])*8.50,2).'</td>                                    
                                </tr>
                                <tr role="row" class="odd">
                                <td tabindex="0">KVAH</td>
                                <td>'.round($reskvah[0]['mindata'],2).'</td>
                                    <td>'.round($reskvah[0]['maxdata'],2).'</td>
                                    <td>'.round($reskvah[0]['maxdata']-$reskvah[0]['mindata'],2).'</td>
                                    <td>8.50</td>
                                    <td>'.round(($reskvah[0]['maxdata']-$reskvah[0]['mindata'])*8.50,2).'</td>                                      
                                </tr>
                                <tr role="row" class="odd">
                                <td tabindex="0"></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="color:red;"><b>Total bill (KVAH):</b></td>
                                    <td style="color:red;"><b>'.round((($reskvah[0]['maxdata']-$reskvah[0]['mindata'])*8.50)+(($reskwh[0]['maxdata']-$reskwh[0]['mindata'])*8.50),2).'</b></td>                                     
                                </tr>';
                                }else{
                                    $htmldata .='<tr role="row" class="odd">
                                <td tabindex="0">No Records available.</td>
                                </tr>';
                                }
                                $htmldata .='</tbody>
                        </table>';
                            }

                            $htmldata .='</div>
                           
                            </div>
                            </body>
                            </html>';
                          
                  $pdf = new Pdf([
                      // set to use core fonts only
                      'mode' => Pdf::MODE_CORE, 
                      // A4 paper format
                      'format' => Pdf::FORMAT_A4, 
                      // portrait orientation
                      'orientation' => Pdf::ORIENT_PORTRAIT, 
                      // stream to browser inline
                      'destination' => Pdf::DEST_BROWSER, 
                      // your html content input
                      'content' => $htmldata,  
                      // format content from your own css file if needed or use the
                      // enhanced bootstrap css built by Krajee for mPDF formatting 
                      //'cssFile' => '@vendor/kartik-v/yii2-mpdf/assets/kv-mpdf-bootstrap.min.css',
                      'cssFile' => '',
                      // any css to be embedded if required
                      'cssInline' => '.kv-heading-1{font-size:18px}', 
                       // set mPDF properties on the fly
                      'options' => ['title' => 'Invoice'],
                       // call mPDF methods on the fly
                      'methods' => [ 
                          'SetHeader'=>['Invoice'], 
                          'SetFooter'=>['{PAGENO}'],
                      ]
                  ]); 
                  echo $pdf->render();
                  
    }
}
