<?php

namespace app\controllers;

use yii;
use app\models\DeviceMapMasterAdmin;
use app\models\DeviceMapMasterAdminSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\data\Pagination;
use yii\helpers\Html;
use yii\filters\auth\QueryParamAuth;
/**
 * DeviceMapMasterAdminController implements the CRUD actions for DeviceMapMasterAdmin model.
 */
class DeviceMapMasterAdminController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['GET'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all DeviceMapMasterAdmin models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $pagesize=50;
        $qparam= Yii::$app->request->queryParams;
       if(isset($qparam['page'])){
        $page=$qparam['page'];        
       }else{
        $page=1;
       }
       $start = ($page - 1) * $pagesize;
       //$start=$page*$pagesize;
       $end=$pagesize;

       if(isset($qparam['display'])){
        $display=$qparam['display'];
        if($display==1)
          $display=0;
        else if($display==0)
          $display=1;
        $id=$qparam['id'];
        //die();
        Yii::$app->db->createCommand()
        ->update('deviceMapMasterAdmin', ['deviceMapMastershowonDashboard' => $display], "deviceMapMasterAdminID=$id")
        ->execute();
       }

       if(isset($qparam['pull'])){
        $pull=$qparam['pull'];
        if($pull==1)
          $pull=0;
        else if($pull==0)
          $pull=1;
        $id=$qparam['id'];
        //die();
        Yii::$app->db->createCommand()
        ->update('deviceMapMasterAdmin', ['deviceMapMasterPullData' => $pull], "deviceMapMasterAdminID=$id")
        ->execute();

        $query1= "update gateway set updateConfigure=1";        
            $connection = Yii::$app->getDb();
            $command1 = $connection->createCommand($query1);
            $dataconfig = $command1->queryAll();  
            
       }

       if(isset($qparam['deviceMasterID'])){
        $deviceMasterID=$qparam['deviceMasterID'];
        $condition='AND dmma.deviceMasterID= '.$deviceMasterID. ' order by dmma.deviceMapMasterPort asc';
       }else{
        $condition=' order by dmma.deviceMapMasterPort asc';
       }

       $queryall= "SELECT dm.deviceCompany,dm.deviceModel,mm.mapMasterCode,mm.mapMasterName,dmma.mapMasterID,dmma.deviceMapMasterPort,dmma.deviceMapMasterMF,dmma.deviceMapMasterAdminID,dmma.deviceMapMasterShowOnDashboard,dmma.deviceMapMasterPullData,dmma.deviceMapMasterReadSize,mdt.mapDataTypeName,mdt.mapDataTypeSymbol from deviceMapMasterAdmin dmma, deviceMaster dm , mapMaster mm,mapDataType mdt where dmma.mapMasterID=mm.mapMasterID and dmma.deviceMasterID=dm.deviceMasterID and dmma.mapDataTypeID=mdt.mapDataTypeID $condition ";
        $connection = Yii::$app->getDb();
        $command1 = $connection->createCommand($queryall);        
        $dataProviderall = $command1->queryAll();


       $query= "SELECT dm.deviceCompany,dm.deviceModel,mm.mapMasterCode,mm.mapMasterName,dmma.mapMasterID,dmma.deviceMapMasterPort,dmma.deviceMapMasterMF,dmma.deviceMapMasterAdminID,dmma.deviceMapMasterShowOnDashboard,dmma.deviceMapMasterPullData,dmma.deviceMapMasterReadSize,mdt.mapDataTypeName,mdt.mapDataTypeSymbol from deviceMapMasterAdmin dmma, deviceMaster dm , mapMaster mm,mapDataType mdt where dmma.mapMasterID=mm.mapMasterID and dmma.deviceMasterID=dm.deviceMasterID and dmma.mapDataTypeID=mdt.mapDataTypeID $condition  limit $start,$end";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);
        $dataProvider = $command->queryAll();  
        
        $command = $connection->createCommand("SELECT deviceMasterID, concat(deviceModel,' ', deviceCompany) as deviceMeter from deviceMaster");
        $datadeviceMaster = $command->queryAll();


        return $this->render('index', [
           'dataProviderall' => $dataProviderall,
            'dataProvider' => $dataProvider,
            'datadeviceMaster' => $datadeviceMaster
        ]);
    }

    /**
     * Displays a single DeviceMapMasterAdmin model.
     * @param int $deviceMapMasterAdminID Device Map Master Admin ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($deviceMapMasterAdminID)
    {
        $query= "SELECT dm.deviceCompany,dm.deviceModel,mm.mapMasterCode,mm.mapMasterName,dmma.mapMasterID,dmma.deviceMapMasterPort,dmma.deviceMapMasterMF,dmma.deviceMapMasterAdminID,dmma.deviceMapMasterShowOnDashboard,dmma.deviceMapMasterPullData,dmma.deviceMapMasterReadSize,mdt.mapDataTypeName,mdt.mapDataTypeSymbol,gd.gaugeDialSettingName from deviceMapMasterAdmin dmma, deviceMaster dm , mapMaster mm,mapDataType mdt,gaugeDialSetting gd where dmma.mapMasterID=mm.mapMasterID and dmma.deviceMasterID=dm.deviceMasterID and dmma.mapDataTypeID=mdt.mapDataTypeID  and  dmma.gaugeDialSettingID=gd.gaugeDialSettingID and dmma.deviceMapMasterAdminID=$deviceMapMasterAdminID";
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);
        $dataProvider = $command->queryAll();
        

        return $this->render('view', [
            'model' => $dataProvider,
        ]);
    }

    /**
     * Creates a new DeviceMapMasterAdmin model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new DeviceMapMasterAdmin();

        

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'deviceMapMasterAdminID' => $model->deviceMapMasterAdminID]);
            }
        } else {
            $query= "SELECT dm.deviceCompany,dm.deviceModel,mm.mapMasterCode,mm.mapMasterName,dmma.deviceMasterID,dmma.mapDataTypeID,dmma.mapMasterID,dmma.deviceMapMasterPort,dmma.deviceMapMasterMF,dmma.deviceMapMasterAdminID,dmma.deviceMapMasterShowOnDashboard,dmma.deviceMapMasterPullData,dmma.deviceMapMasterReadSize,dmma.gaugeDialSettingID,mdt.mapDataTypeName,mdt.mapDataTypeSymbol from deviceMapMasterAdmin dmma, deviceMaster dm , mapMaster mm,mapDataType mdt where dmma.mapMasterID=mm.mapMasterID and dmma.deviceMasterID=dm.deviceMasterID and dmma.mapDataTypeID=mdt.mapDataTypeID";
            $connection = Yii::$app->getDb();
            $command = $connection->createCommand($query);        
           
            $dataProvider = $command->queryAll();       
       
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand("SELECT mapMasterID, mapMasterName from mapMaster");
        $datamapMaster = $command->queryAll();

        $command = $connection->createCommand("SELECT deviceMasterID, concat(deviceModel,' ', deviceCompany) as deviceMeter from deviceMaster");
        $datadeviceMaster = $command->queryAll();

        $connection = Yii::$app->getDb();
        $command = $connection->createCommand("SELECT mapDataTypeID, mapDataTypeName from mapDataType");
        $datamapDataType = $command->queryAll();

        $connection = Yii::$app->getDb();
        $command = $connection->createCommand("SELECT gaugeDialSettingID, gaugeDialSettingName from gaugeDialSetting");
        $datagaugeDialSetting = $command->queryAll();

            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
            'datamapMaster'=>$datamapMaster,
            'datadeviceMaster'=>$datadeviceMaster,
            'datamapDataType'=>$datamapDataType,
            'datagaugeDialSetting'=>$datagaugeDialSetting,
            'dataProvider'=>$dataProvider
            
        ]);
    }

    /**
     * Updates an existing DeviceMapMasterAdmin model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $deviceMapMasterAdminID Device Map Master Admin ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($deviceMapMasterAdminID)
    {
        $model = $this->findModel($deviceMapMasterAdminID);
        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
           // print_r($this->request->post());
           // die();
           
            return $this->redirect(['view', 'deviceMapMasterAdminID' => $model->deviceMapMasterAdminID]);
        }else{

        $query= "SELECT dm.deviceCompany,dm.deviceModel,mm.mapMasterCode,mm.mapMasterName,dmma.mapMasterID,dmma.deviceMasterID,dmma.mapDataTypeID,dmma.deviceMapMasterPort,dmma.deviceMapMasterMF,dmma.deviceMapMasterAdminID,dmma.deviceMapMasterShowOnDashboard,dmma.deviceMapMasterPullData,dmma.deviceMapMasterReadSize,dmma.gaugeDialSettingID,mdt.mapDataTypeName,mdt.mapDataTypeSymbol from deviceMapMasterAdmin dmma, deviceMaster dm , mapMaster mm,mapDataType mdt where dmma.mapMasterID=mm.mapMasterID and dmma.deviceMasterID=dm.deviceMasterID and dmma.mapDataTypeID=mdt.mapDataTypeID and dmma.deviceMapMasterAdminID=$deviceMapMasterAdminID";
        //die();
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);
        $dataProvider = $command->queryAll();


        
        $command = $connection->createCommand("SELECT mapMasterID, mapMasterName from mapMaster");
        $datamapMaster = $command->queryAll();

        $command = $connection->createCommand("SELECT deviceMasterID, concat(deviceModel,' ', deviceCompany) as deviceMeter from deviceMaster");
        $datadeviceMaster = $command->queryAll();

        
        $command = $connection->createCommand("SELECT mapDataTypeID, mapDataTypeName from mapDataType");
        $datamapDataType = $command->queryAll();

        $connection = Yii::$app->getDb();
        $command = $connection->createCommand("SELECT gaugeDialSettingID, gaugeDialSettingName from gaugeDialSetting");
        $datagaugeDialSetting = $command->queryAll();


        return $this->render('update', [
            'model' => $model,
            'datamapMaster'=>$datamapMaster,
            'datadeviceMaster'=>$datadeviceMaster,
            'datamapDataType'=>$datamapDataType,
            'datagaugeDialSetting'=>$datagaugeDialSetting,
            'dataProvider'=>$dataProvider
        ]);
    }
    }

    /**
     * Deletes an existing DeviceMapMasterAdmin model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $deviceMapMasterAdminID Device Map Master Admin ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($deviceMapMasterAdminID)
    {
        $this->findModel($deviceMapMasterAdminID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the DeviceMapMasterAdmin model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $deviceMapMasterAdminID Device Map Master Admin ID
     * @return DeviceMapMasterAdmin the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($deviceMapMasterAdminID)
    {
        if (($model = DeviceMapMasterAdmin::findOne(['deviceMapMasterAdminID' => $deviceMapMasterAdminID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
