<?php

namespace app\controllers;

use yii;
use app\models\Device;
use app\models\DeviceSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * DeviceController implements the CRUD actions for Device model.
 */
class DeviceController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['GET'],
                    ],
                ],
            ]
        );
    }


    /**
     * Lists all Device models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $connection = Yii::$app->getDb();
        $message='';
        if ($this->request->isPost) {
           $deviceID= $_REQUEST['deviceID'];
           //print_r($_REQUEST['grp']);
           //die();
           $x = Yii::$app->db->createCommand("DELETE from deviceGroup where deviceID=$deviceID")->execute();
           foreach($_REQUEST['grp'] as $grpdata){
            $groupID=$grpdata;
            $command = $connection->createCommand("SELECT * from deviceGroup where deviceID=$deviceID and groupID= $groupID");
            $querycheck = $command->queryAll();
            if(count($querycheck) == 0){
            $queryinsert="INSERT INTO deviceGroup SET deviceID=$deviceID,groupID= $groupID";
            $command = $connection->createCommand($queryinsert);
            $command->execute();
            $message='success';
            }
           }
            //die();
        }
        /*$query1= "select slaveID from qtaConfig where configID=1";        
        $connection = Yii::$app->getDb();
        $command1 = $connection->createCommand($query1);
        $dataconfig = $command1->queryAll();    */     
        
        $query= "SELECT d.* ,g.gatewayName,dm.deviceModel from device as d join gateway as g join deviceMaster as dm on d.gatewayID=g.gatewayID and d.deviceMasterID=dm.deviceMasterID";
        //$query= "SELECT d.* ,g.gatewayName,dm.deviceModel from device as d join gateway as g join deviceMaster as dm join qtaConfig as qc on d.gatewayID=g.gatewayID group by deviceName";
        $command = $connection->createCommand($query);
        $dataProvider = $command->queryAll();  

        $command = $connection->createCommand("SELECT * from groups");
        $datagroup = $command->queryAll();
        $ddg=array();
        if(isset($_REQUEST['deviceID'])){
            $did=$_REQUEST['deviceID'];
        $command = $connection->createCommand("SELECT groupID from deviceGroup where deviceID=$did");
        $datadevicegroup = $command->queryAll();
        foreach($datadevicegroup as $dgdata){
            $ddg[]=$dgdata['groupID'];
        }
        }else{
            $ddg=[]; 
        }
        //die();
        return $this->render('index', [
            //'dataconfig' => $dataconfig,
            'dataProvider' => $dataProvider,
            'datagroup'=>$datagroup,
            'message'=>$message,
            'datadevicegroup'=>$ddg
        ]);
    }

    /**
     * Displays a single Device model.
     * @param int $deviceID Device ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($deviceID)
    {
        return $this->render('view', [
            'model' => $this->findModel($deviceID),
        ]);
    }

    /**
     * Creates a new Device model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Device();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {

                $connection = Yii::$app->getDb();
        $command = $connection->createCommand("SELECT gatewayID from device where deviceID=$model->deviceID");
        $datagatewayid = $command->queryAll();

        $gid=$datagatewayid[0]['gatewayID'];

        $connection = Yii::$app->getDb();
    $command = $connection->createCommand("UPDATE gateway SET updateConfigure=1 WHERE gatewayID=$gid");
    $command->execute();

                return $this->redirect(['view', 'deviceID' => $model->deviceID]);
            }
         }else{

            $query= "SELECT d.* ,g.gatewayName,dm.deviceModel from device as d join gateway as g join deviceMaster as dm on d.gatewayID=g.gatewayID and d.deviceMasterID=dm.deviceMasterID ";
            //die();
            $connection = Yii::$app->getDb();
            $command = $connection->createCommand($query);
            $dataProvider = $command->queryAll();
    
    
            $connection = Yii::$app->getDb();
            $command = $connection->createCommand("SELECT gatewayID, gatewayName from gateway where isLive=1");
           
            $datagateway = $command->queryAll();
            //echo'<pre>';
    //print_r($datagateway);
    //die();
            $command = $connection->createCommand("SELECT deviceMasterID, concat(deviceModel,' ', deviceCompany) as deviceMeter from deviceMaster");
            $datadeviceMaster = $command->queryAll();
    
            $command = $connection->createCommand("SELECT deviceID,deviceName from device");
            $datadevice = $command->queryAll();
    
            return $this->render('create', [
                'model' => $model,
                'datagateway'=>$datagateway,
                'datadeviceMaster'=>$datadeviceMaster,
                'datadevice'=>$datadevice,
                'dataProvider'=>$dataProvider
            ]);
        }
    }

    /**
     * Updates an existing Device model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $deviceID Device ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($deviceID)
    {
        $model = $this->findModel($deviceID);
        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
           // print_r($this->request->post());
           // die();
           $connection = Yii::$app->getDb();
        $command = $connection->createCommand("SELECT gatewayID from device where deviceID=$deviceID");
        $datagatewayid = $command->queryAll();
$gid=$datagatewayid[0]['gatewayID'];

        $connection = Yii::$app->getDb();
    $command = $connection->createCommand("UPDATE gateway SET updateConfigure=1 WHERE gatewayID=$gid");
    $command->execute();
            return $this->redirect(['view', 'deviceID' => $model->deviceID]);
        }else{

        $query= "SELECT d.* ,g.gatewayName,dm.deviceModel from device as d join gateway as g join deviceMaster as dm on d.gatewayID=g.gatewayID and d.deviceMasterID=dm.deviceMasterID where d.deviceID=$deviceID";
        //die();
        $connection = Yii::$app->getDb();
        $command = $connection->createCommand($query);
        $dataProvider = $command->queryAll();


        $connection = Yii::$app->getDb();
        $command = $connection->createCommand("SELECT gatewayID, gatewayName from gateway where isLive=1");
        $datagateway = $command->queryAll();
        

        $command = $connection->createCommand("SELECT deviceMasterID, concat(deviceModel,' ', deviceCompany) as deviceMeter from deviceMaster");
        $datadeviceMaster = $command->queryAll();
        
        $command = $connection->createCommand("SELECT deviceID,deviceName from device");
        $datadevice = $command->queryAll();

        

        return $this->render('create', [
            'model' => $model,
            'datagateway'=>$datagateway,
            'datadeviceMaster'=>$datadeviceMaster,
            'datadevice'=>$datadevice,
            'dataProvider'=>$dataProvider
        ]);    }
    }

    /**
     * Deletes an existing Device model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $deviceID Device ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($deviceID)
    {
        $this->findModel($deviceID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Device model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $deviceID Device ID
     * @return Device the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($deviceID)
    {
        if (($model = Device::findOne(['deviceID' => $deviceID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
