<?php

namespace app\controllers;

use yii;
use app\models\AutoReports;
use app\models\AutoReportsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Exception;
use SimpleExcel\SimpleExcel;
/**
 * AutoReportsController implements the CRUD actions for AutoReports model.
 */
class AutoReportsController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all AutoReports models.
     *
     * @return string
     */
    public function actionIndex()
    {
        //$searchModel = new AutoReportsSearch();
        //$dataProvider = $searchModel->search($this->request->queryParams);

        $query1= "select * from autoReports";        
        $connection = Yii::$app->getDb();
        $command1 = $connection->createCommand($query1);
        $dataProvider = $command1->queryAll();         


        return $this->render('index', [
            //'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single AutoReports model.
     * @param int $autoReportID Auto Report ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($autoReportID)
    {
        return $this->render('view', [
            'model' => $this->findModel($autoReportID),
        ]);
    }

    /**
     * Creates a new AutoReports model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new AutoReports();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'autoReportID' => $model->autoReportID]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing AutoReports model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $autoReportID Auto Report ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($autoReportID)
    {
        $model = $this->findModel($autoReportID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'autoReportID' => $model->autoReportID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing AutoReports model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $autoReportID Auto Report ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($autoReportID)
    {
        $this->findModel($autoReportID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the AutoReports model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $autoReportID Auto Report ID
     * @return AutoReports the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($autoReportID)
    {
        if (($model = AutoReports::findOne(['autoReportID' => $autoReportID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }

    public function actionCsv() {
        
       // require_once('/var/www/html/api/vendor/faisalman/simple-excel-php/src/SimpleExcel/SimpleExcel.php');
        try {
            $excel = new SimpleExcel('csv');                    // instantiate new object (will automatically construct the parser & writer type as XML)
            
            $query1= "select * from autoReports";        
            $connection = Yii::$app->getDb();
            $command1 = $connection->createCommand($query1);
            $dataProvider = $command1->queryAll(); 

            $result=array();
            $arr="";

            $result[] =array('<>Report Type',  'Send at','Report Emails','isLive');
            for($i=0;$i<count($dataProvider);$i++){
                        $autoReportName=$dataProvider[$i]['autoReportName'];
                        $autoReportTime=$dataProvider[$i]['autoReportTime'];
                        $autoReportEmails=$dataProvider[$i]['autoReportEmails'];
                        $isLive=$dataProvider[$i]['isLive'];
                        $result[] =array($autoReportName,$autoReportTime,$autoReportEmails,$isLive );
                        
            }
                       
            $excel->writer->setData($result); 
            // add some data to the writer
              $excel->writer->saveFile('mailreport.csv');   
              $response["error"] = 0;
                  $response["successful"] = 1; 
                  $response["message"] = "Exel generated successfully";                       
                  //$response["deviceData"] = $userdata;
                 return $response; 
            
                }
                catch(Exception $e) {
                //echo 'Message: ' .$e->getMessage();
                $response["error"] = 1;
                  $response["successful"] = 0; 
                  $response["message"] = $e->getMessage();                     
                  return $response; 
            }   
    }
}
