<?php

namespace app\controllers;

use yii;
use app\models\Alert;
use app\models\AlertSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

use SimpleExcel\SimpleExcel;
/**
 * AlertController implements the CRUD actions for Alert model.
 */
class AlertController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Alert models.
     *
     * @return string
     */
    public function actionIndex()
    {
       $qparam= Yii::$app->request->queryParams;
       if(isset($qparam['id']))
        $AlertTypeID=$qparam['id'];
        else
        $AlertTypeID=1;
       // print_r($AlertTypeID);
//die();
        //$searchModel = new AlertSearch();
       // $dataProvider = $searchModel->search($this->request->queryParams);
       $query= "select * from AlertType where IsVisible=1";
       $connection = Yii::$app->getDb();
       $command = $connection->createCommand($query); 
       $dataAlertsType = $command->queryAll();

       $command1 = $connection->createCommand("select * from Alert where AlertTypeID=$AlertTypeID order by AlertDateTime desc limit 0,1000");        
      
       $dataAlerts = $command1->queryAll();


        return $this->render('index', [
            'dataAlerts' => $dataAlerts,
            'dataAlertsType' => $dataAlertsType,
        ]);
    }

    /**
     * Displays a single Alert model.
     * @param int $AlertID Alert ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($AlertID)
    {
        return $this->render('view', [
            'model' => $this->findModel($AlertID),
        ]);
    }

    /**
     * Creates a new Alert model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Alert();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'AlertID' => $model->AlertID]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Alert model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $AlertID Alert ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($AlertID)
    {
        $model = $this->findModel($AlertID);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'AlertID' => $model->AlertID]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Alert model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $AlertID Alert ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($AlertID)
    {
        $this->findModel($AlertID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Alert model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $AlertID Alert ID
     * @return Alert the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($AlertID)
    {
        if (($model = Alert::findOne(['AlertID' => $AlertID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }


    public function actionCsv() {
        
        // require_once('/var/www/html/api/vendor/faisalman/simple-excel-php/src/SimpleExcel/SimpleExcel.php');
         //try {
             $excel = new SimpleExcel('csv');                    // instantiate new object (will automatically construct the parser & writer type as XML)
             
             //$qparam= Yii::$app->request->queryParams;
             if(isset($_REQUEST['id']))
              $AlertTypeID=$_REQUEST['id'];
              else
              $AlertTypeID=1;
              //echo"select * from Alert where AlertTypeID=$AlertTypeID";
      
              $result1=array();
             $connection = Yii::$app->getDb();
             $command = $connection->createCommand("select * from Alert where AlertTypeID=$AlertTypeID order by AlertDateTime desc limit 0,1000"); 
             $alertdata = $command->queryAll();
            
             $result1[] =array('Alert Date Time','Alert Message');
             for($i=0;$i<count($alertdata);$i++){
                $newdate = date("l, d M Y h:i:s", strtotime($alertdata[$i]['AlertDateTime']));
                $AlertMessage=$alertdata[$i]['AlertMessage'];

                         $result1[] =array($newdate,$AlertMessage);
                         
             }
             //print_r($result1);
             //die();      
             $excel->writer->setData($result1); 
             // add some data to the writer
               $excel->writer->saveFile('alerts.csv');   
               $response["error"] = 0;
                   $response["successful"] = 1; 
                   $response["message"] = "Exel generated successfully";                       
                   //$response["deviceData"] = $userdata;
                  return $response; 
             
                  
     }
}
