<?php

namespace app\controllers;

use yii;
use app\models\Admin;
use app\models\AdminSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * AdminController implements the CRUD actions for Admin model.
 */
class AdminController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['GET'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Admin models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new AdminSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Admin model.
     * @param int $AdminID Admin ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($AdminID)
    {
        return $this->render('view', [
            'model' => $this->findModel($AdminID),
        ]);
    }

    /**
     * Creates a new Admin model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $connection = Yii::$app->getDb();
        $model = new Admin();

        if ($this->request->isPost) {
            $postdata=$this->request->post();
            
            $reportsdata=$postdata['report'];
            $post = Yii::$app->request->post();
            //print_r($postdata);
//die();
    if ($model->load($post)) {
        $AdminPassword = sha1($model->AdminPassword);
                
            if ($model->load($this->request->post()) && $model->save()) {

                array_push($reportsdata,"2","3");
                foreach($reportsdata as $mdata){
                    $adminid=$model->AdminID;
                    //echo "insert into adminNavRel set adminID= $adminid navID=$mdata";
                    $command = $connection->createCommand("insert into adminNavRel set adminID= $adminid, navID=$mdata")->execute();
                   // $resupdate = $command->execute();
                }
                $command1 = $connection->createCommand("update Admin set AdminPassword ='$AdminPassword' where adminID= $adminid")->execute();
                //die();
                return $this->redirect(['view', 'AdminID' => $model->AdminID]);
            }
    }
            
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Admin model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $AdminID Admin ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($AdminID)
    {
        $connection = Yii::$app->getDb();
        $model = $this->findModel($AdminID);
        if ($this->request->isPost) {
            $postdata=$this->request->post();
            $reportsdata=$postdata['report'];
            array_push($reportsdata,"2","3");
            //print_r($reportsdata);
            //die();
            $command = $connection->createCommand("delete from adminNavRel where adminID= $AdminID")->execute();
            foreach($reportsdata as $mdata){
                //$adminid=$model->AdminID;
                //echo "insert into adminNavRel set adminID= $AdminID, navID=$mdata";
                $command = $connection->createCommand("insert into adminNavRel set adminID= $AdminID, navID=$mdata")->execute();
               // $resupdate = $command->execute();
            }
//die();
        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            if(strlen($model->AdminPassword) < 40){
            $AdminPassword = sha1($model->AdminPassword);
            $command1 = $connection->createCommand("update Admin set AdminPassword ='$AdminPassword' where adminID= $AdminID")->execute();
            }
            return $this->redirect(['view', 'AdminID' => $model->AdminID]);
        }
        }
    

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Admin model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $AdminID Admin ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($AdminID)
    {
        $this->findModel($AdminID)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Admin model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $AdminID Admin ID
     * @return Admin the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($AdminID)
    {
        if (($model = Admin::findOne(['AdminID' => $AdminID])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
