/*
 Highmaps JS v9.3.3 (2022-02-01)

 Highmaps as a plugin for Highcharts or Highcharts Stock.

 (c) 2011-2021 Torstein Honsi

 License: www.highcharts.com/license
*/
'use strict';(function(c){"object"===typeof module&&module.exports?(c["default"]=c,module.exports=c):"function"===typeof define&&define.amd?define("highcharts/modules/map",["highcharts"],function(y){c(y);c.Highcharts=y;return c}):c("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(c){function y(c,f,p,r){c.hasOwnProperty(f)||(c[f]=r.apply(null,p))}c=c?c._modules:{};y(c,"Core/Axis/Color/ColorAxisComposition.js",[c["Core/Color/Color.js"],c["Core/Utilities.js"]],function(c,f){var p=c.parse,
r=f.addEvent,n=f.extend,u=f.merge,e=f.pick,b=f.splat,v;(function(m){function k(){var h=this,l=this.options;this.colorAxis=[];l.colorAxis&&(l.colorAxis=b(l.colorAxis),l.colorAxis.forEach(function(l,d){l.index=d;new B(h,l)}))}function a(h){var l=this,d=function(a){a=h.allItems.indexOf(a);-1!==a&&(l.destroyItem(h.allItems[a]),h.allItems.splice(a,1))},a=[],g,w;(this.chart.colorAxis||[]).forEach(function(h){(g=h.options)&&g.showInLegend&&(g.dataClasses&&g.visible?a=a.concat(h.getDataClassLegendSymbols()):
g.visible&&a.push(h),h.series.forEach(function(h){if(!h.options.showInLegend||g.dataClasses)"point"===h.options.legendType?h.points.forEach(function(h){d(h)}):d(h)}))});for(w=a.length;w--;)h.allItems.unshift(a[w])}function d(h){h.visible&&h.item.legendColor&&h.item.legendSymbol.attr({fill:h.item.legendColor})}function g(){var h=this.chart.colorAxis;h&&h.forEach(function(h,l,a){h.update({},a)})}function t(){(this.chart.colorAxis&&this.chart.colorAxis.length||this.colorAttribs)&&this.translateColors()}
function x(){var h=this.axisTypes;h?-1===h.indexOf("colorAxis")&&h.push("colorAxis"):this.axisTypes=["colorAxis"]}function v(h){var l=this,a=h?"show":"hide";l.visible=l.options.visible=!!h;["graphic","dataLabel"].forEach(function(h){if(l[h])l[h][a]()});this.series.buildKDTree()}function q(){var h=this,l=this.options.nullColor,a=this.colorAxis,d=this.colorKey;(this.data.length?this.data:this.points).forEach(function(g){var w=g.getNestedProperty(d);(w=g.options.color||(g.isNull||null===g.value?l:a&&
"undefined"!==typeof w?a.toColor(w,g):g.color||h.color))&&g.color!==w&&(g.color=w,"point"===h.options.legendType&&g.legendItem&&h.chart.legend.colorizeItem(g,g.visible))})}function w(h){var l=h.prototype.createAxis;h.prototype.createAxis=function(h,a){if("colorAxis"!==h)return l.apply(this,arguments);var d=new B(this,u(a.axis,{index:this[h].length,isX:!1}));this.isDirtyLegend=!0;this.axes.forEach(function(h){h.series=[]});this.series.forEach(function(h){h.bindAxes();h.isDirtyData=!0});e(a.redraw,
!0)&&this.redraw(a.animation);return d}}function A(){this.elem.attr("fill",p(this.start).tweenTo(p(this.end),this.pos),void 0,!0)}function h(){this.elem.attr("stroke",p(this.start).tweenTo(p(this.end),this.pos),void 0,!0)}var l=[],B;m.compose=function(b,e,m,u,c){B||(B=b);-1===l.indexOf(e)&&(l.push(e),b=e.prototype,b.collectionsWithUpdate.push("colorAxis"),b.collectionsWithInit.colorAxis=[b.addColorAxis],r(e,"afterGetAxes",k),w(e));-1===l.indexOf(m)&&(l.push(m),e=m.prototype,e.fillSetter=A,e.strokeSetter=
h);-1===l.indexOf(u)&&(l.push(u),r(u,"afterGetAllItems",a),r(u,"afterColorizeItem",d),r(u,"afterUpdate",g));-1===l.indexOf(c)&&(l.push(c),n(c.prototype,{optionalAxis:"colorAxis",translateColors:q}),n(c.prototype.pointClass.prototype,{setVisible:v}),r(c,"afterTranslate",t),r(c,"bindAxes",x))};m.pointSetVisible=v})(v||(v={}));return v});y(c,"Core/Axis/Color/ColorAxisDefaults.js",[],function(){return{lineWidth:0,minPadding:0,maxPadding:0,gridLineWidth:1,tickPixelInterval:72,startOnTick:!0,endOnTick:!0,
offset:0,marker:{animation:{duration:50},width:.01,color:"#999999"},labels:{overflow:"justify",rotation:0},minColor:"#e6ebf5",maxColor:"#003399",tickLength:5,showInLegend:!0}});y(c,"Core/Axis/Color/ColorAxis.js",[c["Core/Axis/Axis.js"],c["Core/Color/Color.js"],c["Core/Axis/Color/ColorAxisComposition.js"],c["Core/Axis/Color/ColorAxisDefaults.js"],c["Core/Globals.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,p,r,n,u,e,b){var v=this&&this.__extends||
function(){var a=function(d,g){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,h){a.__proto__=h}||function(a,h){for(var l in h)h.hasOwnProperty(l)&&(a[l]=h[l])};return a(d,g)};return function(d,g){function b(){this.constructor=d}a(d,g);d.prototype=null===g?Object.create(g):(b.prototype=g.prototype,new b)}}(),m=f.parse,k=n.noop,a=e.series,d=b.extend,g=b.isNumber,t=b.merge,x=b.pick;f=function(b){function q(a,d){var h=b.call(this,a,d)||this;h.beforePadding=!1;h.chart=void 0;h.coll=
"colorAxis";h.dataClasses=void 0;h.legendItem=void 0;h.legendItems=void 0;h.name="";h.options=void 0;h.stops=void 0;h.visible=!0;h.init(a,d);return h}v(q,b);q.compose=function(a,d,h,l){p.compose(q,a,d,h,l)};q.prototype.init=function(a,d){var h=a.options.legend||{},l=d.layout?"vertical"!==d.layout:"vertical"!==h.layout,g=d.visible;h=t(q.defaultColorAxisOptions,d,{showEmpty:!1,title:null,visible:h.enabled&&!1!==g});this.coll="colorAxis";this.side=d.side||l?2:1;this.reversed=d.reversed||!l;this.opposite=
!l;b.prototype.init.call(this,a,h);this.userOptions.visible=g;d.dataClasses&&this.initDataClasses(d);this.initStops();this.horiz=l;this.zoomEnabled=!1};q.prototype.initDataClasses=function(a){var d=this.chart,h=this.options,l=a.dataClasses.length,g,b=0,w=d.options.chart.colorCount;this.dataClasses=g=[];this.legendItems=[];(a.dataClasses||[]).forEach(function(a,q){a=t(a);g.push(a);if(d.styledMode||!a.color)"category"===h.dataClassColor?(d.styledMode||(q=d.options.colors,w=q.length,a.color=q[b]),a.colorIndex=
b,b++,b===w&&(b=0)):a.color=m(h.minColor).tweenTo(m(h.maxColor),2>l?.5:q/(l-1))})};q.prototype.hasData=function(){return!!(this.tickPositions||[]).length};q.prototype.setTickPositions=function(){if(!this.dataClasses)return b.prototype.setTickPositions.call(this)};q.prototype.initStops=function(){this.stops=this.options.stops||[[0,this.options.minColor],[1,this.options.maxColor]];this.stops.forEach(function(a){a.color=m(a[1])})};q.prototype.setOptions=function(a){b.prototype.setOptions.call(this,a);
this.options.crosshair=this.options.marker};q.prototype.setAxisSize=function(){var a=this.legendSymbol,d=this.chart,h=d.options.legend||{},l,g;a?(this.left=h=a.attr("x"),this.top=l=a.attr("y"),this.width=g=a.attr("width"),this.height=a=a.attr("height"),this.right=d.chartWidth-h-g,this.bottom=d.chartHeight-l-a,this.len=this.horiz?g:a,this.pos=this.horiz?h:l):this.len=(this.horiz?h.symbolWidth:h.symbolHeight)||q.defaultLegendLength};q.prototype.normalizedValue=function(a){this.logarithmic&&(a=this.logarithmic.log2lin(a));
return 1-(this.max-a)/(this.max-this.min||1)};q.prototype.toColor=function(a,d){var h=this.dataClasses,l=this.stops,g;if(h)for(g=h.length;g--;){var b=h[g];var w=b.from;l=b.to;if(("undefined"===typeof w||a>=w)&&("undefined"===typeof l||a<=l)){var t=b.color;d&&(d.dataClass=g,d.colorIndex=b.colorIndex);break}}else{a=this.normalizedValue(a);for(g=l.length;g--&&!(a>l[g][0]););w=l[g]||l[g+1];l=l[g+1]||w;a=1-(l[0]-a)/(l[0]-w[0]||1);t=w.color.tweenTo(l.color,a)}return t};q.prototype.getOffset=function(){var a=
this.legendGroup,d=this.chart.axisOffset[this.side];a&&(this.axisParent=a,b.prototype.getOffset.call(this),this.added||(this.added=!0,this.labelLeft=0,this.labelRight=this.width),this.chart.axisOffset[this.side]=d)};q.prototype.setLegendColor=function(){var a=this.reversed,d=a?1:0;a=a?0:1;d=this.horiz?[d,0,a,0]:[0,a,0,d];this.legendColor={linearGradient:{x1:d[0],y1:d[1],x2:d[2],y2:d[3]},stops:this.stops}};q.prototype.drawLegendSymbol=function(a,d){var h=a.padding,g=a.options,b=this.horiz,t=x(g.symbolWidth,
b?q.defaultLegendLength:12),w=x(g.symbolHeight,b?12:q.defaultLegendLength),k=x(g.labelPadding,b?16:30);g=x(g.itemDistance,10);this.setLegendColor();d.legendSymbol=this.chart.renderer.rect(0,a.baseline-11,t,w).attr({zIndex:1}).add(d.legendGroup);this.legendItemWidth=t+h+(b?g:k);this.legendItemHeight=w+h+(b?k:0)};q.prototype.setState=function(a){this.series.forEach(function(d){d.setState(a)})};q.prototype.setVisible=function(){};q.prototype.getSeriesExtremes=function(){var d=this.series,g=d.length,
h;this.dataMin=Infinity;for(this.dataMax=-Infinity;g--;){var l=d[g];var b=l.colorKey=x(l.options.colorKey,l.colorKey,l.pointValKey,l.zoneAxis,"y");var t=l.pointArrayMap;var q=l[b+"Min"]&&l[b+"Max"];if(l[b+"Data"])var k=l[b+"Data"];else if(t){k=[];t=t.indexOf(b);var e=l.yData;if(0<=t&&e)for(h=0;h<e.length;h++)k.push(x(e[h][t],e[h]))}else k=l.yData;q?(l.minColorValue=l[b+"Min"],l.maxColorValue=l[b+"Max"]):(k=a.prototype.getExtremes.call(l,k),l.minColorValue=k.dataMin,l.maxColorValue=k.dataMax);"undefined"!==
typeof l.minColorValue&&(this.dataMin=Math.min(this.dataMin,l.minColorValue),this.dataMax=Math.max(this.dataMax,l.maxColorValue));q||a.prototype.applyExtremes.call(l)}};q.prototype.drawCrosshair=function(a,d){var h=d&&d.plotX,g=d&&d.plotY,t=this.pos,q=this.len;if(d){var k=this.toPixels(d.getNestedProperty(d.series.colorKey));k<t?k=t-2:k>t+q&&(k=t+q+2);d.plotX=k;d.plotY=this.len-k;b.prototype.drawCrosshair.call(this,a,d);d.plotX=h;d.plotY=g;this.cross&&!this.cross.addedToColorAxis&&this.legendGroup&&
(this.cross.addClass("highcharts-coloraxis-marker").add(this.legendGroup),this.cross.addedToColorAxis=!0,this.chart.styledMode||"object"!==typeof this.crosshair||this.cross.attr({fill:this.crosshair.color}))}};q.prototype.getPlotLinePath=function(a){var d=this.left,h=a.translatedValue,l=this.top;return g(h)?this.horiz?[["M",h-4,l-6],["L",h+4,l-6],["L",h,l],["Z"]]:[["M",d,h],["L",d-6,h+6],["L",d-6,h-6],["Z"]]:b.prototype.getPlotLinePath.call(this,a)};q.prototype.update=function(a,d){var h=this.chart.legend;
this.series.forEach(function(a){a.isDirtyData=!0});(a.dataClasses&&h.allItems||this.dataClasses)&&this.destroyItems();b.prototype.update.call(this,a,d);this.legendItem&&(this.setLegendColor(),h.colorizeItem(this,!0))};q.prototype.destroyItems=function(){var a=this.chart;this.legendItem?a.legend.destroyItem(this):this.legendItems&&this.legendItems.forEach(function(d){a.legend.destroyItem(d)});a.isDirtyLegend=!0};q.prototype.destroy=function(){this.chart.isDirtyLegend=!0;this.destroyItems();b.prototype.destroy.apply(this,
[].slice.call(arguments))};q.prototype.remove=function(a){this.destroyItems();b.prototype.remove.call(this,a)};q.prototype.getDataClassLegendSymbols=function(){var a=this,g=a.chart,h=a.legendItems,b=g.options.legend,t=b.valueDecimals,q=b.valueSuffix||"",e;h.length||a.dataClasses.forEach(function(b,l){var w=b.from,x=b.to,m=g.numberFormatter,v=!0;e="";"undefined"===typeof w?e="< ":"undefined"===typeof x&&(e="> ");"undefined"!==typeof w&&(e+=m(w,t)+q);"undefined"!==typeof w&&"undefined"!==typeof x&&
(e+=" - ");"undefined"!==typeof x&&(e+=m(x,t)+q);h.push(d({chart:g,name:e,options:{},drawLegendSymbol:u.drawRectangle,visible:!0,setState:k,isDataClass:!0,setVisible:function(){v=a.visible=!v;a.series.forEach(function(a){a.points.forEach(function(a){a.dataClass===l&&a.setVisible(v)})});g.legend.colorizeItem(this,v)}},b))});return h};q.defaultColorAxisOptions=r;q.defaultLegendLength=200;q.keepProps=["legendGroup","legendItemHeight","legendItemWidth","legendItem","legendSymbol"];return q}(c);Array.prototype.push.apply(c.keepProps,
f.keepProps);"";return f});y(c,"Maps/MapNavigationOptionsDefault.js",[c["Core/DefaultOptions.js"],c["Core/Utilities.js"]],function(c,f){f=f.extend;var p={buttonOptions:{alignTo:"plotBox",align:"left",verticalAlign:"top",x:0,width:18,height:18,padding:5,style:{fontSize:"15px",fontWeight:"bold"},theme:{"stroke-width":1,"text-align":"center"}},buttons:{zoomIn:{onclick:function(){this.mapZoom(.5)},text:"+",y:0},zoomOut:{onclick:function(){this.mapZoom(2)},text:"-",y:28}},mouseWheelSensitivity:1.1};f(c.defaultOptions.lang,
{zoomIn:"Zoom in",zoomOut:"Zoom out"});return c.defaultOptions.mapNavigation=p});y(c,"Maps/MapNavigation.js",[c["Core/Chart/Chart.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,f,p){function r(a){a&&(a.preventDefault&&a.preventDefault(),a.stopPropagation&&a.stopPropagation(),a.cancelBubble=!0)}function n(a){this.init(a)}var u=f.doc,e=p.addEvent,b=p.extend,v=p.isNumber,m=p.merge,k=p.objectEach,a=p.pick;n.prototype.init=function(a){this.chart=a;a.mapNavButtons=[]};n.prototype.update=function(d){var g=
this.chart,t=g.options.mapNavigation,x,v,q,w,c=function(a){this.handler.call(g,a);r(a)},h=g.mapNavButtons;d&&(t=g.options.mapNavigation=m(g.options.mapNavigation,d));for(;h.length;)h.pop().destroy();a(t.enableButtons,t.enabled)&&!g.renderer.forExport&&k(t.buttons,function(a,d){a=m(t.buttonOptions,a);!g.styledMode&&a.theme&&(x=a.theme,x.style=m(a.theme.style,a.style),q=(v=x.states)&&v.hover,w=v&&v.select,delete x.states);var l=g.renderer.button(a.text||"",0,0,c,x,q,w,void 0,"zoomIn"===d?"topbutton":
"bottombutton").addClass("highcharts-map-navigation highcharts-"+{zoomIn:"zoom-in",zoomOut:"zoom-out"}[d]).attr({width:a.width,height:a.height,title:g.options.lang[d],padding:a.padding,zIndex:5}).add();l.handler=a.onclick;e(l.element,"dblclick",r);h.push(l);b(a,{width:l.width,height:2*l.height});if(g.hasLoaded)l.align(a,!1,a.alignTo);else var k=e(g,"load",function(){l.element&&l.align(a,!1,a.alignTo);k()})});this.updateEvents(t)};n.prototype.updateEvents=function(d){var g=this.chart;a(d.enableDoubleClickZoom,
d.enabled)||d.enableDoubleClickZoomTo?this.unbindDblClick=this.unbindDblClick||e(g.container,"dblclick",function(a){g.pointer.onContainerDblClick(a)}):this.unbindDblClick&&(this.unbindDblClick=this.unbindDblClick());a(d.enableMouseWheelZoom,d.enabled)?this.unbindMouseWheel=this.unbindMouseWheel||e(g.container,void 0!==u.onwheel?"wheel":void 0!==u.onmousewheel?"mousewheel":"DOMMouseScroll",function(a){g.pointer.inClass(a.target,"highcharts-no-mousewheel")||(g.pointer.onContainerMouseWheel(a),r(a));
return!1}):this.unbindMouseWheel&&(this.unbindMouseWheel=this.unbindMouseWheel())};b(c.prototype,{fitToBox:function(a,g){[["x","width"],["y","height"]].forEach(function(d){var b=d[0];d=d[1];a[b]+a[d]>g[b]+g[d]&&(a[d]>g[d]?(a[d]=g[d],a[b]=g[b]):a[b]=g[b]+g[d]-a[d]);a[d]>g[d]&&(a[d]=g[d]);a[b]<g[b]&&(a[b]=g[b])});return a},mapZoom:function(a,g,b,k,e){this.mapView&&(v(a)&&(a=Math.log(a)/Math.log(.5)),this.mapView.zoomBy(a,v(g)&&v(b)?this.mapView.projection.inverse([g,b]):void 0,v(k)&&v(e)?[k,e]:void 0))}});
e(c,"beforeRender",function(){this.mapNavigation=new n(this);this.mapNavigation.update()});f.MapNavigation=n});y(c,"Maps/MapPointer.js",[c["Core/Pointer.js"],c["Core/Utilities.js"]],function(c,f){var p=f.defined,r=f.extend,n=f.pick;f=f.wrap;var u=0,e;r(c.prototype,{onContainerDblClick:function(b){var e=this.chart;b=this.normalize(b);e.options.mapNavigation.enableDoubleClickZoomTo?e.pointer.inClass(b.target,"highcharts-tracker")&&e.hoverPoint&&e.hoverPoint.zoomTo():e.isInsidePlot(b.chartX-e.plotLeft,
b.chartY-e.plotTop)&&e.mapZoom(.5,void 0,void 0,b.chartX,b.chartY)},onContainerMouseWheel:function(b){var v=this.chart;b=this.normalize(b);var m=p(b.wheelDelta)&&-b.wheelDelta/120||b.deltaY||b.detail;1<=Math.abs(m)&&(u+=Math.abs(m),e&&clearTimeout(e),e=setTimeout(function(){u=0},50));10>u&&v.isInsidePlot(b.chartX-v.plotLeft,b.chartY-v.plotTop)&&v.mapView&&v.mapView.zoomBy((v.options.mapNavigation.mouseWheelSensitivity-1)*-m,void 0,[b.chartX,b.chartY],1>Math.abs(m)?!1:void 0)}});f(c.prototype,"zoomOption",
function(b){var e=this.chart.options.mapNavigation;n(e.enableTouchZoom,e.enabled)&&(this.chart.options.chart.pinchType="xy");b.apply(this,[].slice.call(arguments,1))});f(c.prototype,"pinchTranslate",function(b,e,m,k,a,d,g){b.call(this,e,m,k,a,d,g);"map"===this.chart.options.chart.type&&this.hasZoom&&(b=k.scaleX>k.scaleY,this.pinchTranslateDirection(!b,e,m,k,a,d,g,b?k.scaleX:k.scaleY))})});y(c,"Series/ColorMapMixin.js",[c["Core/Globals.js"],c["Core/Series/Point.js"],c["Core/Utilities.js"]],function(c,
f,p){var r=c.noop;c=c.seriesTypes;var n=p.defined;p=p.addEvent;p(f,"afterSetState",function(c){this.moveToTopOnHover&&this.graphic&&this.graphic.attr({zIndex:c&&"hover"===c.state?1:0})});return{PointMixin:{dataLabelOnNull:!0,moveToTopOnHover:!0,isValid:function(){return null!==this.value&&Infinity!==this.value&&-Infinity!==this.value}},SeriesMixin:{pointArrayMap:["value"],axisTypes:["xAxis","yAxis","colorAxis"],trackerGroups:["group","markerGroup","dataLabelsGroup"],getSymbol:r,parallelArrays:["x",
"y","value"],colorKey:"value",pointAttribs:c.column.prototype.pointAttribs,colorAttribs:function(c){var e={};!n(c.color)||c.state&&"normal"!==c.state||(e[this.colorProp||"fill"]=c.color);return e}}}});y(c,"Maps/MapViewOptionsDefault.js",[],function(){return{center:[0,0],maxZoom:void 0,padding:0,projection:void 0,zoom:void 0}});y(c,"Maps/Projections/LambertConformalConic.js",[],function(){var c=Math.sign||function(c){return 0===c?0:0<c?1:-1},f=Math.PI/180,p=Math.PI/2,r=0,n=0;return{init:function(u){var e=
(u.parallels||[]).map(function(b){return b*f});u=e[0]||0;e=e[1]||u;var b=Math.cos(u);r=u===e?Math.sin(u):Math.log(b/Math.cos(e))/Math.log(Math.tan((p+e)/2)/Math.tan((p+u)/2));1e-10>Math.abs(r)&&(r=1e-10*(c(r)||1));n=b*Math.pow(Math.tan((p+u)/2),r)/r},forward:function(c){var e=c[0]*f;c=c[1]*f;0<n?c<-p+.000001&&(c=-p+.000001):c>p-.000001&&(c=p-.000001);c=n/Math.pow(Math.tan((p+c)/2),r);return[c*Math.sin(r*e)*63.78137,63.78137*(n-c*Math.cos(r*e))]},inverse:function(u){var e=u[0]/63.78137;u=n-u[1]/63.78137;
var b=c(r)*Math.sqrt(e*e+u*u),v=Math.atan2(e,Math.abs(u))*c(u);0>u*r&&(v-=Math.PI*c(e)*c(u));return[v/r/f,(2*Math.atan(Math.pow(n/b,1/r))-p)/f]}}});y(c,"Maps/Projections/EqualEarth.js",[],function(){var c=Math.sqrt(3)/2;return{forward:function(f){var p=Math.PI/180,r=Math.asin(c*Math.sin(f[1]*p)),n=r*r,u=n*n*n;return[f[0]*p*Math.cos(r)*74.03120656864502/(c*(1.340264+3*-.081106*n+u*(7*.000893+.034164*n))),74.03120656864502*r*(1.340264+-.081106*n+u*(.000893+.003796*n))]},inverse:function(f){var p=f[0]/
74.03120656864502;f=f[1]/74.03120656864502;var r=180/Math.PI,n=f,u;for(u=0;12>u;++u){var e=n*n;var b=e*e*e;var v=n*(1.340264+-.081106*e+b*(.000893+.003796*e))-f;e=1.340264+3*-.081106*e+b*(7*.000893+.034164*e);n-=v/=e;if(1e-9>Math.abs(v))break}e=n*n;return[r*c*p*(1.340264+3*-.081106*e+e*e*e*(7*.000893+.034164*e))/Math.cos(n),r*Math.asin(Math.sin(n)/c)]}}});y(c,"Maps/Projections/Miller.js",[],function(){var c=Math.PI/4,f=Math.PI/180;return{forward:function(p){return[p[0]*f*63.78137,79.7267125*Math.log(Math.tan(c+
.4*p[1]*f))]},inverse:function(p){return[p[0]/63.78137/f,2.5*(Math.atan(Math.exp(p[1]/63.78137*.8))-c)/f]}}});y(c,"Maps/Projections/Orthographic.js",[],function(){var c=Math.PI/180;return{forward:function(f){var p=f[0];if(-90>p||90<p)return[NaN,NaN];f=f[1]*c;return[Math.cos(f)*Math.sin(p*c)*63.78460826781007,63.78460826781007*Math.sin(f)]},inverse:function(f){var p=f[0]/63.78460826781007;f=f[1]/63.78460826781007;var r=Math.sqrt(p*p+f*f),n=Math.asin(r),u=Math.sin(n);return[Math.atan2(p*u,r*Math.cos(n))/
c,Math.asin(r&&f*u/r)/c]}}});y(c,"Maps/Projections/WebMercator.js",[],function(){var c=Math.PI/180;return{forward:function(f){if(85.0511287798<Math.abs(f[1]))return[NaN,NaN];var p=Math.sin(f[1]*c);return[63.78137*f[0]*c,63.78137*Math.log((1+p)/(1-p))/2]},inverse:function(f){return[f[0]/(63.78137*c),(2*Math.atan(Math.exp(f[1]/63.78137))-Math.PI/2)/c]},maxLatitude:85.0511287798}});y(c,"Maps/Projections/ProjectionRegistry.js",[c["Maps/Projections/LambertConformalConic.js"],c["Maps/Projections/EqualEarth.js"],
c["Maps/Projections/Miller.js"],c["Maps/Projections/Orthographic.js"],c["Maps/Projections/WebMercator.js"]],function(c,f,p,r,n){return{EqualEarth:f,LambertConformalConic:c,Miller:p,Orthographic:r,WebMercator:n}});y(c,"Maps/Projection.js",[c["Maps/Projections/ProjectionRegistry.js"],c["Core/Utilities.js"]],function(c,f){var p=this&&this.__spreadArrays||function(){for(var c=0,b=0,v=arguments.length;b<v;b++)c+=arguments[b].length;c=Array(c);var m=0;for(b=0;b<v;b++)for(var k=arguments[b],a=0,d=k.length;a<
d;a++,m++)c[m]=k[a];return c},r=f.erase,n=2*Math.PI/360,u=function(c){-180>c&&(c+=360);180<c&&(c-=360);return c};return function(){function e(b){void 0===b&&(b={});this.hasGeoProjection=this.hasCoordinates=!1;this.maxLatitude=90;this.options=b;var c=b.name,m=b.rotation;this.rotator=m?this.getRotator(m):void 0;var k=this.def=c?e.registry[c]:void 0,a=this.rotator;k&&(k.init&&k.init(b),this.maxLatitude=k.maxLatitude||90,this.hasGeoProjection=!0);a&&k?(this.forward=function(d){d=a.forward(d);return k.forward(d)},
this.inverse=function(d){d=k.inverse(d);return a.inverse(d)}):k?(this.forward=k.forward,this.inverse=k.inverse):a&&(this.forward=a.forward,this.inverse=a.inverse)}e.add=function(b,c){e.registry[b]=c};e.greatCircle=function(b,c,e){var k=Math.atan2,a=Math.cos,d=Math.sin,g=Math.sqrt,t=b[1]*n,m=b[0]*n,v=c[1]*n,q=c[0]*n,w=v-t,A=q-m;w=d(w/2)*d(w/2)+a(t)*a(v)*d(A/2)*d(A/2);w=2*k(g(w),g(1-w));var h=Math.round(6371E3*w/5E5);A=[];e&&A.push(b);if(1<h)for(h=b=1/h;.999>h;h+=b){var l=d((1-h)*w)/d(w),u=d(h*w)/d(w),
f=l*a(t)*a(m)+u*a(v)*a(q),p=l*a(t)*d(m)+u*a(v)*d(q);l=l*d(t)+u*d(v);l=k(l,g(f*f+p*p));f=k(p,f);A.push([f/n,l/n])}e&&A.push(c);return A};e.insertGreatCircles=function(b){for(var c=b.length-1;c--;)if(10<Math.max(Math.abs(b[c][0]-b[c+1][0]),Math.abs(b[c][1]-b[c+1][1]))){var m=e.greatCircle(b[c],b[c+1]);m.length&&b.splice.apply(b,p([c+1,0],m))}};e.toString=function(b){b=b||{};var c=b.rotation;return[b.name,c&&c.join(",")].join(";")};e.prototype.getRotator=function(b){var c=b[0]*n,e=(b[1]||0)*n;b=(b[2]||
0)*n;var k=Math.cos(e),a=Math.sin(e),d=Math.cos(b),g=Math.sin(b);if(0!==c||0!==e||0!==b)return{forward:function(b){var e=b[0]*n+c,t=b[1]*n,q=Math.cos(t);b=Math.cos(e)*q;e=Math.sin(e)*q;t=Math.sin(t);q=t*k+b*a;return[Math.atan2(e*d-q*g,b*k-t*a)/n,Math.asin(q*d+e*g)/n]},inverse:function(b){var e=b[0]*n,t=b[1]*n,q=Math.cos(t);b=Math.cos(e)*q;e=Math.sin(e)*q;t=Math.sin(t);q=t*d-e*g;return[(Math.atan2(e*d+t*g,b*k+q*a)-c)/n,Math.asin(q*k-b*a)/n]}}};e.prototype.forward=function(b){return b};e.prototype.inverse=
function(b){return b};e.prototype.clipOnAntimeridian=function(b,c){var m=[],k=[b];b.forEach(function(a,d){var g=b[d-1];if(!d){if(!c)return;g=b[b.length-1]}var h=g[0],l=a[0];(-90>h||90<h)&&(-90>l||90<l)&&0<h!==0<l&&m.push({i:d,lat:g[1]+(180-g[0])/(a[0]-g[0])*(a[1]-g[1]),direction:0>h?1:-1,previousLonLat:g,lonLat:a})});if(m.length)if(c){if(1===m.length%2){var a=m.slice().sort(function(a,d){return Math.abs(d.lat)-Math.abs(a.lat)})[0];r(m,a)}for(var d=m.length-2;0<=d;){var g=m[d].i,t=u(180+.000001*m[d].direction),
x=u(180-.000001*m[d].direction);g=b.splice.apply(b,p([g,m[d+1].i-g],e.greatCircle([t,m[d].lat],[t,m[d+1].lat],!0)));g.push.apply(g,e.greatCircle([x,m[d+1].lat],[x,m[d].lat],!0));k.push(g);d-=2}if(a)for(g=0;g<k.length;g++)if(d=k[g],x=d.indexOf(a.lonLat),-1<x){g=(0>a.lat?-1:1)*this.maxLatitude;t=u(180+.000001*a.direction);var v=u(180-.000001*a.direction);a=e.greatCircle([t,a.lat],[t,g],!0).concat(e.greatCircle([v,g],[v,a.lat],!0));d.splice.apply(d,p([x,0],a));break}}else for(d=m.length;d--;)g=m[d].i,
g=b.splice(g,b.length,[u(180+.000001*m[d].direction),m[d].lat]),g.unshift([u(180-.000001*m[d].direction),m[d].lat]),k.push(g);return k};e.prototype.path=function(b){var c=this,m=this.def,k=this.rotator,a=[],d="Polygon"===b.type||"MultiPolygon"===b.type,g=this.hasGeoProjection,t="Orthographic"!==this.options.name,x=t?k:void 0,u=t?m||this:this,q=function(b){b=b.map(function(a){if(t){x&&(a=x.forward(a));var d=a[0];.000001>Math.abs(d-180)&&(d=180>d?179.999999:180.000001);a=[d,a[1]]}return a});var k=[b];
g&&(e.insertGreatCircles(b),t&&(k=c.clipOnAntimeridian(b,d)));k.forEach(function(h){if(!(2>h.length))for(var b=!1,k,q,t=!1,m=function(d){b?a.push(["L",d[0],d[1]]):(a.push(["M",d[0],d[1]]),b=!0)},w=0;w<h.length;w++){var x=h[w],v=u.forward(x);isNaN(v[0])||isNaN(v[1])||g&&!(x[1]<=c.maxLatitude&&x[1]>=-c.maxLatitude)?t=!0:(d&&!k&&(k=x,h.push(x)),t&&q&&(d&&g?e.greatCircle(q,x).forEach(function(a){return m(u.forward(a))}):b=!1),m(v),q=x,t=!1)}})};"LineString"===b.type?q(b.coordinates):"MultiLineString"===
b.type?b.coordinates.forEach(function(a){return q(a)}):"Polygon"===b.type?(b.coordinates.forEach(function(a){return q(a)}),a.length&&a.push(["Z"])):"MultiPolygon"===b.type&&(b.coordinates.forEach(function(a){a.forEach(function(a){return q(a)})}),a.length&&a.push(["Z"]));return a};e.registry=c;return e}()});y(c,"Maps/MapView.js",[c["Maps/MapViewOptionsDefault.js"],c["Maps/Projection.js"],c["Core/Utilities.js"]],function(c,f,p){var r=p.addEvent,n=p.clamp,u=p.fireEvent,e=p.isNumber,b=p.merge,v=p.pick,
m=p.relativeLength;return function(){function k(a,d){var g=this;this.userOptions=d||{};d=b(c,d);this.chart=a;this.center=d.center;this.options=d;this.projection=new f(d.projection);this.zoom=d.zoom||0;r(a,"afterSetChartSize",function(){if(void 0===g.minZoom||g.minZoom===g.zoom)g.fitToBounds(void 0,void 0,!1),e(g.userOptions.zoom)&&(g.zoom=g.userOptions.zoom),g.userOptions.center&&b(!0,g.center,g.userOptions.center)});var k,m,v;d=function(d){var b=a.pointer.pinchDown,c=a.mouseDownX,h=a.mouseDownY;
1===b.length&&(c=b[0].chartX,h=b[0].chartY);if("number"===typeof c&&"number"===typeof h){var l=c+","+h,e=d.originalEvent;b=e.chartX;e=e.chartY;l!==m&&(m=l,k=g.projection.forward(g.center),v=(g.projection.options.rotation||[0,0]).slice());"Orthographic"===g.projection.options.name&&3>(g.minZoom||Infinity)?(l=440/(g.getScale()*Math.min(a.plotWidth,a.plotHeight)),v&&(c=(c-b)*l-v[0],h=n(-v[1]-(h-e)*l,-80,80),g.update({projection:{rotation:[-c,-h]},center:[c,h],zoom:g.zoom},!0,!1))):(l=g.getScale(),h=
g.projection.inverse([k[0]+(c-b)/l,k[1]-(h-e)/l]),g.setView(h,void 0,!0,!1));d.preventDefault()}};r(a,"pan",d);r(a,"touchpan",d);r(a,"selection",function(d){if(d.resetSelection)g.zoomBy();else{var b=d.x-a.plotLeft,c=d.y-a.plotTop,h=g.pixelsToProjectedUnits({x:b,y:c}),l=h.y;h=h.x;b=g.pixelsToProjectedUnits({x:b+d.width,y:c+d.height});g.fitToBounds({x1:h,y1:l,x2:b.x,y2:b.y},void 0,!0,d.originalEvent.touches?!1:void 0);/^touch/.test(d.originalEvent.type)||a.showResetZoom();d.preventDefault()}})}k.prototype.fitToBounds=
function(a,d,b,c){void 0===b&&(b=!0);var g=a||this.getProjectedBounds();if(g){var e=this.chart,k=e.plotWidth;e=e.plotHeight;var t=v(d,a?0:this.options.padding);d=m(t,k);t=m(t,e);k=Math.log(400.979322/Math.max((g.x2-g.x1)/((k-d)/256),(g.y2-g.y1)/((e-t)/256)))/Math.log(2);a||(this.minZoom=k);a=this.projection.inverse([(g.x2+g.x1)/2,(g.y2+g.y1)/2]);this.setView(a,k,b,c)}};k.prototype.getProjectedBounds=function(){var a=this.chart.series.reduce(function(a,b){(b=b.getProjectedBounds&&b.getProjectedBounds())&&
a.push(b);return a},[]);return k.compositeBounds(a)};k.prototype.getScale=function(){return 256/400.979322*Math.pow(2,this.zoom)};k.prototype.redraw=function(a){this.chart.series.forEach(function(a){a.useMapGeometry&&(a.isDirty=!0)});this.chart.redraw(a)};k.prototype.setView=function(a,d,b,c){void 0===b&&(b=!0);var g=!1;a&&(this.center=a);"number"===typeof d&&("number"===typeof this.minZoom&&(d=Math.max(d,this.minZoom)),"number"===typeof this.options.maxZoom&&(d=Math.min(d,this.options.maxZoom)),
g=d>this.zoom,this.zoom=d);var e=this.getProjectedBounds();if(e&&!g){g=this.projection.forward(this.center);d=this.chart;a=d.plotWidth;d=d.plotHeight;var k=this.getScale(),t=this.projectedUnitsToPixels({x:e.x1,y:e.y1}),m=this.projectedUnitsToPixels({x:e.x2,y:e.y2});e=[(e.x1+e.x2)/2,(e.y1+e.y2)/2];var h=t.x,l=m.y;m=m.x;t=t.y;m-h<a?g[0]=e[0]:0>h&&m<a?g[0]+=Math.max(h,m-a)/k:m>a&&0<h&&(g[0]+=Math.min(m-a,h)/k);t-l<d?g[1]=e[1]:0>l&&t<d?g[1]-=Math.max(l,t-d)/k:t>d&&0<l&&(g[1]-=Math.min(t-d,l)/k);this.center=
this.projection.inverse(g)}u(this,"afterSetView");b&&this.redraw(c)};k.prototype.projectedUnitsToPixels=function(a){var d=this.getScale(),b=this.projection.forward(this.center);return{x:this.chart.plotWidth/2-d*(b[0]-a.x),y:this.chart.plotHeight/2+d*(b[1]-a.y)}};k.prototype.pixelsToProjectedUnits=function(a){var d=a.x;a=a.y;var b=this.getScale(),c=this.projection.forward(this.center);return{x:c[0]+(d-this.chart.plotWidth/2)/b,y:c[1]-(a-this.chart.plotHeight/2)/b}};k.prototype.update=function(a,d,
g){void 0===d&&(d=!0);var c=a.projection;c=c&&f.toString(c)!==f.toString(this.options.projection);b(!0,this.userOptions,a);b(!0,this.options,a);c&&(this.chart.series.forEach(function(a){a.clearBounds&&a.clearBounds();a.isDirty=!0;a.isDirtyData=!0}),this.projection=new f(this.options.projection),a.center||e(a.zoom)||this.fitToBounds(void 0,void 0,!1));(a.center||e(a.zoom))&&this.setView(this.options.center,a.zoom,!1);d&&this.chart.redraw(g)};k.prototype.zoomBy=function(a,b,g,c){var d=this.chart,e=
this.projection.forward(this.center);b=b?this.projection.forward(b):[];var k=b[0],t=b[1];"number"===typeof a?(a=this.zoom+a,b=void 0,g&&(k=g[0],t=g[1],g=this.getScale(),k=k-d.plotLeft-d.plotWidth/2,d=t-d.plotTop-d.plotHeight/2,k=e[0]+k/g,t=e[1]+d/g),"number"===typeof k&&"number"===typeof t&&(g=1-Math.pow(2,this.zoom)/Math.pow(2,a),k=e[0]-k,d=e[1]-t,e[0]-=k*g,e[1]+=d*g,b=this.projection.inverse(e)),this.setView(b,a,void 0,c)):this.fitToBounds(void 0,void 0,void 0,c)};k.compositeBounds=function(a){if(a.length)return a.slice(1).reduce(function(a,
b){a.x1=Math.min(a.x1,b.x1);a.y1=Math.min(a.y1,b.y1);a.x2=Math.max(a.x2,b.x2);a.y2=Math.max(a.y2,b.y2);return a},b(a[0]))};return k}()});y(c,"Maps/MapSymbols.js",[c["Core/Renderer/SVG/SVGRenderer.js"]],function(c){function f(c,f,n,u,e,b,v,m){return[["M",c+e,f],["L",c+n-b,f],["C",c+n-b/2,f,c+n,f+b/2,c+n,f+b],["L",c+n,f+u-v],["C",c+n,f+u-v/2,c+n-v/2,f+u,c+n-v,f+u],["L",c+m,f+u],["C",c+m/2,f+u,c,f+u-m/2,c,f+u-m],["L",c,f+e],["C",c,f+e/2,c+e/2,f,c+e,f],["Z"]]}c=c.prototype.symbols;c.bottombutton=function(c,
r,n,u,e){e=e&&e.r||0;return f(c-1,r-1,n,u,0,0,e,e)};c.topbutton=function(c,r,n,u,e){e=e&&e.r||0;return f(c-1,r-1,n,u,e,e,0,0)};return c});y(c,"Core/Chart/MapChart.js",[c["Core/Chart/Chart.js"],c["Core/DefaultOptions.js"],c["Maps/MapView.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,f,p,r,n){var u=this&&this.__extends||function(){var b=function(a,d){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var d in b)b.hasOwnProperty(d)&&
(a[d]=b[d])};return b(a,d)};return function(a,d){function c(){this.constructor=a}b(a,d);a.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),e=f.getOptions,b=n.addEvent,v=n.merge,m=n.pick;c=function(c){function a(){return null!==c&&c.apply(this,arguments)||this}u(a,c);a.prototype.init=function(a,g){b(this,"afterInit",function(){this.mapView=new p(this,this.options.mapView)});var d=e().credits;a=v({chart:{panning:{enabled:!0,type:"xy"},type:"map"},credits:{mapText:m(d.mapText,
' \u00a9 <a href="{geojson.copyrightUrl}">{geojson.copyrightShort}</a>'),mapTextFull:m(d.mapTextFull,"{geojson.copyright}")},mapView:{},tooltip:{followTouchMove:!1}},a);c.prototype.init.call(this,a,g)};return a}(c);(function(b){b.maps={};b.mapChart=function(a,d,c){return new b(a,d,c)};b.splitPath=function(a){"string"===typeof a&&(a=a.replace(/([A-Za-z])/g," $1 ").replace(/^\s*/,"").replace(/\s*$/,""),a=a.split(/[ ,;]+/).map(function(a){return/[A-za-z]/.test(a)?a:parseFloat(a)}));return r.prototype.pathToSegments(a)}})(c||
(c={}));return c});y(c,"Series/Map/MapPoint.js",[c["Series/ColorMapMixin.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,p){var r=this&&this.__extends||function(){var c=function(e,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var e in c)c.hasOwnProperty(e)&&(b[e]=c[e])};return c(e,b)};return function(e,b){function f(){this.constructor=e}c(e,b);e.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),
n=p.extend;f=function(c){function e(){var b=null!==c&&c.apply(this,arguments)||this;b.options=void 0;b.path=void 0;b.series=void 0;return b}r(e,c);e.getProjectedPath=function(b,c){b.projectedPath||(c&&b.geometry?(c.hasCoordinates=!0,b.projectedPath=c.path(b.geometry)):b.projectedPath=b.path);return b.projectedPath||[]};e.prototype.applyOptions=function(b,e){var m=this.series;b=c.prototype.applyOptions.call(this,b,e);e=m.joinBy;m.mapData&&m.mapMap&&(e=c.prototype.getNestedProperty.call(b,e[1]),(m=
"undefined"!==typeof e&&m.mapMap[e])?n(b,m):b.value=b.value||null);return b};e.prototype.onMouseOver=function(b){p.clearTimeout(this.colorInterval);if(null!==this.value||this.series.options.nullInteraction)c.prototype.onMouseOver.call(this,b);else this.series.onMouseOut(b)};e.prototype.zoomTo=function(){var b=this.series.chart;b.mapView&&this.bounds&&(b.mapView.fitToBounds(this.bounds,void 0,!1),this.series.isDirty=!0,b.redraw())};return e}(f.seriesTypes.scatter.prototype.pointClass);n(f.prototype,
{dataLabelOnNull:c.PointMixin.dataLabelOnNull,isValid:c.PointMixin.isValid,moveToTopOnHover:c.PointMixin.moveToTopOnHover});return f});y(c,"Series/Map/MapSeries.js",[c["Core/Animation/AnimationUtilities.js"],c["Series/ColorMapMixin.js"],c["Series/CenteredUtilities.js"],c["Core/Globals.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Chart/MapChart.js"],c["Series/Map/MapPoint.js"],c["Maps/MapView.js"],c["Core/Series/Series.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],
c["Core/Utilities.js"]],function(c,f,p,r,n,u,e,b,v,m,k,a){var d=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),g=c.animObject;c=r.noop;var t=u.maps,x=u.splitPath;u=m.seriesTypes;var z=u.column,q=u.scatter;
u=a.extend;var w=a.fireEvent,A=a.getNestedProperty,h=a.isArray,l=a.isNumber,B=a.merge,E=a.objectEach,C=a.pick,F=a.splat;a=function(a){function c(){var b=null!==a&&a.apply(this,arguments)||this;b.chart=void 0;b.data=void 0;b.group=void 0;b.joinBy=void 0;b.options=void 0;b.points=void 0;b.transformGroup=void 0;return b}d(c,a);c.prototype.animate=function(a){var b=this.chart,c=this.group,d=g(this.options.animation);b.renderer.isSVG&&(a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+
b.plotHeight/2,scaleX:.001,scaleY:.001}):c.animate({translateX:b.plotLeft,translateY:b.plotTop,scaleX:1,scaleY:1},d))};c.prototype.animateDrilldown=function(a){var b=this.chart,c=this.group;b.renderer.isSVG&&(a?c.attr({translateX:b.plotLeft+b.plotWidth/2,translateY:b.plotTop+b.plotHeight/2,scaleX:.1,scaleY:.1,opacity:.01}):c.animate({translateX:b.plotLeft,translateY:b.plotTop,scaleX:1,scaleY:1,opacity:1}))};c.prototype.animateDrillupFrom=function(){var a=this.chart;a.renderer.isSVG&&this.group.animate({translateX:a.plotLeft+
a.plotWidth/2,translateY:a.plotTop+a.plotHeight/2,scaleX:.1,scaleY:.1,opacity:.01})};c.prototype.animateDrillupTo=function(a){z.prototype.animateDrillupTo.call(this,a)};c.prototype.clearBounds=function(){this.points.forEach(function(a){delete a.bounds;delete a.projectedPath});delete this.bounds};c.prototype.doFullTranslate=function(){return!(!(this.isDirtyData||this.chart.isResizing||this.chart.renderer.isVML)&&this.hasRendered)};c.prototype.drawMapDataLabels=function(){v.prototype.drawDataLabels.call(this);
this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};c.prototype.drawPoints=function(){var a=this,b=this.chart,c=this.group,d=this.svgTransform,h=b.mapView,g=b.renderer;this.transformGroup||(this.transformGroup=g.g().add(c),this.transformGroup.survive=!0);this.doFullTranslate()&&(b.hasRendered&&!b.styledMode&&this.points.forEach(function(b){b.shapeArgs&&(b.shapeArgs.fill=a.pointAttribs(b,b.state).fill)}),this.group=this.transformGroup,z.prototype.drawPoints.apply(this),this.group=
c,this.points.forEach(function(c){if(c.graphic){var d="";c.name&&(d+="highcharts-name-"+c.name.replace(/ /g,"-").toLowerCase());c.properties&&c.properties["hc-key"]&&(d+=" highcharts-key-"+c.properties["hc-key"].toLowerCase());d&&c.graphic.addClass(d);b.styledMode&&c.graphic.css(a.pointAttribs(c,c.selected&&"select"||void 0))}}));if(h&&d){var e=C(this.options[this.pointAttrToOptions&&this.pointAttrToOptions["stroke-width"]||"borderWidth"],1),l=d.scaleX,k=0<d.scaleY?1:-1,t=this.transformGroup;if(g.globalAnimation&&
b.hasRendered){var m=Number(t.attr("translateX")),q=Number(t.attr("translateY")),f=Number(t.attr("scaleX"));t.attr({animator:0}).animate({animator:1},{step:function(a,b){a=f+(l-f)*b.pos;t.attr({translateX:m+(d.translateX-m)*b.pos,translateY:q+(d.translateY-q)*b.pos,scaleX:a,scaleY:a*k});c.element.setAttribute("stroke-width",e/a)}})}else t.attr(d),c.element.setAttribute("stroke-width",e/l)}this.drawMapDataLabels()};c.prototype.getProjectedBounds=function(){if(!this.bounds){var a=Number.MAX_VALUE,c=
this.chart.mapView&&this.chart.mapView.projection,d=[];(this.points||[]).forEach(function(b){if(b.path||b.geometry){"string"===typeof b.path?b.path=x(b.path):h(b.path)&&"M"===b.path[0]&&(b.path=k.prototype.pathToSegments(b.path));if(!b.bounds){var g=e.getProjectedPath(b,c),t=b.properties,m=-a,q=a,f=-a,w=a,v;g.forEach(function(a){var b=a[a.length-2];a=a[a.length-1];"number"===typeof b&&"number"===typeof a&&(q=Math.min(q,b),m=Math.max(m,b),w=Math.min(w,a),f=Math.max(f,a),v=!0)});v&&(g=t&&t["hc-middle-x"],
g=q+(m-q)*C(b.middleX,l(g)?g:.5),t=t&&t["hc-middle-y"],t=C(b.middleY,l(t)?t:.5),b.geometry||(t=1-t),b.bounds={midX:g,midY:f-(f-w)*t,x1:q,y1:w,x2:m,y2:f},b.labelrank=C(b.labelrank,(m-q)*(f-w)))}b.bounds&&d.push(b.bounds)}});this.bounds=b.compositeBounds(d)}return this.bounds};c.prototype.hasData=function(){return!!this.processedXData.length};c.prototype.pointAttribs=function(a,b){var c=a.series.chart,d=c.mapView;b=c.styledMode?this.colorAttribs(a):z.prototype.pointAttribs.call(this,a,b);(a=a.options[this.pointAttrToOptions&&
this.pointAttrToOptions["stroke-width"]||"borderWidth"])&&d&&(a/=d.getScale());b.dashstyle&&d&&this.options.borderWidth&&(a=this.options.borderWidth/d.getScale());b["stroke-width"]=C(a,"inherit");return b};c.prototype.setData=function(a,b,c,d){var g=this.options,k=this.chart.options.chart,m=k&&k.map,q=g.mapData,f=this.joinBy,w=g.keys||this.pointArrayMap,u=[],x={},n=this.chart.mapTransforms;!q&&m&&(q="string"===typeof m?t[m]:m);a&&a.forEach(function(b,c){var d=0;if(l(b))a[c]={value:b};else if(h(b)){a[c]=
{};!g.keys&&b.length>w.length&&"string"===typeof b[0]&&(a[c]["hc-key"]=b[0],++d);for(var k=0;k<w.length;++k,++d)w[k]&&"undefined"!==typeof b[d]&&(0<w[k].indexOf(".")?e.prototype.setNestedProperty(a[c],b[d],w[k]):a[c][w[k]]=b[d])}f&&"_i"===f[0]&&(a[c]._i=c)});(this.chart.mapTransforms=n=k.mapTransforms||q&&q["hc-transform"]||n)&&E(n,function(a){a.rotation&&(a.cosAngle=Math.cos(a.rotation),a.sinAngle=Math.sin(a.rotation))});if(q){"FeatureCollection"===q.type&&(this.mapTitle=q.title,q=r.geojson(q,this.type,
this));this.mapData=q;this.mapMap={};for(n=0;n<q.length;n++)k=q[n],m=k.properties,k._i=n,f[0]&&m&&m[f[0]]&&(k[f[0]]=m[f[0]]),x[k[f[0]]]=k;this.mapMap=x;if(a&&f[1]){var p=f[1];a.forEach(function(a){a=A(p,a);x[a]&&u.push(x[a])})}if(g.allAreas){a=a||[];if(f[1]){var z=f[1];a.forEach(function(a){u.push(A(z,a))})}u="|"+u.map(function(a){return a&&a[f[0]]}).join("|")+"|";q.forEach(function(b){f[0]&&-1!==u.indexOf("|"+b[f[0]]+"|")||(a.push(B(b,{value:null})),d=!1)})}}v.prototype.setData.call(this,a,b,c,d);
this.processData();this.generatePoints()};c.prototype.setOptions=function(a){a=v.prototype.setOptions.call(this,a);var b=a.joinBy;null===b&&(b="_i");b=this.joinBy=F(b);b[1]||(b[1]=b[0]);return a};c.prototype.translate=function(){var a=this.doFullTranslate(),b=this.chart.mapView,c=b&&b.projection;!this.chart.hasRendered||!this.isDirtyData&&this.hasRendered||(this.processData(),this.generatePoints(),delete this.bounds,this.getProjectedBounds());var d;if(b){var h=b.getScale(),g=b.projection.forward(b.center);
b=b.projection.hasCoordinates?-1:1;this.svgTransform=d={scaleX:h,scaleY:h*b,translateX:this.chart.plotWidth/2-g[0]*h,translateY:this.chart.plotHeight/2-g[1]*h*b}}this.points.forEach(function(b){d&&b.bounds&&l(b.bounds.midX)&&l(b.bounds.midY)&&(b.plotX=b.bounds.midX*d.scaleX+d.translateX,b.plotY=b.bounds.midY*d.scaleY+d.translateY);a&&(b.shapeType="path",b.shapeArgs={d:e.getProjectedPath(b,c)})});w(this,"afterTranslate")};c.defaultOptions=B(q.defaultOptions,{animation:!1,dataLabels:{crop:!1,formatter:function(){var a=
this.series.chart.numberFormatter,b=this.point.value;return l(b)?a(b,-1):""},inside:!0,overflow:!1,padding:0,verticalAlign:"middle"},marker:null,nullColor:"#f7f7f7",stickyTracking:!1,tooltip:{followPointer:!0,pointFormat:"{point.name}: {point.value}<br/>"},turboThreshold:0,allAreas:!0,borderColor:"#cccccc",borderWidth:1,joinBy:"hc-key",states:{hover:{halo:null,brightness:.2},normal:{animation:!0},select:{color:"#cccccc"},inactive:{opacity:1}}});return c}(q);u(a.prototype,{type:"map",axisTypes:f.SeriesMixin.axisTypes,
colorAttribs:f.SeriesMixin.colorAttribs,colorKey:f.SeriesMixin.colorKey,directTouch:!0,drawDataLabels:c,drawGraph:c,drawLegendSymbol:n.drawRectangle,forceDL:!0,getCenter:p.getCenter,getExtremesFromAll:!0,getSymbol:f.SeriesMixin.getSymbol,isCartesian:!1,parallelArrays:f.SeriesMixin.parallelArrays,pointArrayMap:f.SeriesMixin.pointArrayMap,pointClass:e,preserveAspectRatio:!0,searchPoint:c,trackerGroups:f.SeriesMixin.trackerGroups,useMapGeometry:!0});m.registerSeriesType("map",a);"";return a});y(c,"Series/MapLine/MapLineSeries.js",
[c["Series/Map/MapSeries.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,p){var r=this&&this.__extends||function(){var b=function(c,e){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=a[c])};return b(c,e)};return function(c,e){function k(){this.constructor=c}b(c,e);c.prototype=null===e?Object.create(e):(k.prototype=e.prototype,new k)}}(),n=f.series,u=p.extend,e=p.merge;p=function(b){function f(){var c=
null!==b&&b.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}r(f,b);f.prototype.pointAttribs=function(b,e){b=c.prototype.pointAttribs.call(this,b,e);b.fill=this.options.fillColor;return b};f.defaultOptions=e(c.defaultOptions,{lineWidth:1,fillColor:"none"});return f}(c);u(p.prototype,{type:"mapline",colorProp:"stroke",drawLegendSymbol:n.prototype.drawLegendSymbol,pointAttrToOptions:{stroke:"color","stroke-width":"lineWidth"}});f.registerSeriesType("mapline",p);"";
return p});y(c,"Series/MapPoint/MapPointPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f){var p=this&&this.__extends||function(){var c=function(e,b){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var e in c)c.hasOwnProperty(e)&&(b[e]=c[e])};return c(e,b)};return function(e,b){function f(){this.constructor=e}c(e,b);e.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}(),r=f.isNumber,n=f.merge;
return function(c){function e(){var b=null!==c&&c.apply(this,arguments)||this;b.options=void 0;b.series=void 0;return b}p(e,c);e.prototype.applyOptions=function(b,e){b="undefined"!==typeof b.lat&&"undefined"!==typeof b.lon?n(b,this.series.chart.fromLatLonToPoint(b)):b;return c.prototype.applyOptions.call(this,b,e)};e.prototype.isValid=function(){return!!(this.options.geometry||r(this.x)&&r(this.y))};return e}(c.seriesTypes.scatter.prototype.pointClass)});y(c,"Series/MapPoint/MapPointSeries.js",[c["Core/Globals.js"],
c["Series/MapPoint/MapPointPoint.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,p,r){var n=this&&this.__extends||function(){var b=function(a,c){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return b(a,c)};return function(a,c){function d(){this.constructor=a}b(a,c);a.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}();c=c.noop;var u=p.seriesTypes.scatter,
e=r.extend,b=r.fireEvent,v=r.isNumber,m=r.merge;r=function(c){function a(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}n(a,c);a.prototype.drawDataLabels=function(){c.prototype.drawDataLabels.call(this);this.dataLabelsGroup&&this.dataLabelsGroup.clip(this.chart.clipRect)};a.prototype.translate=function(){var a=this,c=this.chart.mapView;this.processedXData||this.processData();this.generatePoints();if(c){var e=c.projection,k=e.forward,f=e.hasCoordinates;
this.points.forEach(function(b){var d=b.x;d=void 0===d?void 0:d;var g=b.y;g=void 0===g?void 0:g;var h=b.options.geometry;(h=h&&"Point"===h.type&&h.coordinates)?(g=k(h),d=g[0],g=g[1]):b.bounds&&(d=b.bounds.midX,g=b.bounds.midY);v(d)&&v(g)?(d=c.projectedUnitsToPixels({x:d,y:g}),b.plotX=d.x,b.plotY=f?d.y:a.chart.plotHeight-d.y):(b.plotX=void 0,b.plotY=void 0);b.isInside=a.isPointInside(b);b.zone=a.zones.length?b.getZone():void 0})}b(this,"afterTranslate")};a.defaultOptions=m(u.defaultOptions,{dataLabels:{crop:!1,
defer:!1,enabled:!0,formatter:function(){return this.point.name},overflow:!1,style:{color:"#000000"}}});return a}(u);e(r.prototype,{type:"mappoint",axisTypes:["colorAxis"],forceDL:!0,isCartesian:!1,pointClass:f,searchPoint:c,useMapGeometry:!0});p.registerSeriesType("mappoint",r);"";return r});y(c,"Series/Bubble/BubbleLegendDefaults.js",[],function(){return{borderColor:void 0,borderWidth:2,className:void 0,color:void 0,connectorClassName:void 0,connectorColor:void 0,connectorDistance:60,connectorWidth:1,
enabled:!1,labels:{className:void 0,allowOverlap:!1,format:"",formatter:void 0,align:"right",style:{fontSize:"10px",color:"#000000"},x:0,y:0},maxSize:60,minSize:10,legendIndex:0,ranges:{value:void 0,borderColor:void 0,color:void 0,connectorColor:void 0},sizeBy:"area",sizeByAbsoluteValue:!1,zIndex:1,zThreshold:0}});y(c,"Series/Bubble/BubbleLegendItem.js",[c["Core/Color/Color.js"],c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,f,p,r){var n=c.parse,u=p.noop,e=r.arrayMax,
b=r.arrayMin,v=r.isNumber,m=r.merge,k=r.pick,a=r.stableSort;"";return function(){function c(a,b){this.options=this.symbols=this.visible=this.selected=this.ranges=this.movementX=this.maxLabel=this.legendSymbol=this.legendItemWidth=this.legendItemHeight=this.legendItem=this.legendGroup=this.legend=this.fontMetrics=this.chart=void 0;this.setState=u;this.init(a,b)}c.prototype.init=function(a,b){this.options=a;this.visible=!0;this.chart=b.chart;this.legend=b};c.prototype.addToLegend=function(a){a.splice(this.options.legendIndex,
0,this)};c.prototype.drawLegendSymbol=function(b){var c=this.chart,d=this.options,g=k(b.options.itemDistance,20),e=d.ranges,f=d.connectorDistance;this.fontMetrics=c.renderer.fontMetrics(d.labels.style.fontSize);e&&e.length&&v(e[0].value)?(a(e,function(a,b){return b.value-a.value}),this.ranges=e,this.setOptions(),this.render(),b=this.getMaxLabelSize(),e=this.ranges[0].radius,c=2*e,f=f-e+b.width,f=0<f?f:0,this.maxLabel=b,this.movementX="left"===d.labels.align?f:0,this.legendItemWidth=c+f+g,this.legendItemHeight=
c+this.fontMetrics.h/2):b.options.bubbleLegend.autoRanges=!0};c.prototype.setOptions=function(){var a=this.ranges,b=this.options,c=this.chart.series[b.seriesIndex],d=this.legend.baseline,e={zIndex:b.zIndex,"stroke-width":b.borderWidth},f={zIndex:b.zIndex,"stroke-width":b.connectorWidth},u={align:this.legend.options.rtl||"left"===b.labels.align?"right":"left",zIndex:b.zIndex},h=c.options.marker.fillOpacity,l=this.chart.styledMode;a.forEach(function(g,t){l||(e.stroke=k(g.borderColor,b.borderColor,c.color),
e.fill=k(g.color,b.color,1!==h?n(c.color).setOpacity(h).get("rgba"):c.color),f.stroke=k(g.connectorColor,b.connectorColor,c.color));a[t].radius=this.getRangeRadius(g.value);a[t]=m(a[t],{center:a[0].radius-a[t].radius+d});l||m(!0,a[t],{bubbleAttribs:m(e),connectorAttribs:m(f),labelAttribs:u})},this)};c.prototype.getRangeRadius=function(a){var b=this.options;return this.chart.series[this.options.seriesIndex].getRadius.call(this,b.ranges[b.ranges.length-1].value,b.ranges[0].value,b.minSize,b.maxSize,
a)};c.prototype.render=function(){var a=this.chart.renderer,b=this.options.zThreshold;this.symbols||(this.symbols={connectors:[],bubbleItems:[],labels:[]});this.legendSymbol=a.g("bubble-legend");this.legendItem=a.g("bubble-legend-item");this.legendSymbol.translateX=0;this.legendSymbol.translateY=0;this.ranges.forEach(function(a){a.value>=b&&this.renderRange(a)},this);this.legendSymbol.add(this.legendItem);this.legendItem.add(this.legendGroup);this.hideOverlappingLabels()};c.prototype.renderRange=
function(a){var b=this.options,c=b.labels,d=this.chart,g=d.series[b.seriesIndex],e=d.renderer,k=this.symbols;d=k.labels;var h=a.center,l=Math.abs(a.radius),f=b.connectorDistance||0,m=c.align,u=b.connectorWidth,n=this.ranges[0].radius||0,v=h-l-b.borderWidth/2+u/2,p=this.fontMetrics;p=p.f/2-(p.h-p.f)/2;var r=e.styledMode;f=this.legend.options.rtl||"left"===m?-f:f;"center"===m&&(f=0,b.connectorDistance=0,a.labelAttribs.align="center");m=v+b.labels.y;var D=n+f+b.labels.x;k.bubbleItems.push(e.circle(n,
h+((v%1?1:.5)-(u%2?0:.5)),l).attr(r?{}:a.bubbleAttribs).addClass((r?"highcharts-color-"+g.colorIndex+" ":"")+"highcharts-bubble-legend-symbol "+(b.className||"")).add(this.legendSymbol));k.connectors.push(e.path(e.crispLine([["M",n,v],["L",n+f,v]],b.connectorWidth)).attr(r?{}:a.connectorAttribs).addClass((r?"highcharts-color-"+this.options.seriesIndex+" ":"")+"highcharts-bubble-legend-connectors "+(b.connectorClassName||"")).add(this.legendSymbol));a=e.text(this.formatLabel(a),D,m+p).attr(r?{}:a.labelAttribs).css(r?
{}:c.style).addClass("highcharts-bubble-legend-labels "+(b.labels.className||"")).add(this.legendSymbol);d.push(a);a.placed=!0;a.alignAttr={x:D,y:m+p}};c.prototype.getMaxLabelSize=function(){var a,b;this.symbols.labels.forEach(function(c){b=c.getBBox(!0);a=a?b.width>a.width?b:a:b});return a||{}};c.prototype.formatLabel=function(a){var b=this.options,c=b.labels.formatter;b=b.labels.format;var d=this.chart.numberFormatter;return b?f.format(b,a):c?c.call(a):d(a.value,1)};c.prototype.hideOverlappingLabels=
function(){var a=this.chart,b=this.symbols;!this.options.labels.allowOverlap&&b&&(a.hideOverlappingLabels(b.labels),b.labels.forEach(function(a,c){a.newOpacity?a.newOpacity!==a.oldOpacity&&b.connectors[c].show():b.connectors[c].hide()}))};c.prototype.getRanges=function(){var a=this.legend.bubbleLegend,c=a.options.ranges,d,f=Number.MAX_VALUE,q=-Number.MAX_VALUE;a.chart.series.forEach(function(a){a.isBubble&&!a.ignoreSeries&&(d=a.zData.filter(v),d.length&&(f=k(a.options.zMin,Math.min(f,Math.max(b(d),
!1===a.options.displayNegative?a.options.zThreshold:-Number.MAX_VALUE))),q=k(a.options.zMax,Math.max(q,e(d)))))});var n=f===q?[{value:q}]:[{value:f},{value:(f+q)/2},{value:q,autoRanges:!0}];c.length&&c[0].radius&&n.reverse();n.forEach(function(a,b){c&&c[b]&&(n[b]=m(c[b],a))});return n};c.prototype.predictBubbleSizes=function(){var a=this.chart,b=this.fontMetrics,c=a.legend.options,d=c.floating,e=(c="horizontal"===c.layout)?a.legend.lastLineHeight:0,k=a.plotSizeX,f=a.plotSizeY,h=a.series[this.options.seriesIndex],
l=h.getPxExtremes();a=Math.ceil(l.minPxSize);l=Math.ceil(l.maxPxSize);var m=Math.min(f,k);h=h.options.maxSize;if(d||!/%$/.test(h))b=l;else if(h=parseFloat(h),b=(m+e-b.h/2)*h/100/(h/100+1),c&&f-b>=k||!c&&k-b>=f)b=l;return[a,Math.ceil(b)]};c.prototype.updateRanges=function(a,b){var c=this.legend.options.bubbleLegend;c.minSize=a;c.maxSize=b;c.ranges=this.getRanges()};c.prototype.correctSizes=function(){var a=this.legend,b=this.chart.series[this.options.seriesIndex].getPxExtremes();1<Math.abs(Math.ceil(b.maxPxSize)-
this.options.maxSize)&&(this.updateRanges(this.options.minSize,b.maxPxSize),a.render())};return c}()});y(c,"Series/Bubble/BubbleLegendComposition.js",[c["Series/Bubble/BubbleLegendDefaults.js"],c["Series/Bubble/BubbleLegendItem.js"],c["Core/DefaultOptions.js"],c["Core/Utilities.js"]],function(c,f,p,r){var n=p.setOptions,u=r.addEvent,e=r.objectEach,b=r.wrap,v;(function(m){function k(b,c,g){var h=this.legend,l=0<=a(this);if(h&&h.options.enabled&&h.bubbleLegend&&h.options.bubbleLegend.autoRanges&&l){var k=
h.bubbleLegend.options;l=h.bubbleLegend.predictBubbleSizes();h.bubbleLegend.updateRanges(l[0],l[1]);k.placed||(h.group.placed=!1,h.allItems.forEach(function(a){a.legendGroup.translateY=null}));h.render();this.getMargins();this.axes.forEach(function(a){a.visible&&a.render();k.placed||(a.setScale(),a.updateNames(),e(a.ticks,function(a){a.isNew=!0;a.isNewLabel=!0}))});k.placed=!0;this.getMargins();b.call(this,c,g);h.bubbleLegend.correctSizes();v(h,d(h))}else b.call(this,c,g),h&&h.options.enabled&&h.bubbleLegend&&
(h.render(),v(h,d(h)))}function a(a){a=a.series;for(var b=0;b<a.length;){if(a[b]&&a[b].isBubble&&a[b].visible&&a[b].zData.length)return b;b++}return-1}function d(a){a=a.allItems;var b=[],c=a.length,d,e=0;for(d=0;d<c;d++)if(a[d].legendItemHeight&&(a[d].itemHeight=a[d].legendItemHeight),a[d]===a[c-1]||a[d+1]&&a[d]._legendItemPos[1]!==a[d+1]._legendItemPos[1]){b.push({height:0});var g=b[b.length-1];for(e;e<=d;e++)a[e].itemHeight>g.height&&(g.height=a[e].itemHeight);g.step=d}return b}function g(b){var c=
this.bubbleLegend,d=this.options,h=d.bubbleLegend,e=a(this.chart);c&&c.ranges&&c.ranges.length&&(h.ranges.length&&(h.autoRanges=!!h.ranges[0].autoRanges),this.destroyItem(c));0<=e&&d.enabled&&h.enabled&&(h.seriesIndex=e,this.bubbleLegend=new f(h,this),this.bubbleLegend.addToLegend(b.allItems))}function t(){var b=this.chart,c=this.visible,d=this.chart.legend;d&&d.bubbleLegend&&(this.visible=!c,this.ignoreSeries=c,b=0<=a(b),d.bubbleLegend.visible!==b&&(d.update({bubbleLegend:{enabled:b}}),d.bubbleLegend.visible=
b),this.visible=c)}function v(a,b){var c=a.options.rtl,d,e,g,k=0;a.allItems.forEach(function(a,h){d=a.legendGroup.translateX;e=a._legendItemPos[1];if((g=a.movementX)||c&&a.ranges)g=c?d-a.options.maxSize/2:d+g,a.legendGroup.attr({translateX:g});h>b[k].step&&k++;a.legendGroup.attr({translateY:Math.round(e+b[k].height/2)});a._legendItemPos[1]=e+b[k].height/2})}var p=[];m.compose=function(a,d,e){-1===p.indexOf(a)&&(p.push(a),n({legend:{bubbleLegend:c}}),b(a.prototype,"drawChartBox",k));-1===p.indexOf(d)&&
(p.push(d),u(d,"afterGetAllItems",g));-1===p.indexOf(e)&&(p.push(e),u(e,"legendItemClick",t))}})(v||(v={}));return v});y(c,"Series/Bubble/BubblePoint.js",[c["Core/Series/Point.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,p){var r=this&&this.__extends||function(){var c=function(f,e){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var e in c)c.hasOwnProperty(e)&&(b[e]=c[e])};return c(f,e)};return function(f,e){function b(){this.constructor=
f}c(f,e);f.prototype=null===e?Object.create(e):(b.prototype=e.prototype,new b)}}();p=p.extend;f=function(f){function n(){var c=null!==f&&f.apply(this,arguments)||this;c.options=void 0;c.series=void 0;return c}r(n,f);n.prototype.haloPath=function(e){return c.prototype.haloPath.call(this,0===e?0:(this.marker?this.marker.radius||0:0)+e)};return n}(f.seriesTypes.scatter.prototype.pointClass);p(f.prototype,{ttBelow:!1});return f});y(c,"Series/Bubble/BubbleSeries.js",[c["Core/Axis/Axis.js"],c["Series/Bubble/BubbleLegendComposition.js"],
c["Series/Bubble/BubblePoint.js"],c["Core/Color/Color.js"],c["Core/Globals.js"],c["Core/Series/Series.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,p,r,n,u,e,b){var v=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):
(d.prototype=c.prototype,new d)}}(),m=r.parse;r=n.noop;var k=e.seriesTypes;n=k.column;var a=k.scatter;k=b.addEvent;var d=b.arrayMax,g=b.arrayMin,t=b.clamp,x=b.extend,z=b.isNumber,q=b.merge,w=b.pick;b=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.maxPxSize=void 0;a.minPxSize=void 0;a.options=void 0;a.points=void 0;a.radii=void 0;a.yData=void 0;a.zData=void 0;return a}v(c,b);c.prototype.animate=function(a){!a&&this.points.length<this.options.animationLimit&&
this.points.forEach(function(a){var b=a.graphic;b&&b.width&&(this.hasRendered||b.attr({x:a.plotX,y:a.plotY,width:1,height:1}),b.animate(this.markerAttribs(a),this.options.animation))},this)};c.prototype.getRadii=function(){var a=this,b=this.zData,c=this.yData,d=[],e=this.chart.bubbleZExtremes;var h=this.getPxExtremes();var g=h.minPxSize,k=h.maxPxSize;if(!e){var f=Number.MAX_VALUE,m=-Number.MAX_VALUE,t;this.chart.series.forEach(function(b){b.bubblePadding&&(b.visible||!a.chart.options.chart.ignoreHiddenSeries)&&
(b=b.getZExtremes())&&(f=Math.min(f||b.zMin,b.zMin),m=Math.max(m||b.zMax,b.zMax),t=!0)});t?(e={zMin:f,zMax:m},this.chart.bubbleZExtremes=e):e={zMin:0,zMax:0}}var q=0;for(h=b.length;q<h;q++){var n=b[q];d.push(this.getRadius(e.zMin,e.zMax,g,k,n,c[q]))}this.radii=d};c.prototype.getRadius=function(a,b,c,d,e,h){var g=this.options,k="width"!==g.sizeBy,f=g.zThreshold,l=b-a,m=.5;if(null===h||null===e)return null;if(z(e)){g.sizeByAbsoluteValue&&(e=Math.abs(e-f),l=Math.max(b-f,Math.abs(a-f)),a=0);if(e<a)return c/
2-1;0<l&&(m=(e-a)/l)}k&&0<=m&&(m=Math.sqrt(m));return Math.ceil(c+m*(d-c))/2};c.prototype.hasData=function(){return!!this.processedXData.length};c.prototype.pointAttribs=function(a,b){var c=this.options.marker.fillOpacity;a=u.prototype.pointAttribs.call(this,a,b);1!==c&&(a.fill=m(a.fill).setOpacity(c).get("rgba"));return a};c.prototype.translate=function(){b.prototype.translate.call(this);this.getRadii();this.translateBubble()};c.prototype.translateBubble=function(){for(var a=this.data,b=this.radii,
c=this.getPxExtremes().minPxSize,d=a.length;d--;){var e=a[d],h=b?b[d]:0;z(h)&&h>=c/2?(e.marker=x(e.marker,{radius:h,width:2*h,height:2*h}),e.dlBox={x:e.plotX-h,y:e.plotY-h,width:2*h,height:2*h}):e.shapeArgs=e.plotY=e.dlBox=void 0}};c.prototype.getPxExtremes=function(){var a=Math.min(this.chart.plotWidth,this.chart.plotHeight),b=function(b){if("string"===typeof b){var c=/%$/.test(b);b=parseInt(b,10)}return c?a*b/100:b},c=b(w(this.options.minSize,8));b=Math.max(b(w(this.options.maxSize,"20%")),c);return{minPxSize:c,
maxPxSize:b}};c.prototype.getZExtremes=function(){var a=this.options,b=(this.zData||[]).filter(z);if(b.length){var c=w(a.zMin,t(g(b),!1===a.displayNegative?a.zThreshold||0:-Number.MAX_VALUE,Number.MAX_VALUE));a=w(a.zMax,d(b));if(z(c)&&z(a))return{zMin:c,zMax:a}}};c.compose=f.compose;c.defaultOptions=q(a.defaultOptions,{dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.z;return z(b)?a(b,-1):""},inside:!0,verticalAlign:"middle"},animationLimit:250,marker:{lineColor:null,
lineWidth:1,fillOpacity:.5,radius:null,states:{hover:{radiusPlus:0}},symbol:"circle"},minSize:8,maxSize:"20%",softThreshold:!1,states:{hover:{halo:{size:5}}},tooltip:{pointFormat:"({point.x}, {point.y}), Size: {point.z}"},turboThreshold:0,zThreshold:0,zoneAxis:"z"});return c}(a);x(b.prototype,{alignDataLabel:n.prototype.alignDataLabel,applyZones:r,bubblePadding:!0,buildKDTree:r,directTouch:!0,isBubble:!0,pointArrayMap:["y","z"],pointClass:p,parallelArrays:["x","y","z"],trackerGroups:["group","dataLabelsGroup"],
specialGroup:"group",zoneAxis:"z"});k(b,"updatedData",function(a){delete a.target.chart.bubbleZExtremes});c.prototype.beforePadding=function(){var a=this,b=this.len,c=this.chart,d=0,e=b,g=this.isXAxis,k=g?"xData":"yData",f=this.min,m=this.max-f,t=b/m,q;this.series.forEach(function(b){if(b.bubblePadding&&(b.visible||!c.options.chart.ignoreHiddenSeries)){q=a.allowZoomOutside=!0;var h=b[k];g&&b.getRadii(0,0,b);if(0<m)for(var l=h.length;l--;)if(z(h[l])&&a.dataMin<=h[l]&&h[l]<=a.max){var n=b.radii&&b.radii[l]||
0;d=Math.min((h[l]-f)*t-n,d);e=Math.max((h[l]-f)*t+n,e)}}});q&&0<m&&!this.logarithmic&&(e-=b,t*=(b+Math.max(0,d)-Math.min(e,b))/b,[["min","userMin",d],["max","userMax",e]].forEach(function(b){"undefined"===typeof w(a.options[b[0]],a[b[1]])&&(a[b[0]]+=b[2]/t)}))};e.registerSeriesType("bubble",b);"";"";return b});y(c,"Series/MapBubble/MapBubblePoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f){var p=this&&this.__extends||function(){var c=function(e,b){c=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var e in c)c.hasOwnProperty(e)&&(b[e]=c[e])};return c(e,b)};return function(e,b){function f(){this.constructor=e}c(e,b);e.prototype=null===b?Object.create(b):(f.prototype=b.prototype,new f)}}();c=c.seriesTypes;var r=c.map,n=f.merge;return function(c){function e(){return null!==c&&c.apply(this,arguments)||this}p(e,c);e.prototype.applyOptions=function(b,e){return b&&"undefined"!==typeof b.lat&&"undefined"!==typeof b.lon?
c.prototype.applyOptions.call(this,n(b,this.series.chart.fromLatLonToPoint(b)),e):r.prototype.pointClass.prototype.applyOptions.call(this,b,e)};e.prototype.isValid=function(){return"number"===typeof this.z};return e}(c.bubble.prototype.pointClass)});y(c,"Series/MapBubble/MapBubbleSeries.js",[c["Series/Bubble/BubbleSeries.js"],c["Series/MapBubble/MapBubblePoint.js"],c["Series/Map/MapSeries.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f,p,r,n){var u=this&&this.__extends||
function(){var b=function(c,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return b(c,a)};return function(c,a){function d(){this.constructor=c}b(c,a);c.prototype=null===a?Object.create(a):(d.prototype=a.prototype,new d)}}(),e=r.seriesTypes.mappoint,b=n.extend,v=n.merge;n=function(b){function f(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}
u(f,b);f.prototype.translate=function(){e.prototype.translate.call(this);this.getRadii();this.translateBubble()};f.compose=c.compose;f.defaultOptions=v(c.defaultOptions,{animationLimit:500,tooltip:{pointFormat:"{point.name}: {point.z}"}});return f}(c);b(n.prototype,{type:"mapbubble",axisTypes:["colorAxis"],getProjectedBounds:p.prototype.getProjectedBounds,isCartesian:!1,pointArrayMap:["z"],pointClass:f,setData:p.prototype.setData,setOptions:p.prototype.setOptions,useMapGeometry:!0,xyFromShape:!0});
r.registerSeriesType("mapbubble",n);"";return n});y(c,"Series/Heatmap/HeatmapPoint.js",[c["Core/Series/SeriesRegistry.js"],c["Core/Utilities.js"]],function(c,f){var p=this&&this.__extends||function(){var b=function(c,e){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,a){b.__proto__=a}||function(b,a){for(var c in a)a.hasOwnProperty(c)&&(b[c]=a[c])};return b(c,e)};return function(c,e){function f(){this.constructor=c}b(c,e);c.prototype=null===e?Object.create(e):(f.prototype=e.prototype,
new f)}}(),r=f.clamp,n=f.defined,u=f.extend,e=f.pick;c=function(b){function c(){var c=null!==b&&b.apply(this,arguments)||this;c.options=void 0;c.series=void 0;c.value=void 0;c.x=void 0;c.y=void 0;return c}p(c,b);c.prototype.applyOptions=function(c,e){c=b.prototype.applyOptions.call(this,c,e);c.formatPrefix=c.isNull||null===c.value?"null":"point";return c};c.prototype.getCellAttributes=function(){var b=this.series,c=b.options,a=(c.colsize||1)/2,d=(c.rowsize||1)/2,g=b.xAxis,f=b.yAxis,p=this.options.marker||
b.options.marker;b=b.pointPlacementToXValue();var u=e(this.pointPadding,c.pointPadding,0),q={x1:r(Math.round(g.len-(g.translate(this.x-a,!1,!0,!1,!0,-b)||0)),-g.len,2*g.len),x2:r(Math.round(g.len-(g.translate(this.x+a,!1,!0,!1,!0,-b)||0)),-g.len,2*g.len),y1:r(Math.round(f.translate(this.y-d,!1,!0,!1,!0)||0),-f.len,2*f.len),y2:r(Math.round(f.translate(this.y+d,!1,!0,!1,!0)||0),-f.len,2*f.len)};[["width","x"],["height","y"]].forEach(function(a){var b=a[0];a=a[1];var c=a+"1",d=a+"2",e=Math.abs(q[c]-
q[d]),g=p&&p.lineWidth||0,f=Math.abs(q[c]+q[d])/2;b=p&&p[b];n(b)&&b<e&&(b=b/2+g/2,q[c]=f-b,q[d]=f+b);u&&("y"===a&&(c=d,d=a+"1"),q[c]+=u,q[d]-=u)});return q};c.prototype.haloPath=function(b){if(!b)return[];var c=this.shapeArgs;return["M",c.x-b,c.y-b,"L",c.x-b,c.y+c.height+b,c.x+c.width+b,c.y+c.height+b,c.x+c.width+b,c.y-b,"Z"]};c.prototype.isValid=function(){return Infinity!==this.value&&-Infinity!==this.value};return c}(c.seriesTypes.scatter.prototype.pointClass);u(c.prototype,{dataLabelOnNull:!0,
moveToTopOnHover:!0,ttBelow:!1});return c});y(c,"Series/Heatmap/HeatmapSeries.js",[c["Core/Color/Color.js"],c["Series/ColorMapMixin.js"],c["Series/Heatmap/HeatmapPoint.js"],c["Core/Legend/LegendSymbol.js"],c["Core/Series/SeriesRegistry.js"],c["Core/Renderer/SVG/SVGRenderer.js"],c["Core/Utilities.js"]],function(c,f,p,r,n,u,e){var b=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),v=n.series,m=n.seriesTypes,k=m.column,a=m.scatter,d=u.prototype.symbols,g=e.extend,t=e.fireEvent,x=e.isNumber,y=e.merge,q=e.pick;u=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.colorAxis=void 0;a.data=void 0;a.options=void 0;a.points=void 0;a.valueMax=NaN;a.valueMin=NaN;return a}b(f,e);f.prototype.drawPoints=function(){var a=
this;if((this.options.marker||{}).enabled||this._hasPointMarkers)v.prototype.drawPoints.call(this),this.points.forEach(function(b){b.graphic&&(b.graphic[a.chart.styledMode?"css":"animate"](a.colorAttribs(b)),a.options.borderRadius&&b.graphic.attr({r:a.options.borderRadius}),(b.shapeArgs||{}).r=a.options.borderRadius,(b.shapeArgs||{}).d=b.graphic.pathArray,null===b.value&&b.graphic.addClass("highcharts-null-point"))})};f.prototype.getExtremes=function(){var a=v.prototype.getExtremes.call(this,this.valueData),
b=a.dataMin;a=a.dataMax;x(b)&&(this.valueMin=b);x(a)&&(this.valueMax=a);return v.prototype.getExtremes.call(this)};f.prototype.getValidPoints=function(a,b){return v.prototype.getValidPoints.call(this,a,b,!0)};f.prototype.hasData=function(){return!!this.processedXData.length};f.prototype.init=function(){v.prototype.init.apply(this,arguments);var a=this.options;a.pointRange=q(a.pointRange,a.colsize||1);this.yAxis.axisPointRange=a.rowsize||1;d.ellipse=d.circle};f.prototype.markerAttribs=function(a,b){var c=
a.marker||{},d=this.options.marker||{},e=a.shapeArgs||{},g={};if(a.hasImage)return{x:a.plotX,y:a.plotY};if(b){var f=d.states[b]||{};var h=c.states&&c.states[b]||{};[["width","x"],["height","y"]].forEach(function(a){g[a[0]]=(h[a[0]]||f[a[0]]||e[a[0]])+(h[a[0]+"Plus"]||f[a[0]+"Plus"]||0);g[a[1]]=e[a[1]]+(e[a[0]]-g[a[0]])/2})}return b?g:e};f.prototype.pointAttribs=function(a,b){var d=v.prototype.pointAttribs.call(this,a,b),e=this.options||{},g=this.chart.options.plotOptions||{},f=g.series||{},h=g.heatmap||
{};g=a&&a.options.borderColor||e.borderColor||h.borderColor||f.borderColor;f=a&&a.options.borderWidth||e.borderWidth||h.borderWidth||f.borderWidth||d["stroke-width"];d.stroke=a&&a.marker&&a.marker.lineColor||e.marker&&e.marker.lineColor||g||this.color;d["stroke-width"]=f;b&&(a=y(e.states[b],e.marker&&e.marker.states[b],a&&a.options.states&&a.options.states[b]||{}),b=a.brightness,d.fill=a.color||c.parse(d.fill).brighten(b||0).get(),d.stroke=a.lineColor);return d};f.prototype.setClip=function(a){var b=
this.chart;v.prototype.setClip.apply(this,arguments);(!1!==this.options.clip||a)&&this.markerGroup.clip((a||this.clipBox)&&this.sharedClipKey?b.sharedClips[this.sharedClipKey]:b.clipRect)};f.prototype.translate=function(){var a=this.options,b=a.marker&&a.marker.symbol||"rect",c=d[b]?b:"rect",e=-1!==["circle","square"].indexOf(c);this.generatePoints();this.points.forEach(function(a){var f=a.getCellAttributes(),h={};h.x=Math.min(f.x1,f.x2);h.y=Math.min(f.y1,f.y2);h.width=Math.max(Math.abs(f.x2-f.x1),
0);h.height=Math.max(Math.abs(f.y2-f.y1),0);var k=a.hasImage=0===(a.marker&&a.marker.symbol||b||"").indexOf("url");if(e){var l=Math.abs(h.width-h.height);h.x=Math.min(f.x1,f.x2)+(h.width<h.height?0:l/2);h.y=Math.min(f.y1,f.y2)+(h.width<h.height?l/2:0);h.width=h.height=Math.min(h.width,h.height)}l={plotX:(f.x1+f.x2)/2,plotY:(f.y1+f.y2)/2,clientX:(f.x1+f.x2)/2,shapeType:"path",shapeArgs:y(!0,h,{d:d[c](h.x,h.y,h.width,h.height)})};k&&(a.marker={width:h.width,height:h.height});g(a,l)});t(this,"afterTranslate")};
f.defaultOptions=y(a.defaultOptions,{animation:!1,borderRadius:0,borderWidth:0,nullColor:"#f7f7f7",dataLabels:{formatter:function(){var a=this.series.chart.numberFormatter,b=this.point.value;return x(b)?a(b,-1):""},inside:!0,verticalAlign:"middle",crop:!1,overflow:!1,padding:0},marker:{symbol:"rect",radius:0,lineColor:void 0,states:{hover:{lineWidthPlus:0},select:{}}},clip:!0,pointRange:null,tooltip:{pointFormat:"{point.x}, {point.y}: {point.value}<br/>"},states:{hover:{halo:!1,brightness:.2}}});
return f}(a);g(u.prototype,{alignDataLabel:k.prototype.alignDataLabel,axisTypes:f.SeriesMixin.axisTypes,colorAttribs:f.SeriesMixin.colorAttribs,colorKey:f.SeriesMixin.colorKey,directTouch:!0,drawLegendSymbol:r.drawRectangle,getExtremesFromAll:!0,getSymbol:v.prototype.getSymbol,parallelArrays:f.SeriesMixin.parallelArrays,pointArrayMap:["y","value"],pointClass:p,trackerGroups:f.SeriesMixin.trackerGroups});n.registerSeriesType("heatmap",u);"";"";return u});y(c,"Extensions/GeoJSON.js",[c["Core/Chart/Chart.js"],
c["Core/FormatUtilities.js"],c["Core/Globals.js"],c["Core/Utilities.js"]],function(c,f,p,r){function n(b,a){var c,e=!1,f=b.x,k=b.y;b=0;for(c=a.length-1;b<a.length;c=b++){var m=a[b][1]>k;var q=a[c][1]>k;m!==q&&f<(a[c][0]-a[b][0])*(k-a[b][1])/(a[c][1]-a[b][1])+a[b][0]&&(e=!e)}return e}var u=f.format,e=p.win,b=r.error,v=r.extend,m=r.merge;f=r.wrap;"";c.prototype.transformFromLatLon=function(c,a){var d=this.options.chart.proj4||e.proj4;if(!d)return b(21,!1,this),{x:0,y:null};var f=a.jsonmarginX;f=void 0===
f?0:f;var k=a.jsonmarginY;k=void 0===k?0:k;var m=a.jsonres;m=void 0===m?1:m;var n=a.scale;n=void 0===n?1:n;var q=a.xoffset;q=void 0===q?0:q;var p=a.xpan;p=void 0===p?0:p;var r=a.yoffset;r=void 0===r?0:r;var h=a.ypan;h=void 0===h?0:h;c=d(a.crs,[c.lon,c.lat]);d=a.cosAngle||a.rotation&&Math.cos(a.rotation);var l=a.sinAngle||a.rotation&&Math.sin(a.rotation);a=a.rotation?[c[0]*d+c[1]*l,-c[0]*l+c[1]*d]:c;return{x:((a[0]-q)*n+p)*m+f,y:-(((r-a[1])*n+h)*m-k)}};c.prototype.transformToLatLon=function(c,a){if(!this.options.chart.proj4&&
!e.proj4)b(21,!1,this);else if(null!==c.y){var d=a.jsonmarginX,f=a.jsonmarginY,k=a.jsonres;k=void 0===k?1:k;var m=a.scale;m=void 0===m?1:m;var n=a.xoffset,q=a.xpan,p=a.yoffset,r=a.ypan;c={x:((c.x-(void 0===d?0:d))/k-(void 0===q?0:q))/m+(void 0===n?0:n),y:((c.y-(void 0===f?0:f))/k+(void 0===r?0:r))/m+(void 0===p?0:p)};d=a.cosAngle||a.rotation&&Math.cos(a.rotation);f=a.sinAngle||a.rotation&&Math.sin(a.rotation);a=e.proj4(a.crs,"WGS84",a.rotation?{x:c.x*d+c.y*-f,y:c.x*f+c.y*d}:c);return{lat:a.y,lon:a.x}}};
c.prototype.fromPointToLatLon=function(c){var a=this.mapTransforms;if(a){for(var d in a)if(Object.hasOwnProperty.call(a,d)&&a[d].hitZone&&n(c,a[d].hitZone.coordinates[0]))return this.transformToLatLon(c,a[d]);return this.transformToLatLon(c,a["default"])}b(22,!1,this)};c.prototype.fromLatLonToPoint=function(c){var a=this.mapTransforms,d;if(!a)return b(22,!1,this),{x:0,y:null};for(d in a)if(Object.hasOwnProperty.call(a,d)&&a[d].hitZone){var e=this.transformFromLatLon(c,a[d]);if(n(e,a[d].hitZone.coordinates[0]))return e}return this.transformFromLatLon(c,
a["default"])};p.geojson=function(b,a,c){void 0===a&&(a="map");var d=[];b.features.forEach(function(b){var c=b.geometry||{},e=c.type;c=c.coordinates;b=b.properties;var f;"map"!==a&&"mapbubble"!==a||"Polygon"!==e&&"MultiPolygon"!==e?"mapline"!==a||"LineString"!==e&&"MultiLineString"!==e?"mappoint"===a&&"Point"===e&&c.length&&(f={geometry:{coordinates:c,type:e}}):c.length&&(f={geometry:{coordinates:c,type:e}}):c.length&&(f={geometry:{coordinates:c,type:e}});f&&d.push(v(f,{name:b.name||b.NAME,properties:b}))});
c&&b.copyrightShort&&(c.chart.mapCredits=u(c.chart.options.credits.mapText,{geojson:b}),c.chart.mapCreditsFull=u(c.chart.options.credits.mapTextFull,{geojson:b}));return d};f(c.prototype,"addCredits",function(b,a){a=m(!0,this.options.credits,a);this.mapCredits&&(a.href=null);b.call(this,a);this.credits&&this.mapCreditsFull&&this.credits.attr({title:this.mapCreditsFull})})});y(c,"masters/modules/map.src.js",[c["Core/Globals.js"],c["Core/Axis/Color/ColorAxis.js"],c["Series/MapBubble/MapBubbleSeries.js"],
c["Core/Chart/MapChart.js"]],function(c,f,p,r){c.ColorAxis=f;c.MapChart=r;c.mapChart=c.Map=r.mapChart;c.maps=r.maps;f.compose(c.Chart,c.Fx,c.Legend,c.Series);p.compose(c.Chart,c.Legend,c.Series)})});
//# sourceMappingURL=map.js.map