/*
 Highstock JS v9.3.3 (2022-02-01)

 All technical indicators for Highcharts Stock

 (c) 2010-2021 Pawel Fus

 License: www.highcharts.com/license
*/
'use strict';(function(f){"object"===typeof module&&module.exports?(f["default"]=f,module.exports=f):"function"===typeof define&&define.amd?define("highcharts/indicators/indicators-all",["highcharts","highcharts/modules/stock"],function(v){f(v);f.Highcharts=v;return f}):f("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(f){function v(f,e,h,m){f.hasOwnProperty(e)||(f[e]=m.apply(null,h))}f=f?f._modules:{};v(f,"Stock/Indicators/SMA/SMAComposition.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){});v(f,"Stock/Indicators/SMA/SMAIndicator.js",[f["Core/Chart/Chart.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var c=function(b,a){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var a in b)b.hasOwnProperty(a)&&(c[a]=b[a])};return c(b,a)};return function(b,a){function k(){this.constructor=b}c(b,a);b.prototype=null===a?Object.create(a):
(k.prototype=a.prototype,new k)}}(),l=e.seriesTypes.line,p=h.addEvent,t=h.error,g=h.extend,d=h.isArray,a=h.merge,b=h.pick,c=h.splat;h=function(k){function w(){var c=null!==k&&k.apply(this,arguments)||this;c.data=void 0;c.dataEventsToUnbind=void 0;c.linkedParent=void 0;c.options=void 0;c.points=void 0;return c}m(w,k);w.prototype.destroy=function(){this.dataEventsToUnbind.forEach(function(c){c()});k.prototype.destroy.apply(this,arguments)};w.prototype.getName=function(){var c=this.name,a=[];c||((this.nameComponents||
[]).forEach(function(c,k){a.push(this.options.params[c]+b(this.nameSuffixes[k],""))},this),c=(this.nameBase||this.type.toUpperCase())+(this.nameComponents?" ("+a.join(", ")+")":""));return c};w.prototype.getValues=function(c,b){var a=b.period,k=c.xData;c=c.yData;var w=c.length,x=0,B=0,g=[],e=[],h=[],f=-1;if(!(k.length<a)){for(d(c[0])&&(f=b.index?b.index:0);x<a-1;)B+=0>f?c[x]:c[x][f],x++;for(b=x;b<w;b++){B+=0>f?c[b]:c[b][f];var t=[k[b],B/a];g.push(t);e.push(t[0]);h.push(t[1]);B-=0>f?c[b-x]:c[b-x][f]}return{values:g,
xData:e,yData:h}}};w.prototype.init=function(c,b){var a=this;k.prototype.init.call(a,c,b);b=p(f,"afterLinkSeries",function(){var b=!!a.dataEventsToUnbind.length;if(a.linkedParent)if(b||(a.dataEventsToUnbind.push(p(a.linkedParent,"updatedData",function(){a.recalculateValues()})),a.calculateOn.xAxis&&a.dataEventsToUnbind.push(p(a.linkedParent.xAxis,a.calculateOn.xAxis,function(){a.recalculateValues()}))),"init"===a.calculateOn.chart)a.processedYData||a.recalculateValues();else{if(!b)var k=p(a.chart,
a.calculateOn.chart,function(){a.recalculateValues();k()})}else return t("Series "+a.options.linkedTo+" not found! Check `linkedTo`.",!1,c)},{order:0});a.dataEventsToUnbind=[];a.eventsToUnbind.push(b)};w.prototype.recalculateValues=function(){var a=this.points||[],b=(this.xData||[]).length,k=this.getValues(this.linkedParent,this.options.params)||{values:[],xData:[],yData:[]},d=[],w=!0;if(b&&!this.hasGroupedData&&this.visible&&this.points)if(this.cropped){if(this.xAxis){var n=this.xAxis.min;var g=
this.xAxis.max}b=this.cropData(k.xData,k.yData,n,g);for(n=0;n<b.xData.length;n++)d.push([b.xData[n]].concat(c(b.yData[n])));b=k.xData.indexOf(this.xData[0]);n=k.xData.indexOf(this.xData[this.xData.length-1]);-1===b&&n===k.xData.length-2&&d[0][0]===a[0].x&&d.shift();this.updateData(d)}else k.xData.length!==b-1&&k.xData.length!==b+1&&(w=!1,this.updateData(k.values));w&&(this.xData=k.xData,this.yData=k.yData,this.options.data=k.values);this.calculateOn.xAxis&&this.processedXData&&(delete this.processedXData,
this.isDirty=!0,this.redraw());this.isDirtyData=!1};w.prototype.processData=function(){var c=this.options.compareToMain,b=this.linkedParent;k.prototype.processData.apply(this,arguments);this.dataModify&&b&&b.dataModify&&b.dataModify.compareValue&&c&&(this.dataModify.compareValue=b.dataModify.compareValue)};w.defaultOptions=a(l.defaultOptions,{name:void 0,tooltip:{valueDecimals:4},linkedTo:void 0,compareToMain:!1,params:{index:3,period:14}});return w}(l);g(h.prototype,{calculateOn:{chart:"init"},hasDerivedData:!0,
nameComponents:["period"],nameSuffixes:[],useCommonDataGrouping:!0});e.registerSeriesType("sma",h);"";return h});v(f,"Stock/Indicators/EMA/EMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var g=function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var a in c)c.hasOwnProperty(a)&&(b[a]=c[a])};return g(d,a)};return function(d,a){function b(){this.constructor=
d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.correctFloat,p=e.isArray,t=e.merge;e=function(g){function d(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(d,g);d.prototype.accumulatePeriodPoints=function(a,b,c){for(var k=0,d=0,x;d<a;)x=0>b?c[d]:c[d][b],k+=x,d++;return k};d.prototype.calculateEma=function(a,b,c,k,d,x,g){a=a[c-1];b=0>x?b[c-1]:b[c-1][x];k="undefined"===typeof d?g:l(b*
k+d*(1-k));return[a,k]};d.prototype.getValues=function(a,b){var c=b.period,k=a.xData,d=(a=a.yData)?a.length:0,x=2/(c+1),g=[],e=[],h=[],r=-1;if(!(d<c)){p(a[0])&&(r=b.index?b.index:0);b=this.accumulatePeriodPoints(c,r,a);for(b/=c;c<d+1;c++){var n=this.calculateEma(k,a,c,x,n,r,b);g.push(n);e.push(n[0]);h.push(n[1]);n=n[1]}return{values:g,xData:e,yData:h}}};d.defaultOptions=t(m.defaultOptions,{params:{index:3,period:9}});return d}(m);f.registerSeriesType("ema",e);"";return e});v(f,"Stock/Indicators/AD/ADIndicator.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var g=function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(b,c){b.__proto__=c}||function(b,c){for(var a in c)c.hasOwnProperty(a)&&(b[a]=c[a])};return g(d,a)};return function(d,a){function b(){this.constructor=d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.error,p=e.extend,t=e.merge;e=function(g){function d(){var a=
null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(d,g);d.populateAverage=function(a,b,c,k,d){d=b[k][1];var w=b[k][2];b=b[k][3];c=c[k];return[a[k],b===d&&b===w||d===w?0:(2*b-w-d)/(d-w)*c]};d.prototype.getValues=function(a,b){var c=b.period,k=a.xData,w=a.yData,x=b.volumeSeriesID,g=a.chart.get(x);b=g&&g.yData;var e=w?w.length:0,h=[],r=[],n=[];if(!(k.length<=c&&e&&4!==w[0].length)){if(g){for(x=c;x<e;x++)a=h.length,g=d.populateAverage(k,w,b,x,c),0<a&&(g[1]+=
h[a-1][1]),h.push(g),r.push(g[0]),n.push(g[1]);return{values:h,xData:r,yData:n}}l("Series "+x+" not found! Check `volumeSeriesID`.",!0,a.chart)}};d.defaultOptions=t(m.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return d}(m);p(e.prototype,{nameComponents:!1,nameBase:"Accumulation/Distribution"});f.registerSeriesType("ad",e);"";return e});v(f,"Stock/Indicators/AO/AOIndicator.js",[f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=
this&&this.__extends||function(){var b=function(c,a){b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,a){c.__proto__=a}||function(c,a){for(var b in a)a.hasOwnProperty(b)&&(c[b]=a[b])};return b(c,a)};return function(c,a){function k(){this.constructor=c}b(c,a);c.prototype=null===a?Object.create(a):(k.prototype=a.prototype,new k)}}();f=f.noop;var l=e.seriesTypes,p=l.sma;l=l.column;var t=h.extend,g=h.merge,d=h.correctFloat,a=h.isArray;h=function(b){function c(){var c=null!==b&&b.apply(this,
arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}m(c,b);c.prototype.drawGraph=function(){var c=this.options,a=this.points,b=c.greaterBarColor;c=c.lowerBarColor;var d=a[0];if(!this.userOptions.color&&d)for(d.color=b,d=1;d<a.length;d++)a[d].color=a[d].y>a[d-1].y?b:a[d].y<a[d-1].y?c:a[d-1].color};c.prototype.getValues=function(c){var b=c.xData||[];c=c.yData||[];var k=c.length,g=[],e=[],h=[],r=0,n=0,A;if(!(34>=b.length)&&a(c[0])&&4===c[0].length){for(A=0;33>A;A++){var q=(c[A][1]+
c[A][2])/2;29<=A&&(r=d(r+q));n=d(n+q)}for(A=33;A<k;A++){q=(c[A][1]+c[A][2])/2;r=d(r+q);n=d(n+q);q=r/5;var u=n/34;q=d(q-u);g.push([b[A],q]);e.push(b[A]);h.push(q);q=A+1-5;u=A+1-34;r=d(r-(c[q][1]+c[q][2])/2);n=d(n-(c[u][1]+c[u][2])/2)}return{values:g,xData:e,yData:h}}};c.defaultOptions=g(p.defaultOptions,{params:{index:void 0,period:void 0},greaterBarColor:"#06b535",lowerBarColor:"#f21313",threshold:0,groupPadding:.2,pointPadding:.2,crisp:!1,states:{hover:{halo:{size:0}}}});return c}(p);t(h.prototype,
{nameBase:"AO",nameComponents:!1,markerAttribs:f,getColumnMetrics:l.prototype.getColumnMetrics,crispCol:l.prototype.crispCol,translate:l.prototype.translate,drawPoints:l.prototype.drawPoints});e.registerSeriesType("ao",h);"";return h});v(f,"Stock/Indicators/MultipleLinesComposition.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=f.seriesTypes.sma,m=e.defined,l=e.error,p=e.merge,t;(function(g){function d(c){var a,b=[];c=c||this.points;if(this.fillGraph&&this.nextPoints){if((a=
h.prototype.getGraphPath.call(this,this.nextPoints))&&a.length){a[0][0]="L";b=h.prototype.getGraphPath.call(this,c);a=a.slice(0,b.length);for(var k=a.length-1;0<=k;k--)b.push(a[k])}}else b=h.prototype.getGraphPath.apply(this,arguments);return b}function a(){var a=this,b=a.linesApiNames,k=a.areaLinesNames,d=a.points,w=a.options,g=a.graph,x={options:{gapSize:w.gapSize}},e=[],B=a.getTranslatedLinesNames(a.pointValKey),z=d.length,L;B.forEach(function(a,c){for(e[c]=[];z--;)L=d[z],e[c].push({x:L.x,plotX:L.plotX,
plotY:L[a],isNull:!m(L[a])});z=d.length});if(this.userOptions.fillColor&&k.length){var t=B.indexOf(c(k[0]));t=e[t];k=1===k.length?d:e[B.indexOf(c(k[1]))];B=a.color;a.points=k;a.nextPoints=t;a.color=this.userOptions.fillColor;a.options=p(d,x);a.graph=a.area;a.fillGraph=!0;f.seriesTypes.sma.prototype.drawGraph.call(a);a.area=a.graph;delete a.nextPoints;delete a.fillGraph;a.color=B}b.forEach(function(c,b){e[b]?(a.points=e[b],w[c]?a.options=p(w[c].styles,x):l('Error: "There is no '+c+' in DOCS options declared. Check if linesApiNames are consistent with your DOCS line names." at mixin/multiple-line.js:34'),
a.graph=a["graph"+c],h.prototype.drawGraph.call(a),a["graph"+c]=a.graph):l('Error: "'+c+" doesn't have equivalent in pointArrayMap. To many elements in linesApiNames relative to pointArrayMap.\"")});a.points=d;a.options=w;a.graph=g;h.prototype.drawGraph.call(a)}function b(a){var b=[];(this.pointArrayMap||[]).forEach(function(k){k!==a&&b.push(c(k))});return b}function c(a){return"plot"+a.charAt(0).toUpperCase()+a.slice(1)}function k(a){var c=[];(this.pointArrayMap||[]).forEach(function(b){c.push(a[b])});
return c}function w(){var a=this,c=a.pointArrayMap,b=[],k;b=a.getTranslatedLinesNames();h.prototype.translate.apply(a,arguments);a.points.forEach(function(d){c.forEach(function(c,w){k=d[c];a.dataModify&&(k=a.dataModify.modifyValue(k));null!==k&&(d[b[w]]=a.yAxis.toPixels(k,!0))})})}var x=[],e=["bottomLine"],z=["top","bottom"],L=["top"];g.compose=function(c){if(-1===x.indexOf(c)){x.push(c);var g=c.prototype;g.linesApiNames=g.linesApiNames||e.slice();g.pointArrayMap=g.pointArrayMap||z.slice();g.pointValKey=
g.pointValKey||"top";g.areaLinesNames=g.areaLinesNames||L.slice();g.drawGraph=a;g.getGraphPath=d;g.toYData=k;g.translate=w;g.getTranslatedLinesNames=b}return c}})(t||(t={}));return t});v(f,"Stock/Indicators/Aroon/AroonIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){function m(a,b){var c=a[0],k=0,d;for(d=1;d<a.length;d++)if("max"===b&&a[d]>=c||"min"===b&&a[d]<=c)c=a[d],k=d;return k}var l=this&&this.__extends||
function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function k(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),p=e.seriesTypes.sma,t=h.extend,g=h.merge,d=h.pick;h=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.data=void 0;c.options=void 0;c.points=void 0;return c}
l(b,a);b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,k=(a=a.yData)?a.length:0,g=[],e=[],h=[],r;for(r=b-1;r<k;r++){var n=a.slice(r-b+1,r+2);var A=m(n.map(function(a){return d(a[2],a)}),"min");n=m(n.map(function(a){return d(a[1],a)}),"max");n=n/b*100;A=A/b*100;c[r+1]&&(g.push([c[r+1],n,A]),e.push(c[r+1]),h.push([n,A]))}return{values:g,xData:e,yData:h}};b.defaultOptions=g(p.defaultOptions,{params:{index:void 0,period:25},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Aroon Up: {point.y}<br/>Aroon Down: {point.aroonDown}<br/>'},
aroonDown:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return b}(p);t(h.prototype,{areaLinesNames:[],linesApiNames:["aroonDown"],nameBase:"Aroon",pointArrayMap:["y","aroonDown"],pointValKey:"y"});f.compose(h);e.registerSeriesType("aroon",h);"";return h});v(f,"Stock/Indicators/AroonOscillator/AroonOscillatorIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||
function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=e.seriesTypes.aroon,p=h.extend,t=h.merge,g=e.seriesTypes.aroon;h=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=
void 0;return a}m(a,d);a.prototype.getValues=function(a,c){var b=[],d=[],x=[];a=g.prototype.getValues.call(this,a,c);for(c=0;c<a.yData.length;c++){var e=a.yData[c][0];var z=a.yData[c][1];e-=z;b.push([a.xData[c],e]);d.push(a.xData[c]);x.push(e)}return{values:b,xData:d,yData:x}};a.defaultOptions=t(l.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b>: {point.y}'}});return a}(l);p(h.prototype,{nameBase:"Aroon Oscillator",linesApiNames:[],pointArrayMap:["y"],
pointValKey:"y"});f.compose(l);e.registerSeriesType("aroonoscillator",h);"";return h});v(f,"Stock/Indicators/ATR/ATRIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function h(g,d){return Math.max(g[1]-g[2],"undefined"===typeof d?0:Math.abs(g[1]-d[3]),"undefined"===typeof d?0:Math.abs(g[2]-d[3]))}var m=this&&this.__extends||function(){var g=function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&
(a[b]=c[b])};return g(d,a)};return function(d,a){function b(){this.constructor=d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),l=f.seriesTypes.sma,p=e.isArray,t=e.merge;e=function(g){function d(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}m(d,g);d.prototype.getValues=function(a,b){b=b.period;var c=a.xData,k=(a=a.yData)?a.length:0,d=1,g=0,e=0,z=[],f=[],r=[],n;var A=[[c[0],a[0]]];if(!(c.length<=b)&&p(a[0])&&
4===a[0].length){for(n=1;n<=k;n++)if(A.push([c[n],a[n]]),b<d){var q=b;var u=c[n-1],t=h(a[n-1],a[n-2]);q=[u,(g*(q-1)+t)/q];g=q[1];z.push(q);f.push(q[0]);r.push(q[1])}else b===d?(g=e/(n-1),z.push([c[n-1],g]),f.push(c[n-1]),r.push(g)):e+=h(a[n-1],a[n-2]),d++;return{values:z,xData:f,yData:r}}};d.defaultOptions=t(l.defaultOptions,{params:{index:void 0}});return d}(l);f.registerSeriesType("atr",e);"";return e});v(f,"Stock/Indicators/BB/BBIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],
f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=e.seriesTypes.sma,p=h.extend,t=h.isArray,g=h.merge;h=function(d){function a(){var a=
null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,d);a.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=g({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};a.prototype.getValues=function(a,c){var b=c.period,d=c.standardDeviation,g=a.xData,B=(a=a.yData)?a.length:0,z=[],f=[],r=[],n;if(!(g.length<b)){var A=t(a[0]);for(n=b;n<=B;n++){var q=g.slice(n-b,n);var u=
a.slice(n-b,n);var h=e.seriesTypes.sma.prototype.getValues.call(this,{xData:q,yData:u},c);q=h.xData[0];h=h.yData[0];for(var m=0,l=u.length,p=0;p<l;p++){var y=(A?u[p][c.index]:u[p])-h;m+=y*y}y=Math.sqrt(m/(l-1));u=h+d*y;y=h-d*y;z.push([q,u,h,y]);f.push(q);r.push([u,h,y])}return{values:z,xData:f,yData:r}}};a.defaultOptions=g(l.defaultOptions,{params:{period:20,standardDeviation:2,index:3},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return a}(l);p(h.prototype,{areaLinesNames:["top","bottom"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle",nameComponents:["period","standardDeviation"],linesApiNames:["topLine","bottomLine"]});f.compose(h);e.registerSeriesType("bb",h);"";return h});v(f,"Stock/Indicators/CCI/CCIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function h(g){return g.reduce(function(d,a){return d+a},0)}
var m=this&&this.__extends||function(){var g=function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return g(d,a)};return function(d,a){function b(){this.constructor=d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),l=f.seriesTypes.sma,p=e.isArray,t=e.merge;e=function(g){function d(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.points=void 0;
a.options=void 0;return a}m(d,g);d.prototype.getValues=function(a,b){b=b.period;var c=a.xData,k=(a=a.yData)?a.length:0,d=[],g=1,e=[],z=[],f=[];if(!(c.length<=b)&&p(a[0])&&4===a[0].length){for(;g<b;){var r=a[g-1];d.push((r[1]+r[2]+r[3])/3);g++}for(g=b;g<=k;g++){r=a[g-1];r=(r[1]+r[2]+r[3])/3;var n=d.push(r);var A=d.slice(n-b);n=h(A)/b;var q,u=A.length,t=0;for(q=0;q<u;q++)t+=Math.abs(n-A[q]);A=t/b;r=(r-n)/(.015*A);e.push([c[g-1],r]);z.push(c[g-1]);f.push(r)}return{values:e,xData:z,yData:f}}};d.defaultOptions=
t(l.defaultOptions,{params:{index:void 0}});return d}(l);f.registerSeriesType("cci",e);"";return e});v(f,"Stock/Indicators/CMF/CMFIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(f,g){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)a.hasOwnProperty(b)&&(d[b]=a[b])};return e(f,g)};return function(f,g){function d(){this.constructor=f}e(f,g);
f.prototype=null===g?Object.create(g):(d.prototype=g.prototype,new d)}}(),m=f.seriesTypes.sma,l=e.merge;e=function(e){function f(){var g=null!==e&&e.apply(this,arguments)||this;g.data=void 0;g.options=void 0;g.points=void 0;g.volumeSeries=void 0;g.linkedParent=void 0;g.yData=void 0;g.nameBase="Chaikin Money Flow";return g}h(f,e);f.prototype.isValid=function(){var g=this.chart,d=this.options,a=this.linkedParent;g=this.volumeSeries||(this.volumeSeries=g.get(d.params.volumeSeriesID));var b=a&&a.yData&&
4===a.yData[0].length;return!!(a&&g&&a.xData&&a.xData.length>=d.params.period&&g.xData&&g.xData.length>=d.params.period&&b)};f.prototype.getValues=function(g,d){if(this.isValid())return this.getMoneyFlow(g.xData,g.yData,this.volumeSeries.yData,d.period)};f.prototype.getMoneyFlow=function(g,d,a,b){function c(a,c){var b=a[1],k=a[2];a=a[3];return null!==c&&null!==b&&null!==k&&null!==a&&b!==k?(a-k-(b-a))/(b-k)*c:(A=n,null)}var k=d.length,w=[],e=0,B=0,z=[],f=[],r=[],n,A=-1;if(0<b&&b<=k){for(n=0;n<b;n++)w[n]=
c(d[n],a[n]),e+=a[n],B+=w[n];z.push(g[n-1]);f.push(n-A>=b&&0!==e?B/e:null);for(r.push([z[0],f[0]]);n<k;n++){w[n]=c(d[n],a[n]);e-=a[n-b];e+=a[n];B-=w[n-b];B+=w[n];var q=[g[n],n-A>=b?B/e:null];z.push(q[0]);f.push(q[1]);r.push([q[0],q[1]])}}return{values:r,xData:z,yData:f}};f.defaultOptions=l(m.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume"}});return f}(m);f.registerSeriesType("cmf",e);"";return e});v(f,"Stock/Indicators/DMI/DMIIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],
f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return a(b,c)};return function(b,c){function k(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),l=e.seriesTypes.sma,p=h.correctFloat,t=h.extend,g=h.isArray,d=h.merge;
h=function(a){function b(){var c=null!==a&&a.apply(this,arguments)||this;c.options=void 0;return c}m(b,a);b.prototype.calculateDM=function(a,b,d){var c=a[b][1],k=a[b][2],w=a[b-1][1];a=a[b-1][2];return p(c-w>a-k?d?Math.max(c-w,0):0:d?0:Math.max(a-k,0))};b.prototype.calculateDI=function(a,b){return a/b*100};b.prototype.calculateDX=function(a,b){return p(Math.abs(a-b)/Math.abs(a+b)*100)};b.prototype.smoothValues=function(a,b,d){return p(a-a/d+b)};b.prototype.getTR=function(a,b){return p(Math.max(a[1]-
a[2],b?Math.abs(a[1]-b[3]):0,b?Math.abs(a[2]-b[3]):0))};b.prototype.getValues=function(a,b){b=b.period;var c=a.xData,k=(a=a.yData)?a.length:0,d=[],e=[],f=[];if(!(c.length<=b)&&g(a[0])&&4===a[0].length){var r=0,n=0,A=0,q;for(q=1;q<k;q++)if(q<=b){var u=this.calculateDM(a,q,!0);var h=this.calculateDM(a,q);var m=this.getTR(a[q],a[q-1]);r+=u;n+=h;A+=m;q===b&&(m=this.calculateDI(r,A),h=this.calculateDI(n,A),u=this.calculateDX(r,n),d.push([c[q],u,m,h]),e.push(c[q]),f.push([u,m,h]))}else u=this.calculateDM(a,
q,!0),h=this.calculateDM(a,q),m=this.getTR(a[q],a[q-1]),r=this.smoothValues(r,u,b),n=this.smoothValues(n,h,b),A=this.smoothValues(A,m,b),m=this.calculateDI(r,A),h=this.calculateDI(n,A),u=this.calculateDX(r,n),d.push([c[q],u,m,h]),e.push(c[q]),f.push([u,m,h]);return{values:d,xData:e,yData:f}}};b.defaultOptions=d(l.defaultOptions,{params:{index:void 0},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">DX</span>: {point.y}<br/><span style="color: {point.series.options.plusDILine.styles.lineColor}">+DI</span>: {point.plusDI}<br/><span style="color: {point.series.options.minusDILine.styles.lineColor}">-DI</span>: {point.minusDI}<br/>'},
plusDILine:{styles:{lineWidth:1,lineColor:"#06b535"}},minusDILine:{styles:{lineWidth:1,lineColor:"#f21313"}},dataGrouping:{approximation:"averages"}});return b}(l);t(h.prototype,{areaLinesNames:[],nameBase:"DMI",linesApiNames:["plusDILine","minusDILine"],pointArrayMap:["y","plusDI","minusDI"],parallelArrays:["x","y","plusDI","minusDI"],pointValKey:"y"});f.compose(h);e.registerSeriesType("dmi",h);"";return h});v(f,"Stock/Indicators/DPO/DPOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],
function(f,e){function h(a,b,c,k,w){b=d(b[c][k],b[c]);return w?g(a-b):g(a+b)}var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function k(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),l=f.seriesTypes.sma,p=e.extend,t=e.merge,g=e.correctFloat,d=e.pick;
e=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.options=void 0;b.data=void 0;b.points=void 0;return b}m(b,a);b.prototype.getValues=function(a,b){var c=b.period;b=b.index;var k=c+Math.floor(c/2+1),g=a.xData||[];a=a.yData||[];var e=a.length,f=[],r=[],n=[],A=0,q,u;if(!(g.length<=k)){for(q=0;q<c-1;q++)A=h(A,a,q,b);for(u=0;u<=e-k;u++){var m=u+c-1;q=u+k-1;A=h(A,a,m,b);m=d(a[q][b],a[q]);m-=A/c;A=h(A,a,u,b,!0);f.push([g[q],m]);r.push(g[q]);n.push(m)}return{values:f,xData:r,yData:n}}};
b.defaultOptions=t(l.defaultOptions,{params:{index:0,period:21}});return b}(l);p(e.prototype,{nameBase:"DPO"});f.registerSeriesType("dpo",e);"";return e});v(f,"Stock/Indicators/Chaikin/ChaikinIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};
return function(b,c){function k(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),m=f.seriesTypes,l=m.ad,p=m.ema,t=e.correctFloat;m=e.extend;var g=e.merge,d=e.error;e=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}h(b,a);b.prototype.getValues=function(a,b){var c=b.periods,k=b.period,g=[],e=[],f=[],r;if(2!==c.length||c[1]<=c[0])d('Error: "Chaikin requires two periods. Notice, first period should be lower than the second one."');
else if(b=l.prototype.getValues.call(this,a,{volumeSeriesID:b.volumeSeriesID,period:k}))if(a=p.prototype.getValues.call(this,b,{period:c[0]}),b=p.prototype.getValues.call(this,b,{period:c[1]}),a&&b){c=c[1]-c[0];for(r=0;r<b.yData.length;r++)k=t(a.yData[r+c]-b.yData[r]),g.push([b.xData[r],k]),e.push(b.xData[r]),f.push(k);return{values:g,xData:e,yData:f}}};b.defaultOptions=g(p.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",period:9,periods:[3,10]}});return b}(p);m(e.prototype,{nameBase:"Chaikin Osc",
nameComponents:["periods"]});f.registerSeriesType("chaikin",e);"";return e});v(f,"Stock/Indicators/CMO/CMOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(g,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(g,d)};return function(g,d){function a(){this.constructor=g}e(g,d);g.prototype=null===d?Object.create(d):
(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,l=e.isNumber,p=e.merge;e=function(e){function g(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}h(g,e);g.prototype.getValues=function(d,a){var b=a.period,c=d.xData,k=d.yData;d=k?k.length:0;var g=[],e=[],f=[],z,h=a.index;if(!(c.length<b)){l(k[0])?a=k:(h=Math.min(h,k[0].length-1),a=k.map(function(a){return a[h]}));var r=0,n=k=0;for(z=b;0<z;z--)a[z]>a[z-1]?k+=a[z]-a[z-1]:a[z]<a[z-1]&&(n+=a[z-
1]-a[z]);r=0<k+n?100*(k-n)/(k+n):0;e.push(c[b]);f.push(r);g.push([c[b],r]);for(z=b+1;z<d;z++)r=Math.abs(a[z-b-1]-a[z-b]),a[z]>a[z-1]?k+=a[z]-a[z-1]:a[z]<a[z-1]&&(n+=a[z-1]-a[z]),a[z-b]>a[z-b-1]?k-=r:n-=r,r=0<k+n?100*(k-n)/(k+n):0,e.push(c[z]),f.push(r),g.push([c[z],r]);return{values:g,xData:e,yData:f}}};g.defaultOptions=p(m.defaultOptions,{params:{period:20,index:3}});return g}(m);f.registerSeriesType("cmo",e);"";return e});v(f,"Stock/Indicators/DEMA/DEMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var g=function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return g(d,a)};return function(d,a){function b(){this.constructor=d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.ema,l=e.correctFloat,p=e.isArray,t=e.merge;e=function(g){function d(){var a=null!==g&&g.apply(this,
arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(d,g);d.prototype.getEMA=function(a,b,c,k,d,g){return m.prototype.calculateEma(g||[],a,"undefined"===typeof d?1:d,this.EMApercent,b,"undefined"===typeof k?-1:k,c)};d.prototype.getValues=function(a,b){var c=b.period,k=2*c,d=a.xData,g=(a=a.yData)?a.length:0,e=-1,f=[],h=[],r=[],n=0,A=[],q;this.EMApercent=2/(c+1);if(!(g<2*c-1)){p(a[0])&&(e=b.index?b.index:0);b=m.prototype.accumulatePeriodPoints(c,e,a);var u=
b/c;b=0;for(q=c;q<g+2;q++){q<g+1&&(n=this.getEMA(a,t,u,e,q)[1],A.push(n));var t=n;if(q<k)b+=n;else{q===k&&(u=b/c);n=A[q-c-1];var J=this.getEMA([n],J,u)[1];var y=[d[q-2],l(2*n-J)];f.push(y);h.push(y[0]);r.push(y[1])}}return{values:f,xData:h,yData:r}}};d.defaultOptions=t(m.defaultOptions);return d}(m);f.registerSeriesType("dema",e);"";return e});v(f,"Stock/Indicators/TEMA/TEMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var g=
function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return g(d,a)};return function(d,a){function b(){this.constructor=d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.ema,l=e.correctFloat,p=e.isArray,t=e.merge;e=function(g){function d(){var a=null!==g&&g.apply(this,arguments)||this;a.EMApercent=void 0;a.data=void 0;a.options=void 0;a.points=
void 0;return a}h(d,g);d.prototype.getEMA=function(a,b,c,k,d,g){return m.prototype.calculateEma(g||[],a,"undefined"===typeof d?1:d,this.EMApercent,b,"undefined"===typeof k?-1:k,c)};d.prototype.getTemaPoint=function(a,b,c,k){return[a[k-3],l(3*c.level1-3*c.level2+c.level3)]};d.prototype.getValues=function(a,b){var c=b.period,k=2*c,d=3*c,g=a.xData,e=(a=a.yData)?a.length:0,f=-1,h=[],r=[],n=[],A=[],q=[],u,t,l={};this.EMApercent=2/(c+1);if(!(e<3*c-2)){p(a[0])&&(f=b.index?b.index:0);b=m.prototype.accumulatePeriodPoints(c,
f,a);var y=b/c;b=0;for(u=c;u<e+3;u++){u<e+1&&(l.level1=this.getEMA(a,F,y,f,u)[1],A.push(l.level1));var F=l.level1;if(u<k)b+=l.level1;else{u===k&&(y=b/c,b=0);l.level1=A[u-c-1];l.level2=this.getEMA([l.level1],Q,y)[1];q.push(l.level2);var Q=l.level2;if(u<d)b+=l.level2;else{u===d&&(y=b/c);u===e+1&&(l.level1=A[u-c-1],l.level2=this.getEMA([l.level1],Q,y)[1],q.push(l.level2));l.level1=A[u-c-2];l.level2=q[u-2*c-1];l.level3=this.getEMA([l.level2],l.prevLevel3,y)[1];if(t=this.getTemaPoint(g,d,l,u))h.push(t),
r.push(t[0]),n.push(t[1]);l.prevLevel3=l.level3}}}return{values:h,xData:r,yData:n}}};d.defaultOptions=t(m.defaultOptions);return d}(m);f.registerSeriesType("tema",e);"";return e});v(f,"Stock/Indicators/TRIX/TRIXIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(g,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=
b[c])};return e(g,d)};return function(g,d){function a(){this.constructor=g}e(g,d);g.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.tema,l=e.correctFloat,p=e.merge;e=function(e){function g(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}h(g,e);g.prototype.getTemaPoint=function(d,a,b,c){if(c>a)return[d[c-3],0!==b.prevLevel3?l(b.level3-b.prevLevel3)/b.prevLevel3*100:null]};g.defaultOptions=p(m.defaultOptions);
return g}(m);f.registerSeriesType("trix",e);"";return e});v(f,"Stock/Indicators/APO/APOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var g=function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return g(d,a)};return function(d,a){function b(){this.constructor=d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=
a.prototype,new b)}}(),m=f.seriesTypes.ema,l=e.extend,p=e.merge,t=e.error;e=function(g){function d(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(d,g);d.prototype.getValues=function(a,b){var c=b.periods,k=b.index;b=[];var d=[],g=[],e;if(2!==c.length||c[1]<=c[0])t('Error: "APO requires two periods. Notice, first period should be lower than the second one."');else{var f=m.prototype.getValues.call(this,a,{index:k,period:c[0]});a=m.prototype.getValues.call(this,
a,{index:k,period:c[1]});if(f&&a){c=c[1]-c[0];for(e=0;e<a.yData.length;e++)k=f.yData[e+c]-a.yData[e],b.push([a.xData[e],k]),d.push(a.xData[e]),g.push(k);return{values:b,xData:d,yData:g}}}};d.defaultOptions=p(m.defaultOptions,{params:{period:void 0,periods:[10,20]}});return d}(m);l(e.prototype,{nameBase:"APO",nameComponents:["periods"]});f.registerSeriesType("apo",e);"";return e});v(f,"Stock/Indicators/IKH/IKHIndicator.js",[f["Core/Color/Color.js"],f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e,h,m){function l(a){return a.reduce(function(a,b){return Math.max(a,b[1])},-Infinity)}function p(a){return a.reduce(function(a,b){return Math.min(a,b[2])},Infinity)}function t(a){return{high:l(a),low:p(a)}}function g(a){var b,c,k,d,g;a.series.forEach(function(a){if(a.xData)for(d=a.xData,g=c=a.xIncrement?1:d.length-1;0<g;g--)if(k=d[g]-d[g-1],"undefined"===typeof b||k<b)b=k});return b}function d(a,b,c,k){if(a&&b&&c&&k){var d=b.plotX-a.plotX;b=b.plotY-a.plotY;var g=
k.plotX-c.plotX;k=k.plotY-c.plotY;var e=a.plotX-c.plotX,w=a.plotY-c.plotY;c=(-b*e+d*w)/(-g*b+d*k);g=(g*w-k*e)/(-g*b+d*k);if(0<=c&&1>=c&&0<=g&&1>=g)return{plotX:a.plotX+g*d,plotY:a.plotY+g*b}}return!1}function a(a){var b=a.indicator;b.points=a.points;b.nextPoints=a.nextPoints;b.color=a.color;b.options=z(a.options.senkouSpan.styles,a.gap);b.graph=a.graph;b.fillGraph=!0;h.seriesTypes.sma.prototype.drawGraph.call(b)}var b=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function k(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),c=f.parse,k=h.seriesTypes.sma,w=m.defined;f=m.extend;var x=m.isArray,B=m.isNumber,z=m.merge,L=m.objectEach;e.approximations["ichimoku-averages"]=function(){var a=[],b;[].forEach.call(arguments,function(c,k){a.push(e.approximations.average(c));b=!b&&"undefined"===
typeof a[k]});return b?void 0:a};m=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.graphCollection=void 0;a.graphsenkouSpan=void 0;a.ikhMap=void 0;a.nextPoints=void 0;return a}b(f,e);f.prototype.init=function(){h.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=z({tenkanLine:{styles:{lineColor:this.color}},kijunLine:{styles:{lineColor:this.color}},chikouLine:{styles:{lineColor:this.color}},senkouSpanA:{styles:{lineColor:this.color,
fill:c(this.color).setOpacity(.5).get()}},senkouSpanB:{styles:{lineColor:this.color,fill:c(this.color).setOpacity(.5).get()}},senkouSpan:{styles:{fill:c(this.color).setOpacity(.2).get()}}},this.options)};f.prototype.toYData=function(a){return[a.tenkanSen,a.kijunSen,a.chikouSpan,a.senkouSpanA,a.senkouSpanB]};f.prototype.translate=function(){var a=this;h.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){var k=b[c];B(k)&&(b["plot"+c]=a.yAxis.toPixels(k,
!0),b.plotY=b["plot"+c],b.tooltipPos=[b.plotX,b["plot"+c]],b.isNull=!1)})})};f.prototype.drawGraph=function(){var b=this,c=b.points,k=c.length,g=b.options,e=b.graph,f=b.color,x={options:{gapSize:g.gapSize}},n=b.pointArrayMap.length,r=[[],[],[],[],[],[]],B={tenkanLine:r[0],kijunLine:r[1],chikouLine:r[2],senkouSpanA:r[3],senkouSpanB:r[4],senkouSpan:r[5]},m=[],l=b.options.senkouSpan,t=l.color||l.styles.fill,p=l.negativeColor,y=[[],[]],v=[[],[]],R=0,K,S,O;for(b.ikhMap=B;k--;){var D=c[k];for(K=0;K<n;K++)l=
b.pointArrayMap[K],w(D[l])&&r[K].push({plotX:D.plotX,plotY:D["plot"+l],isNull:!1});p&&k!==c.length-1&&(l=B.senkouSpanB.length-1,D=d(B.senkouSpanA[l-1],B.senkouSpanA[l],B.senkouSpanB[l-1],B.senkouSpanB[l]),K={plotX:D.plotX,plotY:D.plotY,isNull:!1,intersectPoint:!0},D&&(B.senkouSpanA.splice(l,0,K),B.senkouSpanB.splice(l,0,K),m.push(l)))}L(B,function(a,c){g[c]&&"senkouSpan"!==c&&(b.points=r[R],b.options=z(g[c].styles,x),b.graph=b["graph"+c],b.fillGraph=!1,b.color=f,h.seriesTypes.sma.prototype.drawGraph.call(b),
b["graph"+c]=b.graph);R++});b.graphCollection&&b.graphCollection.forEach(function(a){b[a].destroy();delete b[a]});b.graphCollection=[];if(p&&B.senkouSpanA[0]&&B.senkouSpanB[0]){m.unshift(0);m.push(B.senkouSpanA.length-1);for(n=0;n<m.length-1;n++){l=m[n];D=m[n+1];k=B.senkouSpanB.slice(l,D+1);l=B.senkouSpanA.slice(l,D+1);if(1<=Math.floor(k.length/2))if(D=Math.floor(k.length/2),k[D].plotY===l[D].plotY){for(O=K=D=0;O<k.length;O++)D+=k[O].plotY,K+=l[O].plotY;D=D>K?0:1}else D=k[D].plotY>l[D].plotY?0:1;
else D=k[0].plotY>l[0].plotY?0:1;y[D]=y[D].concat(k);v[D]=v[D].concat(l)}["graphsenkouSpanColor","graphsenkouSpanNegativeColor"].forEach(function(c,k){y[k].length&&v[k].length&&(S=0===k?t:p,a({indicator:b,points:y[k],nextPoints:v[k],color:S,options:g,gap:x,graph:b[c]}),b[c]=b.graph,b.graphCollection.push(c))})}else a({indicator:b,points:B.senkouSpanB,nextPoints:B.senkouSpanA,color:t,options:g,gap:x,graph:b.graphsenkouSpan}),b.graphsenkouSpan=b.graph;delete b.nextPoints;delete b.fillGraph;b.points=
c;b.options=g;b.graph=e;b.color=f};f.prototype.getGraphPath=function(a){var b=[],c;a=a||this.points;if(this.fillGraph&&this.nextPoints){if((c=h.seriesTypes.sma.prototype.getGraphPath.call(this,this.nextPoints))&&c.length){c[0][0]="L";b=h.seriesTypes.sma.prototype.getGraphPath.call(this,a);c=c.slice(0,b.length);for(var k=c.length-1;0<=k;k--)b.push(c[k])}}else b=h.seriesTypes.sma.prototype.getGraphPath.apply(this,arguments);return b};f.prototype.getValues=function(a,b){var c=b.period,k=b.periodTenkan;
b=b.periodSenkouSpanB;var d=a.xData,e=a.yData,w=e&&e.length||0;a=g(a.xAxis);var f=[],B=[],n;if(!(d.length<=c)&&x(e[0])&&4===e[0].length){var r=d[0]-c*a;for(n=0;n<c;n++)B.push(r+n*a);for(n=0;n<w;n++){if(n>=k){var h=e.slice(n-k,n);h=t(h);h=(h.high+h.low)/2}if(n>=c){var z=e.slice(n-c,n);z=t(z);z=(z.high+z.low)/2;var q=(h+z)/2}if(n>=b){var l=e.slice(n-b,n);l=t(l);l=(l.high+l.low)/2}r=e[n][3];var m=d[n];"undefined"===typeof f[n]&&(f[n]=[]);"undefined"===typeof f[n+c]&&(f[n+c]=[]);f[n+c][0]=h;f[n+c][1]=
z;f[n+c][2]=void 0;f[n][2]=r;n<=c&&(f[n+c][3]=void 0,f[n+c][4]=void 0);"undefined"===typeof f[n+2*c]&&(f[n+2*c]=[]);f[n+2*c][3]=q;f[n+2*c][4]=l;B.push(m)}for(n=1;n<=c;n++)B.push(m+n*a);return{values:f,xData:B,yData:f}}};f.defaultOptions=z(k.defaultOptions,{params:{index:void 0,period:26,periodTenkan:9,periodSenkouSpanB:52},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>TENKAN SEN: {point.tenkanSen:.3f}<br/>KIJUN SEN: {point.kijunSen:.3f}<br/>CHIKOU SPAN: {point.chikouSpan:.3f}<br/>SENKOU SPAN A: {point.senkouSpanA:.3f}<br/>SENKOU SPAN B: {point.senkouSpanB:.3f}<br/>'},
tenkanLine:{styles:{lineWidth:1,lineColor:void 0}},kijunLine:{styles:{lineWidth:1,lineColor:void 0}},chikouLine:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanA:{styles:{lineWidth:1,lineColor:void 0}},senkouSpanB:{styles:{lineWidth:1,lineColor:void 0}},senkouSpan:{styles:{fill:"rgba(255, 0, 0, 0.5)"}},dataGrouping:{approximation:"ichimoku-averages"}});return f}(k);f(m.prototype,{pointArrayMap:["tenkanSen","kijunSen","chikouSpan","senkouSpanA","senkouSpanB"],pointValKey:"tenkanSen",nameComponents:["periodSenkouSpanB",
"period","periodTenkan"]});h.registerSeriesType("ikh",m);"";return m});v(f,"Stock/Indicators/KeltnerChannels/KeltnerChannelsIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,
b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=e.seriesTypes.sma,p=h.correctFloat,t=h.extend,g=h.merge;h=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,d);a.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=g({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};
a.prototype.getValues=function(a,c){var b=c.period,d=c.periodATR,g=c.multiplierATR,f=a.yData;f=f?f.length:0;var h=[];c=e.seriesTypes.ema.prototype.getValues(a,{period:b,index:c.index});var l=e.seriesTypes.atr.prototype.getValues(a,{period:d}),r=[],n=[],m;if(!(f<b)){for(m=b;m<=f;m++){var q=c.values[m-b];var u=l.values[m-d];var t=q[0];a=p(q[1]+g*u[1]);u=p(q[1]-g*u[1]);q=q[1];h.push([t,a,q,u]);r.push(t);n.push([a,q,u])}return{values:h,xData:r,yData:n}}};a.defaultOptions=g(l.defaultOptions,{params:{index:0,
period:20,periodATR:10,multiplierATR:2},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1,lineColor:void 0}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Upper Channel: {point.top}<br/>EMA({series.options.params.period}): {point.middle}<br/>Lower Channel: {point.bottom}<br/>'},marker:{enabled:!1},dataGrouping:{approximation:"averages"},lineWidth:1});return a}(l);t(h.prototype,{nameBase:"Keltner Channels",areaLinesNames:["top",
"bottom"],nameComponents:["period","periodATR","multiplierATR"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(h);e.registerSeriesType("keltnerchannels",h);"";return h});v(f,"Stock/Indicators/Klinger/KlingerIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function k(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(k.prototype=c.prototype,new k)}}(),l=e.seriesTypes,p=l.sma,t=l.ema,g=h.correctFloat,d=h.error;l=h.extend;var a=h.isArray,b=h.merge;h=function(c){function k(){var a=null!==c&&c.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;a.volumeSeries=void 0;return a}m(k,c);
k.prototype.calculateTrend=function(a,b){return a[b][1]+a[b][2]+a[b][3]>a[b-1][1]+a[b-1][2]+a[b-1][3]?1:-1};k.prototype.isValidData=function(b){var c=this.chart,k=this.options,g=this.linkedParent;b=a(b)&&4===b.length;(c=this.volumeSeries||(this.volumeSeries=c.get(k.params.volumeSeriesID)))||d("Series "+k.params.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,g.chart);return!(![g,c].every(function(a){return a&&a.xData&&a.xData.length>=k.params.slowAvgPeriod})||!b)};k.prototype.getCM=function(a,
b,c,k,d){return g(b+(c===k?a:d))};k.prototype.getDM=function(a,b){return g(a-b)};k.prototype.getVolumeForce=function(a){var b=[],c=1;var k=0;var d=a[0][1]-a[0][2];var g=0;for(c;c<a.length;c++){var e=this.calculateTrend(a,c);var f=this.getDM(a[c][1],a[c][2]);k=this.getCM(k,f,e,g,d);g=this.volumeSeries.yData[c]*e*Math.abs(2*(f/k-1))*100;b.push([g]);g=e;d=f}return b};k.prototype.getEMA=function(a,b,c,k,d,g,e){return t.prototype.calculateEma(e||[],a,"undefined"===typeof g?1:g,k,b,"undefined"===typeof d?
-1:d,c)};k.prototype.getSMA=function(a,b,c){return t.prototype.accumulatePeriodPoints(a,b,c)/a};k.prototype.getValues=function(a,b){var c=[],k=a.xData;a=a.yData;var d=[],e=[],f=[],w,h=0,x=0,l=void 0,m=void 0,t=null;if(this.isValidData(a[0])){var p=this.getVolumeForce(a),y=this.getSMA(b.fastAvgPeriod,0,p),C=this.getSMA(b.slowAvgPeriod,0,p),N=2/(b.fastAvgPeriod+1),v=2/(b.slowAvgPeriod+1);for(h;h<a.length;h++)h>=b.fastAvgPeriod&&(l=x=this.getEMA(p,l,y,N,0,h,k)[1]),h>=b.slowAvgPeriod&&(m=w=this.getEMA(p,
m,C,v,0,h,k)[1],w=g(x-w),f.push(w),f.length>=b.signalPeriod&&(t=f.slice(-b.signalPeriod).reduce(function(a,b){return a+b})/b.signalPeriod),c.push([k[h],w,t]),d.push(k[h]),e.push([w,t]));return{values:c,xData:d,yData:e}}};k.defaultOptions=b(p.defaultOptions,{params:{fastAvgPeriod:34,slowAvgPeriod:55,signalPeriod:13,volumeSeriesID:"volume"},signalLine:{styles:{lineWidth:1,lineColor:"#ff0000"}},dataGrouping:{approximation:"averages"},tooltip:{pointFormat:'<span style="color: {point.color}">\u25cf</span><b> {series.name}</b><br/><span style="color: {point.color}">Klinger</span>: {point.y}<br/><span style="color: {point.series.options.signalLine.styles.lineColor}">Signal</span>: {point.signal}<br/>'}});
return k}(p);l(h.prototype,{areaLinesNames:[],linesApiNames:["signalLine"],nameBase:"Klinger",nameComponents:["fastAvgPeriod","slowAvgPeriod"],pointArrayMap:["y","signal"],parallelArrays:["x","y","signal"],pointValKey:"y"});f.compose(h);e.registerSeriesType("klinger",h);"";return h});v(f,"Stock/Indicators/MACD/MACDIndicator.js",[f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var a=function(b,k){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,k)};return function(b,k){function c(){this.constructor=b}a(b,k);b.prototype=null===k?Object.create(k):(c.prototype=k.prototype,new c)}}(),l=f.noop,p=e.seriesTypes.sma,t=h.extend,g=h.correctFloat,d=h.defined,a=h.merge;h=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;a.currentLineZone=void 0;a.graphmacd=
void 0;a.graphsignal=void 0;a.macdZones=void 0;a.signalZones=void 0;return a}m(c,b);c.prototype.init=function(){e.seriesTypes.sma.prototype.init.apply(this,arguments);this.options&&(this.options=a({signalLine:{styles:{lineColor:this.color}},macdLine:{styles:{color:this.color}}},this.options),this.macdZones={zones:this.options.macdLine.zones,startIndex:0},this.signalZones={zones:this.macdZones.zones.concat(this.options.signalLine.zones),startIndex:this.macdZones.zones.length},this.resetZones=!0)};
c.prototype.toYData=function(a){return[a.y,a.signal,a.MACD]};c.prototype.translate=function(){var a=this,b=["plotSignal","plotMACD"];f.seriesTypes.column.prototype.translate.apply(a);a.points.forEach(function(c){[c.signal,c.MACD].forEach(function(k,d){null!==k&&(c[b[d]]=a.yAxis.toPixels(k,!0))})})};c.prototype.destroy=function(){this.graph=null;this.graphmacd=this.graphmacd&&this.graphmacd.destroy();this.graphsignal=this.graphsignal&&this.graphsignal.destroy();e.seriesTypes.sma.prototype.destroy.apply(this,
arguments)};c.prototype.drawGraph=function(){for(var b=this,c=b.points,g=c.length,f=b.options,h=b.zones,l={options:{gapSize:f.gapSize}},r=[[],[]],n;g--;)n=c[g],d(n.plotMACD)&&r[0].push({plotX:n.plotX,plotY:n.plotMACD,isNull:!d(n.plotMACD)}),d(n.plotSignal)&&r[1].push({plotX:n.plotX,plotY:n.plotSignal,isNull:!d(n.plotMACD)});["macd","signal"].forEach(function(c,k){b.points=r[k];b.options=a(f[c+"Line"].styles,l);b.graph=b["graph"+c];b.currentLineZone=c+"Zones";b.zones=b[b.currentLineZone].zones;e.seriesTypes.sma.prototype.drawGraph.call(b);
b["graph"+c]=b.graph});b.points=c;b.options=f;b.zones=h;b.currentLineZone=null};c.prototype.getZonesGraphs=function(a){var c=b.prototype.getZonesGraphs.call(this,a),k=c;this.currentLineZone&&(k=c.splice(this[this.currentLineZone].startIndex+1),k.length?k.splice(0,0,a[0]):k=[a[0]]);return k};c.prototype.applyZones=function(){var a=this.zones;this.zones=this.signalZones.zones;e.seriesTypes.sma.prototype.applyZones.call(this);this.graphmacd&&this.options.macdLine.zones.length&&this.graphmacd.hide();
this.zones=a};c.prototype.getValues=function(a,b){var c=b.longPeriod-b.shortPeriod,k=0,f=[],h=[],r=[];if(!(a.xData.length<b.longPeriod+b.signalPeriod)){var n=e.seriesTypes.ema.prototype.getValues(a,{period:b.shortPeriod,index:b.index});var w=e.seriesTypes.ema.prototype.getValues(a,{period:b.longPeriod,index:b.index});n=n.values;w=w.values;for(a=0;a<=n.length;a++)d(w[a])&&d(w[a][1])&&d(n[a+c])&&d(n[a+c][0])&&f.push([n[a+c][0],0,null,n[a+c][1]-w[a][1]]);for(a=0;a<f.length;a++)h.push(f[a][0]),r.push([0,
null,f[a][3]]);b=e.seriesTypes.ema.prototype.getValues({xData:h,yData:r},{period:b.signalPeriod,index:2});b=b.values;for(a=0;a<f.length;a++)f[a][0]>=b[0][0]&&(f[a][2]=b[k][1],r[a]=[0,b[k][1],f[a][3]],null===f[a][3]?(f[a][1]=0,r[a][0]=0):(f[a][1]=g(f[a][3]-b[k][1]),r[a][0]=g(f[a][3]-b[k][1])),k++);return{values:f,xData:h,yData:r}}};c.defaultOptions=a(p.defaultOptions,{params:{shortPeriod:12,longPeriod:26,signalPeriod:9,period:26},signalLine:{zones:[],styles:{lineWidth:1,lineColor:void 0}},macdLine:{zones:[],
styles:{lineWidth:1,lineColor:void 0}},threshold:0,groupPadding:.1,pointPadding:.1,crisp:!1,states:{hover:{halo:{size:0}}},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span> <b> {series.name}</b><br/>Value: {point.MACD}<br/>Signal: {point.signal}<br/>Histogram: {point.y}<br/>'},dataGrouping:{approximation:"averages"},minPointLength:0});return c}(p);t(h.prototype,{nameComponents:["longPeriod","shortPeriod","signalPeriod"],pointArrayMap:["y","signal","MACD"],parallelArrays:["x","y",
"signal","MACD"],pointValKey:"y",markerAttribs:l,getColumnMetrics:f.seriesTypes.column.prototype.getColumnMetrics,crispCol:f.seriesTypes.column.prototype.crispCol,drawPoints:f.seriesTypes.column.prototype.drawPoints});e.registerSeriesType("macd",h);"";return h});v(f,"Stock/Indicators/MFI/MFIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function h(a){return a.reduce(function(a,b){return a+b})}function m(a){return(a[1]+a[2]+a[3])/3}var l=this&&this.__extends||
function(){var a=function(b,d){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,d)};return function(b,d){function c(){this.constructor=b}a(b,d);b.prototype=null===d?Object.create(d):(c.prototype=d.prototype,new c)}}(),p=f.seriesTypes.sma,t=e.extend,g=e.merge,d=e.error,a=e.isArray;e=function(b){function c(){var a=null!==b&&b.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=
void 0;return a}l(c,b);c.prototype.getValues=function(b,c){var k=c.period,g=b.xData,e=b.yData,f=e?e.length:0,r=c.decimals,n=1,w=b.chart.get(c.volumeSeriesID),q=w&&w.yData,l=[],t=[],p=[],y=[],F=[];if(!w)d("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,b.chart);else if(!(g.length<=k)&&a(e[0])&&4===e[0].length&&q){for(b=m(e[n]);n<k+1;)c=b,b=m(e[n]),c=b>=c,w=b*q[n],y.push(c?w:0),F.push(c?0:w),n++;for(k=n-1;k<f;k++)k>n-1&&(y.shift(),F.shift(),c=b,b=m(e[k]),c=b>c,w=b*q[k],y.push(c?
w:0),F.push(c?0:w)),c=h(F),w=h(y),c=w/c,c=parseFloat((100-100/(1+c)).toFixed(r)),l.push([g[k],c]),t.push(g[k]),p.push(c);return{values:l,xData:t,yData:p}}};c.defaultOptions=g(p.defaultOptions,{params:{index:void 0,volumeSeriesID:"volume",decimals:4}});return c}(p);t(e.prototype,{nameBase:"Money Flow Index"});f.registerSeriesType("mfi",e);"";return e});v(f,"Stock/Indicators/Momentum/MomentumIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||
function(){var g=function(d,a){g=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return g(d,a)};return function(d,a){function b(){this.constructor=d}g(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.extend,p=e.isArray,t=e.merge;e=function(g){function d(){var a=null!==g&&g.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;
return a}h(d,g);d.prototype.getValues=function(a,b){var c=b.period;b=b.index;var d=a.xData,g=(a=a.yData)?a.length:0,e=[],f=[],h=[],l;if(!(d.length<=c)&&p(a[0])){for(l=c+1;l<g;l++){var r=[d[l-1],a[l-1][b]-a[l-c-1][b]];e.push(r);f.push(r[0]);h.push(r[1])}r=[d[l-1],a[l-1][b]-a[l-c-1][b]];e.push(r);f.push(r[0]);h.push(r[1]);return{values:e,xData:f,yData:h}}};d.defaultOptions=t(m.defaultOptions,{params:{index:3}});return d}(m);l(e.prototype,{nameBase:"Momentum"});f.registerSeriesType("momentum",e);"";
return e});v(f,"Stock/Indicators/NATR/NATRIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(f,g){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,a){d.__proto__=a}||function(d,a){for(var b in a)a.hasOwnProperty(b)&&(d[b]=a[b])};return e(f,g)};return function(f,g){function d(){this.constructor=f}e(f,g);f.prototype=null===g?Object.create(g):(d.prototype=g.prototype,new d)}}(),m=f.seriesTypes.atr,
l=e.merge;e=function(e){function f(){var g=null!==e&&e.apply(this,arguments)||this;g.data=void 0;g.points=void 0;g.options=void 0;return g}h(f,e);f.prototype.getValues=function(e,d){var a=m.prototype.getValues.apply(this,arguments),b=a.values.length,c=d.period-1,k=e.yData,g=0;if(a){for(;g<b;g++)a.yData[g]=a.values[g][1]/k[c][3]*100,a.values[g][1]=a.yData[g],c++;return a}};f.defaultOptions=l(m.defaultOptions,{tooltip:{valueSuffix:"%"}});return f}(m);f.registerSeriesType("natr",e);"";return e});v(f,
"Stock/Indicators/OBV/OBVIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=f.seriesTypes.sma,l=e.isNumber,
p=e.error,t=e.extend,g=e.merge;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.points=void 0;a.options=void 0;return a}h(a,d);a.prototype.getValues=function(a,c){var b=a.chart.get(c.volumeSeriesID),d=a.xData,g=a.yData,e=[],f=[],h=[],r=!l(g[0]),n=1,m=0;if(b){b=b.yData;a=[d[0],m];var q=r?g[0][3]:g[0];e.push(a);f.push(d[0]);h.push(a[1]);for(n;n<g.length;n++)c=r?g[n][3]:g[n],m=c>q?m+b[n]:c===q?m:m-b[n],a=[d[n],m],q=c,e.push(a),f.push(d[n]),h.push(a[1]);return{values:e,
xData:f,yData:h}}p("Series "+c.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,a.chart)};a.defaultOptions=g(m.defaultOptions,{marker:{enabled:!1},params:{index:void 0,period:void 0,volumeSeriesID:"volume"},tooltip:{valueDecimals:0}});return a}(m);t(e.prototype,{nameComponents:void 0});f.registerSeriesType("obv",e);"";return e});v(f,"Stock/Indicators/PivotPoints/PivotPointsPoint.js",[f["Core/Series/SeriesRegistry.js"]],function(f){function e(e,h){var l=e.series.pointArrayMap,m=l.length;for(f.seriesTypes.sma.prototype.pointClass.prototype[h].call(e);m--;)h=
"dataLabel"+l[m],e[h]&&e[h].element&&e[h].destroy(),e[h]=null}var h=this&&this.__extends||function(){var e=function(f,h){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,g){e.__proto__=g}||function(e,g){for(var d in g)g.hasOwnProperty(d)&&(e[d]=g[d])};return e(f,h)};return function(f,h){function l(){this.constructor=f}e(f,h);f.prototype=null===h?Object.create(h):(l.prototype=h.prototype,new l)}}();return function(f){function l(){var e=null!==f&&f.apply(this,arguments)||this;e.P=
void 0;e.pivotLine=void 0;e.series=void 0;return e}h(l,f);l.prototype.destroyElements=function(){e(this,"destroyElements")};l.prototype.destroy=function(){e(this,"destroyElements")};return l}(f.seriesTypes.sma.prototype.pointClass)});v(f,"Stock/Indicators/PivotPoints/PivotPointsIndicator.js",[f["Stock/Indicators/PivotPoints/PivotPointsPoint.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||
{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),l=e.seriesTypes.sma,p=h.merge,t=h.extend,g=h.defined,d=h.isArray;h=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;b.endPoint=void 0;b.plotEndPoint=void 0;return b}
m(b,a);b.prototype.toYData=function(a){return[a.P]};b.prototype.translate=function(){var a=this;e.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(b){a.pointArrayMap.forEach(function(c){g(b[c])&&(b["plot"+c]=a.yAxis.toPixels(b[c],!0))})});a.plotEndPoint=a.xAxis.toPixels(a.endPoint,!0)};b.prototype.getGraphPath=function(a){for(var b=this,c=a.length,d=[[],[],[],[],[],[],[],[],[]],f=[],h=b.plotEndPoint,l=b.pointArrayMap.length,r,n,m;c--;){n=a[c];for(m=0;m<l;m++)r=b.pointArrayMap[m],
g(n[r])&&d[m].push({plotX:n.plotX,plotY:n["plot"+r],isNull:!1},{plotX:h,plotY:n["plot"+r],isNull:!1},{plotX:h,plotY:null,isNull:!0});h=n.plotX}d.forEach(function(a){f=f.concat(e.seriesTypes.sma.prototype.getGraphPath.call(b,a))});return f};b.prototype.drawDataLabels=function(){var a=this,b=a.pointArrayMap,d,g,f;if(a.options.dataLabels.enabled){var h=a.points.length;b.concat([!1]).forEach(function(c,k){for(f=h;f--;)g=a.points[f],c?(g.y=g[c],g.pivotLine=c,g.plotY=g["plot"+c],d=g["dataLabel"+c],k&&(g["dataLabel"+
b[k-1]]=g.dataLabel),g.dataLabels||(g.dataLabels=[]),g.dataLabels[0]=g.dataLabel=d=d&&d.element?d:null):g["dataLabel"+b[k-1]]=g.dataLabel;e.seriesTypes.sma.prototype.drawDataLabels.apply(a,arguments)})}};b.prototype.getValues=function(a,b){var c=b.period,k=a.xData,g=(a=a.yData)?a.length:0;b=this[b.algorithm+"Placement"];var e=[],f=[],h=[],n;if(!(k.length<c)&&d(a[0])&&4===a[0].length){for(n=c+1;n<=g+c;n+=c){var l=k.slice(n-c-1,n);var q=a.slice(n-c-1,n);var m=l.length;var t=l[m-1];q=this.getPivotAndHLC(q);
q=b(q);q=e.push([t].concat(q));f.push(t);h.push(e[q-1].slice(1))}this.endPoint=l[0]+(t-l[0])/m*c;return{values:e,xData:f,yData:h}}};b.prototype.getPivotAndHLC=function(a){var b=-Infinity,c=Infinity,d=a[a.length-1][3];a.forEach(function(a){b=Math.max(b,a[1]);c=Math.min(c,a[2])});return[(b+c+d)/3,b,c,d]};b.prototype.standardPlacement=function(a){var b=a[1]-a[2];return[null,null,a[0]+b,2*a[0]-a[2],a[0],2*a[0]-a[1],a[0]-b,null,null]};b.prototype.camarillaPlacement=function(a){var b=a[1]-a[2];return[a[3]+
1.5*b,a[3]+1.25*b,a[3]+1.1666*b,a[3]+1.0833*b,a[0],a[3]-1.0833*b,a[3]-1.1666*b,a[3]-1.25*b,a[3]-1.5*b]};b.prototype.fibonacciPlacement=function(a){var b=a[1]-a[2];return[null,a[0]+b,a[0]+.618*b,a[0]+.382*b,a[0],a[0]-.382*b,a[0]-.618*b,a[0]-b,null]};b.defaultOptions=p(l.defaultOptions,{params:{index:void 0,period:28,algorithm:"standard"},marker:{enabled:!1},enableMouseTracking:!1,dataLabels:{enabled:!0,format:"{point.pivotLine}"},dataGrouping:{approximation:"averages"}});return b}(l);t(h.prototype,
{nameBase:"Pivot Points",pointArrayMap:"R4 R3 R2 R1 P S1 S2 S3 S4".split(" "),pointValKey:"P",pointClass:f});e.registerSeriesType("pivotpoints",h);"";return h});v(f,"Stock/Indicators/PPO/PPOIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};
return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),m=f.seriesTypes.ema,l=e.correctFloat,p=e.extend,t=e.merge,g=e.error;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(a,d);a.prototype.getValues=function(a,c){var b=c.periods,d=c.index;c=[];var e=[],f=[],h;if(2!==b.length||b[1]<=b[0])g('Error: "PPO requires two periods. Notice, first period should be lower than the second one."');
else{var t=m.prototype.getValues.call(this,a,{index:d,period:b[0]});a=m.prototype.getValues.call(this,a,{index:d,period:b[1]});if(t&&a){b=b[1]-b[0];for(h=0;h<a.yData.length;h++)d=l((t.yData[h+b]-a.yData[h])/a.yData[h]*100),c.push([a.xData[h],d]),e.push(a.xData[h]),f.push(d);return{values:c,xData:e,yData:f}}}};a.defaultOptions=t(m.defaultOptions,{params:{period:void 0,periods:[12,26]}});return a}(m);p(e.prototype,{nameBase:"PPO",nameComponents:["periods"]});f.registerSeriesType("ppo",e);"";return e});
v(f,"Stock/Indicators/ArrayUtilities.js",[],function(){return{getArrayExtremes:function(f,e,h){return f.reduce(function(f,l){return[Math.min(f[0],l[e]),Math.max(f[1],l[h])]},[Number.MAX_VALUE,-Number.MAX_VALUE])}}});v(f,"Stock/Indicators/PC/PCIndicator.js",[f["Stock/Indicators/ArrayUtilities.js"],f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Color/Palettes.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h,m,l){var p=this&&this.__extends||function(){var a=function(b,
c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),t=m.seriesTypes.sma,g=l.merge;l=l.extend;var d=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}p(b,a);b.prototype.getValues=
function(a,b){b=b.period;var c=a.xData,d=(a=a.yData)?a.length:0,e=[],g=[],k=[],h;if(!(d<b)){for(h=b;h<=d;h++){var n=c[h-1];var l=a.slice(h-b,h);var q=f.getArrayExtremes(l,2,1);l=q[1];var m=q[0];q=(l+m)/2;e.push([n,l,q,m]);g.push(n);k.push([l,q,m])}return{values:e,xData:g,yData:k}}};b.defaultOptions=g(t.defaultOptions,{params:{index:void 0,period:20},lineWidth:1,topLine:{styles:{lineColor:h.colors[2],lineWidth:1}},bottomLine:{styles:{lineColor:h.colors[8],lineWidth:1}},dataGrouping:{approximation:"averages"}});
return b}(t);l(d.prototype,{areaLinesNames:["top","bottom"],nameBase:"Price Channel",nameComponents:["period"],linesApiNames:["topLine","bottomLine"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});e.compose(d);m.registerSeriesType("pc",d);"";return d});v(f,"Stock/Indicators/PriceEnvelopes/PriceEnvelopesIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.extend,p=e.isArray,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(d,e);d.prototype.init=function(){f.seriesTypes.sma.prototype.init.apply(this,
arguments);this.options=t({topLine:{styles:{lineColor:this.color}},bottomLine:{styles:{lineColor:this.color}}},this.options)};d.prototype.toYData=function(a){return[a.top,a.middle,a.bottom]};d.prototype.translate=function(){var a=this,b=["plotTop","plotMiddle","plotBottom"];f.seriesTypes.sma.prototype.translate.apply(a);a.points.forEach(function(c){[c.top,c.middle,c.bottom].forEach(function(d,e){null!==d&&(c[b[e]]=a.yAxis.toPixels(d,!0))})})};d.prototype.drawGraph=function(){for(var a=this,b=a.points,
c=b.length,d=a.options,e=a.graph,g={options:{gapSize:d.gapSize}},h=[[],[]],l;c--;)l=b[c],h[0].push({plotX:l.plotX,plotY:l.plotTop,isNull:l.isNull}),h[1].push({plotX:l.plotX,plotY:l.plotBottom,isNull:l.isNull});["topLine","bottomLine"].forEach(function(b,c){a.points=h[c];a.options=t(d[b].styles,g);a.graph=a["graph"+b];f.seriesTypes.sma.prototype.drawGraph.call(a);a["graph"+b]=a.graph});a.points=b;a.options=d;a.graph=e;f.seriesTypes.sma.prototype.drawGraph.call(a)};d.prototype.getValues=function(a,
b){var c=b.period,d=b.topBand,e=b.bottomBand,g=a.xData,h=(a=a.yData)?a.length:0,l=[],m=[],r=[],n;if(!(g.length<c)&&p(a[0])&&4===a[0].length){for(n=c;n<=h;n++){var t=g.slice(n-c,n);var q=a.slice(n-c,n);q=f.seriesTypes.sma.prototype.getValues.call(this,{xData:t,yData:q},b);t=q.xData[0];q=q.yData[0];var u=q*(1+d);var P=q*(1-e);l.push([t,u,q,P]);m.push(t);r.push([u,q,P])}return{values:l,xData:m,yData:r}}};d.defaultOptions=t(m.defaultOptions,{marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>Top: {point.top}<br/>Middle: {point.middle}<br/>Bottom: {point.bottom}<br/>'},
params:{period:20,topBand:.1,bottomBand:.1},bottomLine:{styles:{lineWidth:1,lineColor:void 0}},topLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return d}(m);l(e.prototype,{nameComponents:["period","topBand","bottomBand"],nameBase:"Price envelopes",pointArrayMap:["top","middle","bottom"],parallelArrays:["x","y","top","bottom"],pointValKey:"middle"});f.registerSeriesType("priceenvelopes",e);"";return e});v(f,"Stock/Indicators/PSAR/PSARIndicator.js",[f["Core/Series/SeriesRegistry.js"],
f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(g,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(g,d)};return function(g,d){function a(){this.constructor=g}e(g,d);g.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,l=e.merge;e=e.extend;var p=function(e){function g(){var d=null!==e&&e.apply(this,arguments)||
this;d.data=void 0;d.points=void 0;d.options=void 0;return d}h(g,e);g.prototype.getValues=function(d,a){var b=d.xData;d=d.yData;var c=d[0][1],e=a.maxAccelerationFactor,g=a.increment,f=a.initialAccelerationFactor,h=d[0][2],l=a.decimals,m=a.index,r=[],n=[],t=[],q=1,u;if(!(m>=d.length)){for(u=0;u<m;u++)c=Math.max(d[u][1],c),h=Math.min(d[u][2],parseFloat(h.toFixed(l)));var p=d[u][1]>h?1:-1;a=a.initialAccelerationFactor;var J=a*(c-h);r.push([b[m],h]);n.push(b[m]);t.push(parseFloat(h.toFixed(l)));for(u=
m+1;u<d.length;u++){m=d[u-1][2];var y=d[u-2][2];var F=d[u-1][1];var v=d[u-2][1];var C=d[u][1];var N=d[u][2];null!==y&&null!==v&&null!==m&&null!==F&&null!==C&&null!==N&&(h=p===q?1===p?h+J<Math.min(y,m)?h+J:Math.min(y,m):h+J>Math.max(v,F)?h+J:Math.max(v,F):c,m=1===p?C>c?C:c:N<c?N:c,C=1===q&&N>h||-1===q&&C>h?1:-1,q=C,J=m,N=g,y=e,F=f,a=q===p?1===q&&J>c?a===y?y:parseFloat((a+N).toFixed(2)):-1===q&&J<c?a===y?y:parseFloat((a+N).toFixed(2)):a:F,c=m-h,J=a*c,r.push([b[u],parseFloat(h.toFixed(l))]),n.push(b[u]),
t.push(parseFloat(h.toFixed(l))),q=p,p=C,c=m)}return{values:r,xData:n,yData:t}}};g.defaultOptions=l(m.defaultOptions,{lineWidth:0,marker:{enabled:!0},states:{hover:{lineWidthPlus:0}},params:{period:void 0,initialAccelerationFactor:.02,maxAccelerationFactor:.2,increment:.02,index:2,decimals:4}});return g}(m);e(p.prototype,{nameComponents:void 0});f.registerSeriesType("psar",p);"";return p});v(f,"Stock/Indicators/ROC/ROCIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,
e){var h=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.isArray,p=e.merge;e=e.extend;var t=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;
a.options=void 0;a.points=void 0;return a}h(d,e);d.prototype.getValues=function(a,b){var c=b.period,d=a.xData,e=(a=a.yData)?a.length:0,g=[],f=[],h=[],m=-1;if(!(d.length<=c)){l(a[0])&&(m=b.index);for(b=c;b<e;b++){var r=0>m?(r=a[b-c])?(a[b]-r)/r*100:null:(r=a[b-c][m])?(a[b][m]-r)/r*100:null;r=[d[b],r];g.push(r);f.push(r[0]);h.push(r[1])}return{values:g,xData:f,yData:h}}};d.defaultOptions=p(m.defaultOptions,{params:{index:3,period:9}});return d}(m);e(t.prototype,{nameBase:"Rate of Change"});f.registerSeriesType("roc",
t);"";return t});v(f,"Stock/Indicators/RSI/RSIIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,
l=e.isNumber,p=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=void 0;return d}h(f,e);f.prototype.getValues=function(d,a){var b=a.period,c=d.xData,e=d.yData;d=e?e.length:0;var f=a.decimals,g=1,h=[],m=[],t=[],r=a.index,n=a=0,p;if(!(c.length<b)){if(l(e[0]))var q=e;else r=Math.min(r,e[0].length-1),q=e.map(function(a){return a[r]});for(;g<b;){var u=parseFloat((q[g]-q[g-1]).toFixed(f));0<u?a+=u:n+=Math.abs(u);g++}e=parseFloat((a/
(b-1)).toFixed(f));for(p=parseFloat((n/(b-1)).toFixed(f));g<d;g++)u=parseFloat((q[g]-q[g-1]).toFixed(f)),0<u?(a=u,n=0):(a=0,n=Math.abs(u)),e=parseFloat(((e*(b-1)+a)/b).toFixed(f)),p=parseFloat(((p*(b-1)+n)/b).toFixed(f)),a=0===p?100:0===e?0:parseFloat((100-100/(1+e/p)).toFixed(f)),h.push([c[g],a]),m.push(c[g]),t.push(a);return{values:h,xData:m,yData:t}}};f.defaultOptions=p(m.defaultOptions,{params:{decimals:4,index:3}});return f}(m);f.registerSeriesType("rsi",e);"";return e});v(f,"Stock/Indicators/Stochastic/StochasticIndicator.js",
[f["Stock/Indicators/ArrayUtilities.js"],f["Stock/Indicators/MultipleLinesComposition.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h,m){var l=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=
c.prototype,new d)}}(),p=h.seriesTypes.sma,t=m.extend,g=m.isArray,d=m.merge;m=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.data=void 0;b.options=void 0;b.points=void 0;return b}l(b,a);b.prototype.init=function(){h.seriesTypes.sma.prototype.init.apply(this,arguments);this.options=d({smoothedLine:{styles:{lineColor:this.color}}},this.options)};b.prototype.getValues=function(a,b){var c=b.periods[0];b=b.periods[1];var d=a.xData,e=(a=a.yData)?a.length:0,k=[],l=[],m=[],n=null,
t;if(!(e<c)&&g(a[0])&&4===a[0].length){for(t=c-1;t<e;t++){var q=a.slice(t-c+1,t+1);var u=f.getArrayExtremes(q,2,1);var p=u[0];q=a[t][3]-p;p=u[1]-p;q=q/p*100;l.push(d[t]);m.push([q,null]);t>=c-1+(b-1)&&(n=h.seriesTypes.sma.prototype.getValues.call(this,{xData:l.slice(-b),yData:m.slice(-b)},{period:b}),n=n.yData[0]);k.push([d[t],q,n]);m[m.length-1][1]=n}return{values:k,xData:l,yData:m}}};b.defaultOptions=d(p.defaultOptions,{params:{index:void 0,period:void 0,periods:[14,3]},marker:{enabled:!1},tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span><b> {series.name}</b><br/>%K: {point.y}<br/>%D: {point.smoothed}<br/>'},
smoothedLine:{styles:{lineWidth:1,lineColor:void 0}},dataGrouping:{approximation:"averages"}});return b}(p);t(m.prototype,{areaLinesNames:[],nameComponents:["periods"],nameBase:"Stochastic",pointArrayMap:["y","smoothed"],parallelArrays:["x","y","smoothed"],pointValKey:"y",linesApiNames:["smoothedLine"]});e.compose(m);h.registerSeriesType("stochastic",m);"";return m});v(f,"Stock/Indicators/SlowStochastic/SlowStochasticIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,
e){var h=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.stochastic,l=f.seriesTypes,p=e.extend,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=
void 0;a.options=void 0;a.points=void 0;return a}h(d,e);d.prototype.getValues=function(a,b){var c=b.periods,d=l.stochastic.prototype.getValues.call(this,a,b);a={values:[],xData:[],yData:[]};b=0;if(d){a.xData=d.xData.slice(c[1]-1);d=d.yData.slice(c[1]-1);var e=l.sma.prototype.getValues.call(this,{xData:a.xData,yData:d},{index:1,period:c[2]});if(e){for(var f=a.xData.length;b<f;b++)a.yData[b]=[d[b][1],e.yData[b-c[2]+1]||null],a.values[b]=[a.xData[b],d[b][1],e.yData[b-c[2]+1]||null];return a}}};d.defaultOptions=
t(m.defaultOptions,{params:{periods:[14,3,3]}});return d}(m);p(e.prototype,{nameBase:"Slow Stochastic"});f.registerSeriesType("slowstochastic",e);"";return e});v(f,"Stock/Indicators/Supertrend/SupertrendIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"],f["Core/Chart/StockChart.js"]],function(f,e,h){function m(a,b,c){return{index:b,close:a.yData[b][c],x:a.xData[b]}}var l=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&
function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),p=f.seriesTypes,t=p.atr,g=p.sma,d=e.addEvent,a=e.correctFloat,b=e.isArray;p=e.extend;var c=e.merge,k=e.objectEach;e=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.linkedParent=void 0;a.options=void 0;a.points=void 0;return a}
l(f,e);f.prototype.init=function(){var a;g.prototype.init.apply(this,arguments);var b=this,c=d(h,"afterLinkSeries",function(){if(b.options){var d=b.options;a=b.linkedParent.options;d.cropThreshold=a.cropThreshold-(d.params.period-1)}c()},{order:1})};f.prototype.drawGraph=function(){var a=this,b=a.options,d=a.linkedParent,e=d?d.points:[],f=a.points,h=a.graph,l=f.length,u=e.length-l;u=0<u?u:0;for(var t={options:{gapSize:b.gapSize}},p={top:[],bottom:[],intersect:[]},w={top:{styles:{lineWidth:b.lineWidth,
lineColor:b.fallingTrendColor||b.color,dashStyle:b.dashStyle}},bottom:{styles:{lineWidth:b.lineWidth,lineColor:b.risingTrendColor||b.color,dashStyle:b.dashStyle}},intersect:b.changeTrendLine},x,y,C,v,E,G,H,I;l--;)x=f[l],y=f[l-1],C=e[l-1+u],v=e[l-2+u],E=e[l+u],G=e[l+u+1],H=x.options.color,I={x:x.x,plotX:x.plotX,plotY:x.plotY,isNull:!1},!v&&C&&d.yData[C.index-1]&&(v=m(d,C.index-1,3)),!G&&E&&d.yData[E.index+1]&&(G=m(d,E.index+1,3)),!C&&v&&d.yData[v.index+1]?C=m(d,v.index+1,3):!C&&E&&d.yData[E.index-
1]&&(C=m(d,E.index-1,3)),x&&C&&E&&v&&x.x!==C.x&&(x.x===E.x?(v=C,C=E):x.x===v.x?(C=v,v={close:d.yData[C.index-1][3],x:d.xData[C.index-1]}):G&&x.x===G.x&&(C=G,v=E)),y&&v&&C?(E={x:y.x,plotX:y.plotX,plotY:y.plotY,isNull:!1},x.y>=C.close&&y.y>=v.close?(x.color=H||b.fallingTrendColor||b.color,p.top.push(I)):x.y<C.close&&y.y<v.close?(x.color=H||b.risingTrendColor||b.color,p.bottom.push(I)):(p.intersect.push(I),p.intersect.push(E),p.intersect.push(c(E,{isNull:!0})),x.y>=C.close&&y.y<v.close?(x.color=H||b.fallingTrendColor||
b.color,y.color=H||b.risingTrendColor||b.color,p.top.push(I),p.top.push(c(E,{isNull:!0}))):x.y<C.close&&y.y>=v.close&&(x.color=H||b.risingTrendColor||b.color,y.color=H||b.fallingTrendColor||b.color,p.bottom.push(I),p.bottom.push(c(E,{isNull:!0}))))):C&&(x.y>=C.close?(x.color=H||b.fallingTrendColor||b.color,p.top.push(I)):(x.color=H||b.risingTrendColor||b.color,p.bottom.push(I)));k(p,function(b,d){a.points=b;a.options=c(w[d].styles,t);a.graph=a["graph"+d+"Line"];g.prototype.drawGraph.call(a);a["graph"+
d+"Line"]=a.graph});a.points=f;a.options=b;a.graph=h};f.prototype.getValues=function(c,d){var e=d.period;d=d.multiplier;var f=c.xData,g=c.yData,k=[],h=[],l=[],m=0===e?0:e-1,p=[],w=[],x;if(!(f.length<=e||!b(g[0])||4!==g[0].length||0>e)){c=t.prototype.getValues.call(this,c,{period:e}).yData;for(x=0;x<c.length;x++){var z=g[m+x];var B=g[m+x-1]||[];var y=p[x-1];var v=w[x-1];var G=l[x-1];0===x&&(y=v=G=0);e=a((z[1]+z[2])/2+d*c[x]);var H=a((z[1]+z[2])/2-d*c[x]);p[x]=e<y||B[3]>y?e:y;w[x]=H>v||B[3]<v?H:v;if(G===
y&&z[3]<p[x]||G===v&&z[3]<w[x])var I=p[x];else if(G===y&&z[3]>p[x]||G===v&&z[3]>w[x])I=w[x];k.push([f[m+x],I]);h.push(f[m+x]);l.push(I)}return{values:k,xData:h,yData:l}}};f.defaultOptions=c(g.defaultOptions,{params:{index:void 0,multiplier:3,period:10},risingTrendColor:"#06b535",fallingTrendColor:"#f21313",changeTrendLine:{styles:{lineWidth:1,lineColor:"#333333",dashStyle:"LongDash"}}});return f}(g);p(e.prototype,{nameBase:"Supertrend",nameComponents:["multiplier","period"]});f.registerSeriesType("supertrend",
e);"";return e});v(f,"Stock/Indicators/VBP/VBPPoint.js",[f["Core/Series/Point.js"],f["Core/Series/SeriesRegistry.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(f,h){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,f){e.__proto__=f}||function(e,f){for(var d in f)f.hasOwnProperty(d)&&(e[d]=f[d])};return e(f,h)};return function(f,h){function l(){this.constructor=f}e(f,h);f.prototype=null===h?Object.create(h):(l.prototype=h.prototype,new l)}}();return function(e){function l(){return null!==
e&&e.apply(this,arguments)||this}h(l,e);l.prototype.destroy=function(){this.negativeGraphic&&(this.negativeGraphic=this.negativeGraphic.destroy());return f.prototype.destroy.apply(this,arguments)};return l}(e.seriesTypes.sma.prototype.pointClass)});v(f,"Stock/Indicators/VBP/VBPIndicator.js",[f["Stock/Indicators/VBP/VBPPoint.js"],f["Core/Animation/AnimationUtilities.js"],f["Core/Globals.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"],f["Core/Chart/StockChart.js"]],function(f,e,h,m,l,
p){var t=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),g=e.animObject;e=h.noop;var d=m.seriesTypes.sma,a=l.addEvent,b=l.arrayMax,c=l.arrayMin,k=l.correctFloat,w=l.defined,x=l.error,B=l.extend,z=l.isArray,
v=l.merge,r=Math.abs,n=m.seriesTypes.column.prototype;l=function(e){function f(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.negWidths=void 0;a.options=void 0;a.points=void 0;a.posWidths=void 0;a.priceZones=void 0;a.rangeStep=void 0;a.volumeDataArray=void 0;a.zoneStarts=void 0;a.zoneLinesSVG=void 0;return a}t(f,e);f.prototype.init=function(b){var c=this,d,e,f;h.seriesTypes.sma.prototype.init.apply(c,arguments);var g=a(p,"afterLinkSeries",function(){c.options&&(d=c.options.params,
e=c.linkedParent,f=b.get(d.volumeSeriesID),c.addCustomEvents(e,f));g()},{order:1});return c};f.prototype.addCustomEvents=function(b,c){function d(){e.chart.redraw();e.setData([]);e.zoneStarts=[];e.zoneLinesSVG&&(e.zoneLinesSVG=e.zoneLinesSVG.destroy())}var e=this;e.dataEventsToUnbind.push(a(b,"remove",function(){d()}));c&&e.dataEventsToUnbind.push(a(c,"remove",function(){d()}));return e};f.prototype.animate=function(a){var b=this,c=b.chart.inverted,d=b.group,e={};!a&&d&&(a=c?b.yAxis.top:b.xAxis.left,
c?(d["forceAnimate:translateY"]=!0,e.translateY=a):(d["forceAnimate:translateX"]=!0,e.translateX=a),d.animate(e,B(g(b.options.animation),{step:function(a,c){b.group.attr({scaleX:Math.max(.001,c.pos)})}})))};f.prototype.drawPoints=function(){this.options.volumeDivision.enabled&&(this.posNegVolume(!0,!0),n.drawPoints.apply(this,arguments),this.posNegVolume(!1,!1));n.drawPoints.apply(this,arguments)};f.prototype.posNegVolume=function(a,b){var c=b?["positive","negative"]:["negative","positive"],d=this.options.volumeDivision,
e=this.points.length,f=[],g=[],k=0,h;a?(this.posWidths=f,this.negWidths=g):(f=this.posWidths,g=this.negWidths);for(;k<e;k++){var n=this.points[k];n[c[0]+"Graphic"]=n.graphic;n.graphic=n[c[1]+"Graphic"];if(a){var l=n.shapeArgs.width;var m=this.priceZones[k];(h=m.wholeVolumeData)?(f.push(l/h*m.positiveVolumeData),g.push(l/h*m.negativeVolumeData)):(f.push(0),g.push(0))}n.color=b?d.styles.positiveColor:d.styles.negativeColor;n.shapeArgs.width=b?this.posWidths[k]:this.negWidths[k];n.shapeArgs.x=b?n.shapeArgs.x:
this.posWidths[k]}};f.prototype.translate=function(){var a=this,c=a.options,d=a.chart,e=a.yAxis,f=e.min,g=a.options.zoneLines,h=a.priceZones,l=0,m,q,t;n.translate.apply(a);var p=a.points;if(p.length){var w=.5>c.pointPadding?c.pointPadding:.1;c=a.volumeDataArray;var x=b(c);var z=d.plotWidth/2;var B=d.plotTop;var A=r(e.toPixels(f)-e.toPixels(f+a.rangeStep));var v=r(e.toPixels(f)-e.toPixels(f+a.rangeStep));w&&(f=r(A*(1-2*w)),l=r((A-f)/2),A=r(f));p.forEach(function(b,c){q=b.barX=b.plotX=0;t=b.plotY=e.toPixels(h[c].start)-
B-(e.reversed?A-v:A)-l;m=k(z*h[c].wholeVolumeData/x);b.pointWidth=m;b.shapeArgs=a.crispCol.apply(a,[q,t,m,A]);b.volumeNeg=h[c].negativeVolumeData;b.volumePos=h[c].positiveVolumeData;b.volumeAll=h[c].wholeVolumeData});g.enabled&&a.drawZones(d,e,a.zoneStarts,g.styles)}};f.prototype.getValues=function(a,b){var c=a.processedXData,d=a.processedYData,e=this.chart,f=b.ranges,g=[],k=[],h=[],n;if(a.chart)if(n=e.get(b.volumeSeriesID))if((b=z(d[0]))&&4!==d[0].length)x("Type of "+a.name+" series is different than line, OHLC or candlestick.",
!0,e);else return(this.priceZones=this.specifyZones(b,c,d,f,n)).forEach(function(a,b){g.push([a.x,a.end]);k.push(g[b][0]);h.push(g[b][1])}),{values:g,xData:k,yData:h};else x("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,e);else x("Base series not found! In case it has been removed, add a new one.",!0,e)};f.prototype.specifyZones=function(a,d,e,f,g){if(a){var h=e.length;for(var n=e[0][3],l=n,m=1,r;m<h;m++)r=e[m][3],r<n&&(n=r),r>l&&(l=r);h={min:n,max:l}}else h=!1;h=(n=h)?n.min:
c(e);r=n?n.max:b(e);n=this.zoneStarts=[];l=[];var q=0;m=1;var t=this.linkedParent;!this.options.compareToMain&&t.dataModify&&(h=t.dataModify.modifyValue(h),r=t.dataModify.modifyValue(r));if(!w(h)||!w(r))return this.points.length&&(this.setData([]),this.zoneStarts=[],this.zoneLinesSVG&&(this.zoneLinesSVG=this.zoneLinesSVG.destroy())),[];t=this.rangeStep=k(r-h)/f;for(n.push(h);q<f-1;q++)n.push(k(n[q]+t));n.push(r);for(f=n.length;m<f;m++)l.push({index:m-1,x:d[0],start:n[m-1],end:n[m]});return this.volumePerZone(a,
l,g,d,e)};f.prototype.volumePerZone=function(a,b,c,d,e){var f=this,g=c.processedXData,k=c.processedYData,h=b.length-1,n=e.length;c=k.length;var l,m,q,t,p;r(n-c)&&(d[0]!==g[0]&&k.unshift(0),d[n-1]!==g[c-1]&&k.push(0));f.volumeDataArray=[];b.forEach(function(b){b.wholeVolumeData=0;b.positiveVolumeData=0;for(p=b.negativeVolumeData=0;p<n;p++){q=m=!1;t=a?e[p][3]:e[p];l=p?a?e[p-1][3]:e[p-1]:t;var c=f.linkedParent;!f.options.compareToMain&&c.dataModify&&(t=c.dataModify.modifyValue(t),l=c.dataModify.modifyValue(l));
t<=b.start&&0===b.index&&(m=!0);t>=b.end&&b.index===h&&(q=!0);(t>b.start||m)&&(t<b.end||q)&&(b.wholeVolumeData+=k[p],l>t?b.negativeVolumeData+=k[p]:b.positiveVolumeData+=k[p])}f.volumeDataArray.push(b.wholeVolumeData)});return b};f.prototype.drawZones=function(a,b,c,d){var e=a.renderer,f=this.zoneLinesSVG,g=[],k=a.plotWidth,h=a.plotTop,n;c.forEach(function(c){n=b.toPixels(c)-h;g=g.concat(a.renderer.crispLine([["M",0,n],["L",k,n]],d.lineWidth))});f?f.animate({d:g}):f=this.zoneLinesSVG=e.path(g).attr({"stroke-width":d.lineWidth,
stroke:d.color,dashstyle:d.dashStyle,zIndex:this.group.zIndex+.1}).add(this.group)};f.defaultOptions=v(d.defaultOptions,{params:{index:void 0,period:void 0,ranges:12,volumeSeriesID:"volume"},zoneLines:{enabled:!0,styles:{color:"#0A9AC9",dashStyle:"LongDash",lineWidth:1}},volumeDivision:{enabled:!0,styles:{positiveColor:"rgba(144, 237, 125, 0.8)",negativeColor:"rgba(244, 91, 91, 0.8)"}},animationLimit:1E3,enableMouseTracking:!1,pointPadding:0,zIndex:-1,crisp:!0,dataGrouping:{enabled:!1},dataLabels:{allowOverlap:!0,
enabled:!0,format:"P: {point.volumePos:.2f} | N: {point.volumeNeg:.2f}",padding:0,style:{fontSize:"7px"},verticalAlign:"top"}});return f}(d);B(l.prototype,{nameBase:"Volume by Price",nameComponents:["ranges"],calculateOn:{chart:"render",xAxis:"afterSetExtremes"},pointClass:f,markerAttribs:e,drawGraph:e,getColumnMetrics:n.getColumnMetrics,crispCol:n.crispCol});m.registerSeriesType("vbp",l);"";return l});v(f,"Stock/Indicators/VWAP/VWAPIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],
function(f,e){var h=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.error,p=e.isArray,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=
void 0;a.points=void 0;a.options=void 0;return a}h(d,e);d.prototype.getValues=function(a,b){var c=a.chart,d=a.xData;a=a.yData;var e=b.period,f=!0,g;if(g=c.get(b.volumeSeriesID))return p(a[0])||(f=!1),this.calculateVWAPValues(f,d,a,g,e);l("Series "+b.volumeSeriesID+" not found! Check `volumeSeriesID`.",!0,c)};d.prototype.calculateVWAPValues=function(a,b,c,d,e){var f=d.yData,g=d.xData.length,k=b.length;d=[];var h=[],l=[],n=[],m=[],q;g=k<=g?k:g;for(q=k=0;k<g;k++){var t=a?(c[k][1]+c[k][2]+c[k][3])/3:
c[k];t*=f[k];t=q?d[k-1]+t:t;var p=q?h[k-1]+f[k]:f[k];d.push(t);h.push(p);m.push([b[k],t/p]);l.push(m[k][0]);n.push(m[k][1]);q++;q===e&&(q=0)}return{values:m,xData:l,yData:n}};d.defaultOptions=t(m.defaultOptions,{params:{index:void 0,period:30,volumeSeriesID:"volume"}});return d}(m);f.registerSeriesType("vwap",e);"";return e});v(f,"Stock/Indicators/WilliamsR/WilliamsRIndicator.js",[f["Stock/Indicators/ArrayUtilities.js"],f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=
this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=e.seriesTypes.sma,p=h.extend,t=h.isArray,g=h.merge;h=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=
void 0;a.points=void 0;return a}m(a,d);a.prototype.getValues=function(a,c){c=c.period;var b=a.xData,d=(a=a.yData)?a.length:0,e=[],g=[],h=[],l;if(!(b.length<c)&&t(a[0])&&4===a[0].length){for(l=c-1;l<d;l++){var m=a.slice(l-c+1,l+1);var n=f.getArrayExtremes(m,2,1);m=n[0];n=n[1];var p=a[l][3];m=(n-p)/(n-m)*-100;b[l]&&(e.push([b[l],m]),g.push(b[l]),h.push(m))}return{values:e,xData:g,yData:h}}};a.defaultOptions=g(l.defaultOptions,{params:{index:void 0,period:14}});return a}(l);p(h.prototype,{nameBase:"Williams %R"});
e.registerSeriesType("williamsr",h);"";return h});v(f,"Stock/Indicators/WMA/WMAIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){function h(d,a){a*=(a+1)/2;return d.reduce(function(a,c,d){return[null,a[1]+c[1]*(d+1)]})[1]/a}function m(d,a,b,c){b=h(d,d.length);a=a[c-1];d.shift();return[a,b]}var l=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&
(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),p=f.seriesTypes.sma,t=e.isArray,g=e.merge;e=function(d){function a(){var a=null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}l(a,d);a.prototype.getValues=function(a,c){var b=c.period,d=a.xData,e=(a=a.yData)?a.length:0,f=1,g=d[0],h=a[0],l=[],n=[],p=[],q=-1;if(!(d.length<b)){t(a[0])&&(q=c.index,
h=a[0][q]);for(c=[[g,h]];f!==b;)c.push([d[f],0>q?a[f]:a[f][q]]),f++;for(b=f;b<e;b++)f=m(c,d,a,b),l.push(f),n.push(f[0]),p.push(f[1]),c.push([d[b],0>q?a[b]:a[b][q]]);f=m(c,d,a,b);l.push(f);n.push(f[0]);p.push(f[1]);return{values:l,xData:n,yData:p}}};a.defaultOptions=g(p.defaultOptions,{params:{index:3,period:9}});return a}(p);f.registerSeriesType("wma",e);"";return e});v(f,"Stock/Indicators/Zigzag/ZigzagIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&
this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.sma,l=e.merge;e=e.extend;var p=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.points=void 0;d.options=
void 0;return d}h(f,e);f.prototype.getValues=function(d,a){var b=a.lowIndex,c=a.highIndex,e=a.deviation/100;a=1+e;var f=1-e;e=d.xData;var g=d.yData;d=g?g.length:0;var h=[],l=[],m=[],r,n,t=!1,q=!1;if(!(!e||1>=e.length||d&&("undefined"===typeof g[0][b]||"undefined"===typeof g[0][c]))){var p=g[0][b];var v=g[0][c];for(r=1;r<d;r++){if(g[r][b]<=v*f){h.push([e[0],v]);var y=[e[r],g[r][b]];t=n=!0}else g[r][c]>=p*a&&(h.push([e[0],p]),y=[e[r],g[r][c]],n=!1,t=!0);if(t){l.push(h[0][0]);m.push(h[0][1]);var M=r++;
r=d}}for(r=M;r<d;r++)n?(g[r][b]<=y[1]&&(y=[e[r],g[r][b]]),g[r][c]>=y[1]*a&&(q=c)):(g[r][c]>=y[1]&&(y=[e[r],g[r][c]]),g[r][b]<=y[1]*f&&(q=b)),!1!==q&&(h.push(y),l.push(y[0]),m.push(y[1]),y=[e[r],g[r][q]],n=!n,q=!1);b=h.length;0!==b&&h[b-1][0]<e[d-1]&&(h.push(y),l.push(y[0]),m.push(y[1]));return{values:h,xData:l,yData:m}}};f.defaultOptions=l(m.defaultOptions,{params:{index:void 0,period:void 0,lowIndex:2,highIndex:1,deviation:1}});return f}(m);e(p.prototype,{nameComponents:["deviation"],nameSuffixes:["%"],
nameBase:"Zig Zag"});f.registerSeriesType("zigzag",p);"";return p});v(f,"Stock/Indicators/LinearRegression/LinearRegression.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===
a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.isArray,p=e.extend,t=e.merge;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(d,e);d.prototype.getRegressionLineParameters=function(a,b){var c=this.options.params.index,d=function(a,b){return l(a)?a[b]:a},e=a.reduce(function(a,b){return b+a},0),f=b.reduce(function(a,b){return d(b,c)+a},0);e/=a.length;f/=b.length;var g=0,h=0,m;for(m=0;m<a.length;m++){var r=
a[m]-e;var n=d(b[m],c)-f;g+=r*n;h+=Math.pow(r,2)}a=h?g/h:0;return{slope:a,intercept:f-a*e}};d.prototype.getEndPointY=function(a,b){return a.slope*b+a.intercept};d.prototype.transformXData=function(a,b){var c=a[0];return a.map(function(a){return(a-c)/b})};d.prototype.findClosestDistance=function(a){var b,c;for(c=1;c<a.length-1;c++){var d=a[c]-a[c-1];0<d&&("undefined"===typeof b||d<b)&&(b=d)}return b};d.prototype.getValues=function(a,b){var c=a.xData;a=a.yData;b=b.period;var d,e={xData:[],yData:[],
values:[]},f=this.options.params.xAxisUnit||this.findClosestDistance(c);for(d=b-1;d<=c.length-1;d++){var g=d-b+1;var h=d+1;var l=c[d];var m=c.slice(g,h);g=a.slice(g,h);h=this.transformXData(m,f);m=this.getRegressionLineParameters(h,g);g=this.getEndPointY(m,h[h.length-1]);e.values.push({regressionLineParameters:m,x:l,y:g});e.xData.push(l);e.yData.push(g)}return e};d.defaultOptions=t(m.defaultOptions,{params:{xAxisUnit:null},tooltip:{valueDecimals:4}});return d}(m);p(e.prototype,{nameBase:"Linear Regression Indicator"});
f.registerSeriesType("linearRegression",e);"";return e});v(f,"Stock/Indicators/LinearRegressionSlopes/LinearRegressionSlopes.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===
d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.linearRegression,l=e.extend,p=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}h(f,e);f.prototype.getEndPointY=function(d){return d.slope};f.defaultOptions=p(m.defaultOptions);return f}(m);l(e.prototype,{nameBase:"Linear Regression Slope Indicator"});f.registerSeriesType("linearRegressionSlope",e);"";return e});v(f,"Stock/Indicators/LinearRegressionIntercept/LinearRegressionIntercept.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.linearRegression,l=e.extend,p=e.merge;e=function(e){function f(){var d=
null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;return d}h(f,e);f.prototype.getEndPointY=function(d){return d.intercept};f.defaultOptions=p(m.defaultOptions);return f}(m);l(e.prototype,{nameBase:"Linear Regression Intercept Indicator"});f.registerSeriesType("linearRegressionIntercept",e);"";return e});v(f,"Stock/Indicators/LinearRegressionAngle/LinearRegressionAngle.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||
function(){var e=function(f,d){e=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return e(f,d)};return function(f,d){function a(){this.constructor=f}e(f,d);f.prototype=null===d?Object.create(d):(a.prototype=d.prototype,new a)}}(),m=f.seriesTypes.linearRegression,l=e.extend,p=e.merge;e=function(e){function f(){var d=null!==e&&e.apply(this,arguments)||this;d.data=void 0;d.options=void 0;d.points=void 0;
return d}h(f,e);f.prototype.slopeToAngle=function(d){return 180/Math.PI*Math.atan(d)};f.prototype.getEndPointY=function(d){return this.slopeToAngle(d.slope)};f.defaultOptions=p(m.defaultOptions,{tooltip:{pointFormat:'<span style="color:{point.color}">\u25cf</span>{series.name}: <b>{point.y}\u00b0</b><br/>'}});return f}(m);l(e.prototype,{nameBase:"Linear Regression Angle Indicator"});f.registerSeriesType("linearRegressionAngle",e);"";return e});v(f,"Stock/Indicators/ABands/ABandsIndicator.js",[f["Stock/Indicators/MultipleLinesComposition.js"],
f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e,h){var m=this&&this.__extends||function(){var d=function(a,b){d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return d(a,b)};return function(a,b){function c(){this.constructor=a}d(a,b);a.prototype=null===b?Object.create(b):(c.prototype=b.prototype,new c)}}(),l=e.seriesTypes.sma,p=h.correctFloat,t=h.extend,g=h.merge;h=function(d){function a(){var a=
null!==d&&d.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}m(a,d);a.prototype.getValues=function(a,c){var b=c.period,e=c.factor;c=c.index;var f=a.xData,g=(a=a.yData)?a.length:0,h=[],l=[],m=[],n=[],t=[],q;if(!(g<b)){for(q=0;q<=g;q++){if(q<g){var u=a[q][2];var v=a[q][1];var y=e;u=p(v-u)/(p(v+u)/2)*1E3*y;h.push(a[q][1]*p(1+2*u));l.push(a[q][2]*p(1-2*u))}if(q>=b){u=f.slice(q-b,q);var M=a.slice(q-b,q);y=d.prototype.getValues.call(this,{xData:u,yData:h.slice(q-b,q)},
{period:b});v=d.prototype.getValues.call(this,{xData:u,yData:l.slice(q-b,q)},{period:b});M=d.prototype.getValues.call(this,{xData:u,yData:M},{period:b,index:c});u=M.xData[0];y=y.yData[0];v=v.yData[0];M=M.yData[0];m.push([u,y,M,v]);n.push(u);t.push([y,M,v])}}return{values:m,xData:n,yData:t}}};a.defaultOptions=g(l.defaultOptions,{params:{period:20,factor:.001,index:3},lineWidth:1,topLine:{styles:{lineWidth:1}},bottomLine:{styles:{lineWidth:1}},dataGrouping:{approximation:"averages"}});return a}(l);
t(h.prototype,{areaLinesNames:["top","bottom"],linesApiNames:["topLine","bottomLine"],nameBase:"Acceleration Bands",nameComponents:["period","factor"],pointArrayMap:["top","middle","bottom"],pointValKey:"middle"});f.compose(h);e.registerSeriesType("abands",h);"";return h});v(f,"Stock/Indicators/TrendLine/TrendLineIndicator.js",[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var e=function(d,a){e=Object.setPrototypeOf||{__proto__:[]}instanceof
Array&&function(a,c){a.__proto__=c}||function(a,c){for(var b in c)c.hasOwnProperty(b)&&(a[b]=c[b])};return e(d,a)};return function(d,a){function b(){this.constructor=d}e(d,a);d.prototype=null===a?Object.create(a):(b.prototype=a.prototype,new b)}}(),m=f.seriesTypes.sma,l=e.extend,p=e.merge,t=e.isArray;e=function(e){function d(){var a=null!==e&&e.apply(this,arguments)||this;a.data=void 0;a.options=void 0;a.points=void 0;return a}h(d,e);d.prototype.getValues=function(a,b){var c=a.xData,d=a.yData;a=[];
var e=[],f=[],g=0,h=0,l=0,m=0,n=c.length,p=b.index;for(b=0;b<n;b++){var q=c[b];var u=t(d[b])?d[b][p]:d[b];g+=q;h+=u;l+=q*u;m+=q*q}d=(n*l-g*h)/(n*m-g*g);isNaN(d)&&(d=0);g=(h-d*g)/n;for(b=0;b<n;b++)q=c[b],u=d*q+g,a[b]=[q,u],e[b]=q,f[b]=u;return{xData:e,yData:f,values:a}};d.defaultOptions=p(m.defaultOptions,{params:{period:void 0,index:3}});return d}(m);l(e.prototype,{nameBase:"Trendline",nameComponents:!1});f.registerSeriesType("trendline",e);"";return e});v(f,"Stock/Indicators/DisparityIndex/DisparityIndexIndicator.js",
[f["Core/Series/SeriesRegistry.js"],f["Core/Utilities.js"]],function(f,e){var h=this&&this.__extends||function(){var a=function(b,c){a=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(a,b){a.__proto__=b}||function(a,b){for(var c in b)b.hasOwnProperty(c)&&(a[c]=b[c])};return a(b,c)};return function(b,c){function d(){this.constructor=b}a(b,c);b.prototype=null===c?Object.create(c):(d.prototype=c.prototype,new d)}}(),m=f.seriesTypes.sma,l=e.correctFloat,p=e.defined,t=e.extend,g=e.isArray,
d=e.merge;e=function(a){function b(){var b=null!==a&&a.apply(this,arguments)||this;b.averageIndicator=void 0;b.data=void 0;b.options=void 0;b.points=void 0;return b}h(b,a);b.prototype.init=function(){var a=arguments,b=a[1].params;this.averageIndicator=f.seriesTypes[b&&b.average?b.average:void 0]||m;this.averageIndicator.prototype.init.apply(this,a)};b.prototype.calculateDisparityIndex=function(a,b){return l(a-b)/b*100};b.prototype.getValues=function(a,b){var c=b.index,d=a.xData,e=a.yData,f=e?e.length:
0,h=[],k=[],l=[],m=this.averageIndicator,q=g(e[0]);b=m.prototype.getValues(a,b);a=b.yData;b=d.indexOf(b.xData[0]);if(a&&0!==a.length&&p(c)&&!(e.length<=b)){for(m=b;m<f;m++){var t=this.calculateDisparityIndex(q?e[m][c]:e[m],a[m-b]);h.push([d[m],t]);k.push(d[m]);l.push(t)}return{values:h,xData:k,yData:l}}};b.defaultOptions=d(m.defaultOptions,{params:{average:"sma",index:3},marker:{enabled:!1},dataGrouping:{approximation:"averages"}});return b}(m);t(e.prototype,{nameBase:"Disparity Index",nameComponents:["period",
"average"]});f.registerSeriesType("disparityindex",e);"";return e});v(f,"masters/indicators/indicators-all.src.js",[],function(){})});
//# sourceMappingURL=indicators-all.js.map