<?php

/** @var yii\web\View $this */

use yii\helpers\Html;
use practically\chartjs\Chart;
use dosamigos\chartjs\ChartJs;
use scotthuangzl\googlechart\GoogleChart;
use miloschuman\highcharts\Highcharts;
$this->title = 'About';
$this->params['breadcrumbs'][] = $this->title;


?>
<?php 
$amount = 20;
$collected = 50;
$due = 30;
?>

<div class="content">
<div id="graph" style="width:300px;height:300px">
</div>
</div>
<script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<script type="text/javascript">
    // Load the Visualization API and the piechart package.
 google.charts.load("current", { packages: ["corechart"] });
    // Set a callback to run when the Google Visualization API is loaded.
google.charts.setOnLoadCallback(createPIE);
    // Callback that creates and populates a data table,
    // instantiates the pie chart, passes in the data and
    // draws it.
function createPIE() {

    var options = {
        title: 'Fees Allocation',
        colors: ['#888', 'orange','red'],
        is3D: true
    };
  // Create our data table.   
var data = google.visualization.arrayToDataTable([
['status', 'Amount'],
['Total Amount', <?php echo $amount;?>],
['Collected', <?php echo $collected;?>],
['Due', <?php echo $due;?>]]);
var chart = new       google.visualization.PieChart(document.getElementById('graph'));
chart.draw(data, options); 

}
</script>
<?php
    
    echo Chart::widget([
    'type' => Chart::TYPE_BAR,
    'datasets' => [
        [
            'data' => [
                'Label 1' => 10,
                'Label 2' => 20,
                'Label 3' => 30
            ]
        ]
    ]
]);
?>

<div class="col-sm-5">
            <?php
            
    
            echo GoogleChart::widget(array('visualization' => 'PieChart',
                'data' => array(
                    array('Task', 'Hours per Day'),
                    array('Work', 11),
                    array('Eat', 2),
                    array('Commute', 2),
                    array('Watch TV', 2),
                    array('Sleep', 7)
                ),
                'options' => array('title' => 'My Daily Activity')));
            echo GoogleChart::widget(array('visualization' => 'LineChart',
                'data' => array(
                    array('Task', 'Hours per Day'),
                    array('Work', 11),
                    array('Eat', 2),
                    array('Commute', 2),
                    array('Watch TV', 2),
                    array('Sleep', 7)
                ),
                'options' => array('title' => 'My Daily Activity')));
    
            echo GoogleChart::widget(array('visualization' => 'LineChart',
                'data' => array(
                    array('Year', 'Sales', 'Expenses'),
                    array('2004', 1000, 400),
                    array('2005', 1170, 460),
                    array('2006', 660, 1120),
                    array('2007', 1030, 540),
                ),
                'options' => array(
                    'title' => 'My Company Performance2',
                    'titleTextStyle' => array('color' => '#FF0000'),
                    'vAxis' => array(
                        'title' => 'Scott vAxis',
                        'gridlines' => array(
                            'color' => 'transparent'  //set grid line transparent
                        )),
                    'hAxis' => array('title' => 'Scott hAixs'),
                    'curveType' => 'function', //smooth curve or not
                    'legend' => array('position' => 'bottom'),
                )));
            echo GoogleChart::widget( array('visualization' => 'Gauge', 'packages' => 'gauge',
                'data' => array(
                    array('Label', 'Value'),
                    array('Memory', 80),
                    array('CPU', 55),
                    array('Network', 68),
                ),
                'options' => array(
                    'width' => 400,
                    'height' => 120,
                    'redFrom' => 90,
                    'redTo' => 100,
                    'yellowFrom' => 75,
                    'yellowTo' => 90,
                    'minorTicks' => 5
                )
            ));
            echo GoogleChart::widget( array('visualization' => 'Map',
                'packages'=>'map',//default is corechart
                'loadVersion'=>1,//default is 1.  As for Calendar, you need change to 1.1
                'data' => array(
                    ['Country', 'Population'],
                    ['China', 'China: 1,363,800,000'],
                    ['India', 'India: 1,242,620,000'],
                    ['US', 'US: 317,842,000'],
                    ['Indonesia', 'Indonesia: 247,424,598'],
                    ['Brazil', 'Brazil: 201,032,714'],
                    ['Pakistan', 'Pakistan: 186,134,000'],
                    ['Nigeria', 'Nigeria: 173,615,000'],
                    ['Bangladesh', 'Bangladesh: 152,518,015'],
                    ['Russia', 'Russia: 146,019,512'],
                    ['Japan', 'Japan: 127,120,000']
                ),
                'options' => array('title' => 'My Daily Activity',
                    'showTip'=>true,
                )));


                echo Highcharts::widget([
                    'options' => [
                       'title' => ['text' => 'Fruit Consumption'],
                       'xAxis' => [
                          'categories' => ['Apples', 'Bananas', 'Oranges']
                       ],
                       'yAxis' => [
                          'title' => ['text' => 'Fruit eaten']
                       ],
                       'series' => [
                          ['name' => 'Jane', 'data' => [1, 0, 4]],
                          ['name' => 'John', 'data' => [5, 7, 3]]
                       ]
                    ]
                 ]);

            ?>
        </div>
       
<div class="site-about">
    <h1><?= Html::encode($this->title) ?></h1>
    <p>
        This is the About page. You may modify the following file to customize its content:
    </p>

    <code><?= __FILE__ ?></code>
</div>
