<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model app\models\QtaConfig */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="qta-config-form">

    <?php $form = ActiveForm::begin(); ?>

    
    <?= $form->field($model, 'configID')->dropDownList(        
            ArrayHelper::map($datagateway,'configID','gatewayName'),
            
            ['options' => [$dataProvider[0]['configID'] => ['Selected'=>'selected']]],
            [
            'prompt' => 'Select Gateway'
    ]) ?>

    <?= $form->field($model, 'slaveID')->textInput() ?>

    
    <?= $form->field($model, 'deviceMasterID')->dropDownList(        
            ArrayHelper::map($datadevicemaster,'deviceMasterID','deviceModel'),
            
            ['options' => [$dataProvider[0]['deviceMasterID'] => ['Selected'=>'selected']]],
            [
            'prompt' => 'Select Device Master'
    ]) ?>

    <?= $form->field($model, 'timeOut')->textInput() ?>

    <?= $form->field($model, 'delayQueryAfterResponse')->textInput() ?>

    <?= $form->field($model, 'addressMinusValue')->textInput() ?>

    <?= $form->field($model, 'ipIndex0')->textInput() ?>

    <?= $form->field($model, 'ipIndex1')->textInput() ?>

    <?= $form->field($model, 'ipIndex2')->textInput() ?>

    <?= $form->field($model, 'ipIndex3')->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
