<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\MapDataTypeSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Map Data Types');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="map-data-type-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Add New'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php  //echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
           // ['class' => 'yii\grid\SerialColumn'],

            //'mapDataTypeID',
            'mapDataTypeName',
            'mapDataTypeSymbol',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\Models\MapDataType $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'mapDataTypeID' => $model->mapDataTypeID]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
