<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\GaugeDial */

$this->title = $model->gaugeDialSettingID;
$this->params['breadcrumbs'][] = ['label' => 'Gauge Dials', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="gauge-dial-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'gaugeDialSettingID' => $model->gaugeDialSettingID], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'gaugeDialSettingID' => $model->gaugeDialSettingID], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'gaugeDialSettingID',
            'gaugeDialSettingName',
            'gaugeDialSettingMinValue',
            'gaugeDialSettingMaxValue',
            'gaugeDialSettingMajorTicks',
            'gaugeDialSettingMinorTicks',
            'gaugeDialSettingGreenMarkStarts',
            'gaugeDialSettingGreenMarkEnd',
            'gaugeDialSettingRedMarkStarts',
            'gaugeDialSettingRedMarkEnd',
            'gaugeDialSettingAddRedMarkStarts',
            'gaugeDialSettingAddRedMarkEnd',
        ],
    ]) ?>

</div>
