<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel app\models\GaugeDialSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Manage Gauge Dials';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="gauge-dial-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Add New', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php Pjax::begin(); ?>
    <?php  echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
           // ['class' => 'yii\grid\SerialColumn'],

           // 'gaugeDialSettingID',
            'gaugeDialSettingName',
            'gaugeDialSettingMinValue',
            'gaugeDialSettingMaxValue',
           // 'gaugeDialSettingMajorTicks',
            //'gaugeDialSettingMinorTicks',
            //'gaugeDialSettingGreenMarkStarts',
            //'gaugeDialSettingGreenMarkEnd',
            //'gaugeDialSettingRedMarkStarts',
            //'gaugeDialSettingRedMarkEnd',
            //'gaugeDialSettingAddRedMarkStarts',
            //'gaugeDialSettingAddRedMarkEnd',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\Models\GaugeDial $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'gaugeDialSettingID' => $model->gaugeDialSettingID]);
                 }
            ],
        ],
    ]); ?>

    <?php Pjax::end(); ?>

</div>
