<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Gateway */

$this->title = $model->gatewayID;
$this->params['breadcrumbs'][] = ['label' => 'Gateways', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="gateway-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'gatewayID' => $model->gatewayID], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'gatewayID' => $model->gatewayID], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'gatewayID',
            'siteID',
            'gatewaySerialNumber',
            'gatewayName',
            'gatewayTypeID',
            'gatewayMobileNumber',
            'gatewayDataURL',
            'isLive',
            'isDebug',
        ],
    ]) ?>

</div>
