<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\GatewaySearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Gateways';
$this->params['breadcrumbs'][] = $this->title;


?>

<div class="gateway-index">

    <h1><?= Html::encode($this->title) ?></h1>
   
    <p>
        <?= Html::a('Add New', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    
    <table class="table table-striped table-bordered"><thead>
<tr>
<th><a href="/index.php?r=gateway%2Findex&amp;sort=mapDataTypeName" data-sort="mapDataTypeName">Site ID</a></th>
  <th><a href="/index.php?r=gateway%2Findex&amp;sort=mapDataTypeName" data-sort="mapDataTypeName">Gateway Name</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=mapMasterName" data-sort="mapMasterName">Model</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=mapDataTypeName" data-sort="mapDataTypeName">Serial Number</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=gaugeDialSettingName" data-sort="gaugeDialSettingName">Mobile Number</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=gaugeDialSettingName" data-sort="gaugeDialSettingName">data Interval</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=gaugeDialSettingName" data-sort="gaugeDialSettingName">Baud Rate</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=gaugeDialSettingName" data-sort="gaugeDialSettingName">Retry Count</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=gaugeDialSettingName" data-sort="gaugeDialSettingName">Device Type</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=deviceMapMasterPort" data-sort="deviceMapMasterPort">Is Live</a></th>
  <th><a href="/index.php?r=device-map-master-admin%2Findex&amp;sort=deviceMapMasterMF" data-sort="deviceMapMasterMF">Manage</a></th>
  
</tr>
</thead>
<tbody>
<?php foreach($dataProvider as $data){?>
<tr data-key="1">
<td><?php echo $data['siteID']?></td>
  <td><?php echo $data['gatewayName']?></td>  
    <td><?php echo 'DCM 4G Modem';//$data['gatewayTypeName'].' ('.$data['gatewayTypeModel'].')'?></td>
    <td><?php echo $data['gatewaySerialnumber']?></td>
    <td><?php echo $data['gatewayMobileNumber']?></td>
    <td><?php echo $data['dataInterval']?></td>
    <td><?php echo $data['baudRate']?></td>
    <td><?php echo $data['retryCount']?></td>
    <td><?php echo $data['deviceType']?></td>

  <td><a href="index.php?r=gateway/index&display=<?php echo $data['isLive']?>&id=<?php echo $data['gatewayID']?>"><?php if($data['isLive']==1){
   echo Html::img('@web/dist/img/onImg.png', ['class' => 'pull-left img-responsive']); 
  }else{
    echo Html::img('@web/dist/img/offImg.png', ['class' => 'pull-left img-responsive']);
  }
   ?></a></td>
  <td><a href="index.php?r=gateway/view&gatewayID=<?php echo $data['gatewayID']?>" title="View" aria-label="View" data-pjax="0"><svg aria-hidden="true" style="display:inline-block;font-size:inherit;height:1em;overflow:visible;vertical-align:-.125em;width:1.125em" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path fill="currentColor" d="M573 241C518 136 411 64 288 64S58 136 3 241a32 32 0 000 30c55 105 162 177 285 177s230-72 285-177a32 32 0 000-30zM288 400a144 144 0 11144-144 144 144 0 01-144 144zm0-240a95 95 0 00-25 4 48 48 0 01-67 67 96 96 0 1092-71z"></path></svg></a> <a href="index.php?r=gateway/update&gatewayID=<?php echo $data['gatewayID']?>" title="Update" aria-label="Update" data-pjax="0"><svg aria-hidden="true" style="display:inline-block;font-size:inherit;height:1em;overflow:visible;vertical-align:-.125em;width:1em" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M498 142l-46 46c-5 5-13 5-17 0L324 77c-5-5-5-12 0-17l46-46c19-19 49-19 68 0l60 60c19 19 19 49 0 68zm-214-42L22 362 0 484c-3 16 12 30 28 28l122-22 262-262c5-5 5-13 0-17L301 100c-4-5-12-5-17 0zM124 340c-5-6-5-14 0-20l154-154c6-5 14-5 20 0s5 14 0 20L144 340c-6 5-14 5-20 0zm-36 84h48v36l-64 12-32-31 12-65h36v48z"></path></svg></a> <a href="index.php?r=gateway/delete&gatewayID=<?php echo $data['gatewayID']?>" title="Delete" aria-label="Delete" data-pjax="0" data-confirm="Are you sure you want to delete this item?" data-method="post"><svg aria-hidden="true" style="display:inline-block;font-size:inherit;height:1em;overflow:visible;vertical-align:-.125em;width:.875em" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M32 464a48 48 0 0048 48h288a48 48 0 0048-48V128H32zm272-256a16 16 0 0132 0v224a16 16 0 01-32 0zm-96 0a16 16 0 0132 0v224a16 16 0 01-32 0zm-96 0a16 16 0 0132 0v224a16 16 0 01-32 0zM432 32H312l-9-19a24 24 0 00-22-13H167a24 24 0 00-22 13l-9 19H16A16 16 0 000 48v32a16 16 0 0016 16h416a16 16 0 0016-16V48a16 16 0 00-16-16z"></path></svg></a></td></tr>
  <?php
   }

   //echo LinkPager::widget([
    //'pagination' => $pages,
//]);
  ?>
  
</tbody></table>

