<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Device */

$this->title = $model->deviceID;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Devices'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="device-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'deviceID' => $model->deviceID], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'deviceID' => $model->deviceID], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'deviceID',
            'deviceName',
            'deviceMasterID',
            'modBusID',
            'gatewayID',
            'parentID',
            'deviceReadingMeasurementID',
            'deviceDataHandlingID',
            'deviceDataForwardClientID',
            'deviceDataForwardTypeID',
            'deviceDataForwardURL',
            'deviceDataForwardToken',
            'sanctionedLoadKW',
            'sanctionedLoadKVA',
            'deviceLastData',
            'sortID',
            'isLive',
        ],
    ]) ?>

</div>
