<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

use yii\helpers\ArrayHelper;
/* @var $this yii\web\View */
/* @var $model app\models\Device */
/* @var $form yii\widgets\ActiveForm */
?>


<div class="device-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'deviceName')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'deviceMasterID')->dropDownList(        
            ArrayHelper::map($datadeviceMaster,'deviceMasterID','deviceMeter'),
            
            ['options' => [$dataProvider[0]['deviceMasterID'] => ['Selected'=>'selected']]],
            [
            'prompt' => 'Select Device'
    ]) ?>

    <?= $form->field($model, 'modBusID')->textInput() ?>

    <?= $form->field($model, 'gatewayID')->dropDownList(        
            ArrayHelper::map($datagateway,'gatewayID','gatewayName'),
            
            ['options' => [$dataProvider[0]['gatewayID'] => ['Selected'=>'selected']]],
            [
            'prompt' => 'Select Gateway'
    ]) ?>

<?= $form->field($model, 'parentID')->dropDownList(        
            ArrayHelper::map($datadevice,'deviceID','deviceName'),
            
            ['options' => [$dataProvider[0]['gatewayID'] => ['Selected'=>'selected']]],
            [
            'prompt' => 'Select Parent'
    ]) ?>

    <?= $form->field($model, 'deviceReadingMeasurementID')->textInput() ?>

    <?= $form->field($model, 'deviceDataHandlingID')->textInput() ?>

    <?= $form->field($model, 'deviceDataForwardClientID')->textInput() ?>

    <?= $form->field($model, 'deviceDataForwardTypeID')->textInput() ?>

    <?= $form->field($model, 'deviceDataForwardURL')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'deviceDataForwardToken')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'sanctionedLoadKW')->textInput() ?>

    <?= $form->field($model, 'sanctionedLoadKVA')->textInput() ?>

    <?= $form->field($model, 'deviceLastData')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'sortID')->textInput() ?>

    <?= $form->field($model, 'isLive')->textInput() ?>

    <?= $form->field($model, 'timeOut')->textInput() ?>

    <?= $form->field($model, 'delayQueryAfterResponse')->textInput() ?>

    <?= $form->field($model, 'addressMinusValue')->textInput() ?>

    <?= $form->field($model, 'ipIndex0')->textInput() ?>

    <?= $form->field($model, 'ipIndex1')->textInput() ?>

    <?= $form->field($model, 'ipIndex2')->textInput() ?>

    <?= $form->field($model, 'ipIndex3')->textInput() ?>

    <div class="form-group">
        <?= Html::submitButton(Yii::t('app', 'Save'), ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
