<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\DeviceMaster */

$this->title = $model->deviceMasterID;
$this->params['breadcrumbs'][] = ['label' => 'Device Masters', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="device-master-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'deviceMasterID' => $model->deviceMasterID], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'deviceMasterID' => $model->deviceMasterID], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'get',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'deviceMasterID',
            'deviceCompany',
            'deviceModel',
            'deviceTypeName',
            'isAvailable',
        ],
    ]) ?>

</div>
