<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\Config */

$this->title = $model->configID;
$this->params['breadcrumbs'][] = ['label' => 'Configs', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="config-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'configID' => $model->configID], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'configID' => $model->configID], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'get',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'configID',
            'comMethod',
            'comURL',
            'siteURL',
            'boxID',
            'userID',
            'password',
            'dataInterval',
            'statusInterval',
            'baudRate',
            'slaveID',
            'lineControl',
            'numOfMeters',
            'retryCount',
            'deviceType',
            'updateConfigure',
        ],
    ]) ?>

</div>
