<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\ConfigSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Modem Configs';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="config-index">

    <h1><?= Html::encode($this->title) ?></h1>

    
    <p>
        <?= Html::a(Yii::t('app', 'Add New'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php  //echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
           // ['class' => 'yii\grid\SerialColumn'],

            'configID',
            //'comMethod',
            //'comURL',
            'siteURL',
            'boxID',
            //'userID',
            //'password',
            'dataInterval',
            //'statusInterval',
            'baudRate',
            //'lineControl',
            //'numOfMeters',
            'retryCount',
            'deviceType',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\models\Config $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'configID' => $model->configID]);
                 }
            ],
        ],
    ]); ?>


</div>
