<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel app\models\ClientSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Clients');
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="client-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Create Client'), ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        //'filterModel' => $searchModel,
        'columns' => [
            //['class' => 'yii\grid\SerialColumn'],

            'clientID',
            'clientName',
            'clientDB',
            'clientDomain',
            //'clientDHash',
            'updateData',
            'serverID',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, \app\Models\Client $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'clientID' => $model->clientID]);
                 }
            ],
        ],
    ]); ?>


</div>
