<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model app\models\AutoReports */

$this->title = $model->autoReportID;
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Auto Reports'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="auto-reports-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a(Yii::t('app', 'Update'), ['update', 'autoReportID' => $model->autoReportID], ['class' => 'btn btn-primary']) ?>
        <?= Html::a(Yii::t('app', 'Delete'), ['delete', 'autoReportID' => $model->autoReportID], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => Yii::t('app', 'Are you sure you want to delete this item?'),
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'autoReportID',
            'autoReportType',
            'autoReportName',
            'autoReportTime',
            'autoReportEmails:email',
            'autoReportSubject',
            'autoReportMessage',
            'isLive:boolean',
        ],
    ]) ?>

</div>
