<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\SingleData;

/**
 * MapMasterSearch represents the model behind the search form of `app\models\MapMaster`.
 */
class SingleDataSearch extends SingleData
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['mapMasterID', 'sortID'], 'integer'],
            [['mapMasterCode', 'mapMasterName', 'dataTypeName'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = MapMaster::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'mapMasterID' => $this->mapMasterID,
            'sortID' => $this->sortID,
        ]);

        $query->andFilterWhere(['like', 'mapMasterCode', $this->mapMasterCode])
            ->andFilterWhere(['like', 'mapMasterName', $this->mapMasterName])
            ->andFilterWhere(['like', 'dataTypeName', $this->dataTypeName]);

        return $dataProvider;
    }
}
