<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "shifts".
 *
 * @property int $shiftID
 * @property int|null $siteID
 * @property string|null $shiftName
 * @property int|null $shiftStartHour
 * @property int|null $shiftStartMin
 * @property int|null $shiftEndHour
 * @property int|null $shiftEndMin
 */
class Shifts extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'shifts';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['shiftID'], 'required'],
            [['shiftID', 'siteID'], 'integer'],
            [['shiftStartHour', 'shiftStartMin', 'shiftEndHour', 'shiftEndMin'], 'string','max' => 5],
            [['shiftName'], 'string', 'max' => 250],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            //'shiftID' => 'Shift ID',
            'siteID' => 'Site ID',
            'shiftName' => 'Shift Name',
            'shiftStartHour' => 'Shift Start Time : Hour',
            'shiftStartMin' => 'Shift Start Time : Min',
            'shiftEndHour' => 'Shift End Time : Hour',
            'shiftEndMin' => 'Shift End Time : Min',
        ];
    }
}
