<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "qtaConfig".
 *
 * @property int $id
 * @property int $configID
 * @property int $slaveID
 * @property int|null $deviceMasterID
 * @property int $timeOut
 * @property int $delayQueryAfterResponse
 * @property int $addressMinusValue
 * @property int $ipIndex0
 * @property int $ipIndex1
 * @property int $ipIndex2
 * @property int $ipIndex3
 */
class QtaConfig extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'qtaConfig';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['configID', 'slaveID', 'timeOut', 'delayQueryAfterResponse', 'addressMinusValue', 'ipIndex0', 'ipIndex1', 'ipIndex2', 'ipIndex3'], 'required'],
            [['configID', 'slaveID', 'deviceMasterID', 'timeOut', 'delayQueryAfterResponse', 'addressMinusValue', 'ipIndex0', 'ipIndex1', 'ipIndex2', 'ipIndex3'], 'integer'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'configID' => 'Gateway',
            'slaveID' => 'Slave ID',
            'deviceMasterID' => 'Device Master ID',
            'timeOut' => 'Time Out',
            'delayQueryAfterResponse' => 'Delay Query After Response',
            'addressMinusValue' => 'Address Minus Value',
            'ipIndex0' => 'Ip Index 0',
            'ipIndex1' => 'Ip Index 1',
            'ipIndex2' => 'Ip Index 2',
            'ipIndex3' => 'Ip Index 3',
        ];
    }

    /**
     * {@inheritdoc}
     * @return QtaConfigQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new QtaConfigQuery(get_called_class());
    }
}
