<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "mapMaster".
 *
 * @property int $mapMasterID
 * @property string|null $mapMasterCode
 * @property string|null $mapMasterName
 * @property int|null $sortID
 * @property string|null $dataTypeName
 *
 * @property DeviceMapMasterAdmin[] $deviceMapMasterAdmins
 */
class MapMaster extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'mapMaster';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['sortID'], 'integer'],
            [['mapMasterCode'], 'string', 'max' => 50],
            [['mapMasterName'], 'string', 'max' => 150],
            [['dataTypeName'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'mapMasterID' => 'Map Master ID',
            'mapMasterCode' => 'Map Master Code',
            'mapMasterName' => 'Map Master Name',
            'sortID' => 'Sort ID',
            'dataTypeName' => 'Data Type Name',
        ];
    }

    /**
     * Gets query for [[DeviceMapMasterAdmins]].
     *
     * @return \yii\db\ActiveQuery|yii\db\ActiveQuery
     */
    public function getDeviceMapMasterAdmins()
    {
        return $this->hasMany(DeviceMapMasterAdmin::className(), ['mapMasterID' => 'mapMasterID']);
    }

    /**
     * {@inheritdoc}
     * @return MapMasterQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new MapMasterQuery(get_called_class());
    }
}
